'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _reactMotion = require('react-motion');

var _reactMeasure = require('react-measure');

var _reactMeasure2 = _interopRequireDefault(_reactMeasure);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _icon = require('./../../elements/icon/icon');

var _icon2 = _interopRequireDefault(_icon);

var _results = require('./results');

var _results2 = _interopRequireDefault(_results);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _animationUtils = require('../../animationUtils');

var _animationUtils2 = _interopRequireDefault(_animationUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/*
3 support results types:

{
    title: 'test',
    description: 'testing'
}

{
    animal: ['cat', 'dog']
}

['test', 'test']
*/
var Search = (_temp = _class = function (_React$Component) {
    _inherits(Search, _React$Component);

    /* eslint-enable */

    function Search(props) {
        _classCallCheck(this, Search);

        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Search).call(this, props));

        _this.onBlur = function () {
            if (_this.state.focus) {
                _this.setState({
                    focus: false
                });
            }
        };

        _this.onChange = function (e) {
            _this.props.onChange(e);
        };

        _this.onFocus = function () {
            _this.setState({
                focus: true
            });
        };

        _this.onSearchClick = function (e, child) {
            _this.props.onSearchClick(e, child);
        };

        _this.onMeasure = function (dimensions) {
            if (dimensions && (dimensions.height && dimensions.height !== _this.state.resultsHeight || dimensions.width && dimensions.width !== _this.state.resultsWidth)) {
                _this.setState({
                    resultsHeight: dimensions.height,
                    resultsWidth: dimensions.width
                });
            }
        };

        _this.state = {
            resultsHeight: 1,
            resultsWidth: 1,
            focus: false
        };
        return _this;
    }

    /* eslint-disable */


    _createClass(Search, [{
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }

        /**
         * Results dimensions was changed
         * @param dimensions
         */

    }, {
        key: 'renderInput',
        value: function renderInput() {
            return _react2.default.createElement(
                'div',
                { className: this.getClassesInput(),
                    key: 'searchInput'
                },
                _react2.default.createElement('input', { className: 'prompt',
                    onBlur: this.onBlur,
                    onChange: this.onChange,
                    onFocus: this.onFocus,
                    placeholder: this.props.placeholder,
                    type: 'text',
                    value: this.props.value }),
                this.renderInputIcon()
            );
        }
    }, {
        key: 'renderInputIcon',
        value: function renderInputIcon() {
            if (!this.props.icon) return null;

            return _react2.default.createElement(Search.Components.Icon, { name: this.props.icon });
        }
    }, {
        key: 'getAnimationStyle',
        value: function getAnimationStyle(interpolatedStyle, dimensions) {
            var onAnimationStyle = this.props.onAnimationStyle;

            if (onAnimationStyle) {
                return onAnimationStyle(interpolatedStyle, dimensions);
            }
            return {
                transform: 'scale(' + interpolatedStyle.scale + ')',
                opacity: interpolatedStyle.opacity
            };
        }
    }, {
        key: 'renderResults',
        value: function renderResults() {
            var _this2 = this;

            var resultProps = {
                key: 'searchResults',
                emptyHeader: this.props.emptyHeader,
                emptyMessage: this.props.emptyMessage,
                onSearchClick: this.onSearchClick,
                results: this.state.focus ? this.props.results : [],
                search: this.props.value || ''
            };

            var _props = this.props;
            var initialAnimation = _props.initialAnimation;
            var enterAnimation = _props.enterAnimation;
            var leaveAnimation = _props.leaveAnimation;

            var motionStyle = (0, _animationUtils.getMotionStyle)(initialAnimation, enterAnimation, leaveAnimation, !!(this.state.focus && this.props.value !== ''));

            return _react2.default.createElement(
                _reactMotion.Motion,
                { defaultStyle: initialAnimation,
                    style: motionStyle
                },
                function (interpolatedStyle) {
                    var animationStyle = _this2.getAnimationStyle(interpolatedStyle, { height: _this2.state.resultsHeight, width: _this2.state.resultsWidth });
                    return _react2.default.createElement(
                        _reactMeasure2.default,
                        { whitelist: ['height', 'width'],
                            accurate: true,
                            onMeasure: _this2.onMeasure,
                            key: 'measure'
                        },
                        _react2.default.createElement(Search.Components.Results, _extends({}, resultProps, { style: animationStyle, key: 'results' }))
                    );
                }
            );
        }
    }, {
        key: 'render',
        value: function render() {
            /* eslint-disable no-use-before-define */
            var _props2 = this.props;
            var children = _props2.children;
            var className = _props2.className;
            var component = _props2.component;
            var defaultClasses = _props2.defaultClasses;
            var emptyHeader = _props2.emptyHeader;
            var emptyMessage = _props2.emptyMessage;
            var initialAnimation = _props2.initialAnimation;
            var enterAnimation = _props2.enterAnimation;
            var icon = _props2.icon;
            var leaveAnimation = _props2.leaveAnimation;
            var loading = _props2.loading;
            var onChange = _props2.onChange;
            var onSearchClick = _props2.onSearchClick;
            var placeholder = _props2.placeholder;
            var results = _props2.results;
            var onAnimationStyle = _props2.onAnimationStyle;
            var value = _props2.value;

            var other = _objectWithoutProperties(_props2, ['children', 'className', 'component', 'defaultClasses', 'emptyHeader', 'emptyMessage', 'initialAnimation', 'enterAnimation', 'icon', 'leaveAnimation', 'loading', 'onChange', 'onSearchClick', 'placeholder', 'results', 'onAnimationStyle', 'value']);
            /* eslint-enable no-use-before-define */

            other.className = (0, _classnames2.default)(this.props.className, this.getClasses());
            var Component = component;
            return _react2.default.createElement(
                Component,
                other,
                this.renderInput(),
                ',',
                this.renderResults()
            );
        }
    }, {
        key: 'getClassesInput',
        value: function getClassesInput() {
            return (0, _classnames2.default)('ui input', {
                icon: Boolean(this.props.icon)
            });
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            return {
                ui: this.props.defaultClasses,
                search: this.props.defaultClasses,

                loading: this.props.loading,
                focus: this.state.focus,

                category: !Array.isArray(this.props.results)
            };
        }
    }]);

    return Search;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
    initialAnimation: {
        opacity: 0,
        scale: 0
    },
    enterAnimation: {
        opacity: (0, _reactMotion.spring)(1, { stiffness: 800, damping: 40, precision: 0.1 }),
        scale: (0, _reactMotion.spring)(1, { stiffness: 800, damping: 40, precision: 0.1 })
    },
    leaveAnimation: {
        opacity: (0, _reactMotion.spring)(0, { stiffness: 800, damping: 40, precision: 0.1 }),
        scale: (0, _reactMotion.spring)(0, { stiffness: 800, damping: 40, precision: 0.1 })
    },
    icon: 'search',
    onSearchClick: function noop() {},
    placeholder: 'Search...',
    value: ''
}), _class.Components = {
    Results: _results2.default,
    Icon: _icon2.default
}, _temp);
exports.default = Search;
//# sourceMappingURL=search.js.map