'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp2;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _tabmenu = require('./tabmenu');

var _tabmenu2 = _interopRequireDefault(_tabmenu);

var _tab = require('./tab');

var _tab2 = _interopRequireDefault(_tab);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Tabs = (_temp2 = _class = function (_React$Component) {
    _inherits(Tabs, _React$Component);

    function Tabs() {
        var _Object$getPrototypeO;

        var _temp, _this, _ret;

        _classCallCheck(this, Tabs);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_Object$getPrototypeO = Object.getPrototypeOf(Tabs)).call.apply(_Object$getPrototypeO, [this].concat(args))), _this), _this.onMenuChange = function (value) {
            var _this$props = _this.props;
            var onTabChange = _this$props.onTabChange;
            var activeTab = _this$props.activeTab;

            if (value && value !== activeTab) {
                onTabChange(value);
            }
        }, _temp), _possibleConstructorReturn(_this, _ret);
    }

    /* eslint-disable */


    _createClass(Tabs, [{
        key: 'shouldComponentUpdate',

        /* eslint-enable */

        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }
    }, {
        key: 'renderMenu',
        value: function renderMenu() {
            var activeTab = this.props.activeTab;
            // Menu should be first element

            var children = _react2.default.Children.toArray(this.props.children).shift();
            if (children && children.type === Tabs.Components.TabMenu) {
                return _react2.default.cloneElement(children, {
                    menuValue: activeTab,
                    onMenuChange: this.onMenuChange
                });
            }
            return null;
        }
    }, {
        key: 'renderTabs',
        value: function renderTabs() {
            var _props = this.props;
            var children = _props.children;
            var activeTab = _props.activeTab;

            var childrenWithoutMenu = _react2.default.Children.toArray(children);
            childrenWithoutMenu.shift();

            return childrenWithoutMenu.map(function (child) {
                if (!child || child.type !== Tabs.Components.Tab) {
                    return null;
                }

                return _react2.default.cloneElement(child, {
                    key: child.key ? child.key : child.props.value,
                    active: child.props.value === activeTab
                });
            });
        }
    }, {
        key: 'render',
        value: function render() {
            var _props2 = this.props;
            var component = _props2.component;
            var defaultClasses = _props2.defaultClasses;
            var children = _props2.children;
            var activeTab = _props2.activeTab;
            var onTabChange = _props2.onTabChange;

            var other = _objectWithoutProperties(_props2, ['component', 'defaultClasses', 'children', 'activeTab', 'onTabChange']);

            var Component = component;

            return _react2.default.createElement(
                Component,
                other,
                this.renderMenu(),
                this.renderTabs()
            );
        }
    }]);

    return Tabs;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
    onTabChange: function onTabChange() {}
}), _class.Components = {
    TabMenu: _tabmenu2.default,
    Tab: _tab2.default
}, _temp2);
exports.default = Tabs;
//# sourceMappingURL=tabs.js.map