'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _utilities = require('../../utilities');

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _value = require('./value');

var _value2 = _interopRequireDefault(_value);

var _label = require('../../elements/label/label');

var _label2 = _interopRequireDefault(_label);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validProps = {
    floated: ['right', 'left'],
    size: ['mini', 'tiny', 'small', 'large', 'huge']
};
/**
 * Statistic is view of elements. It could be statistic view or part of <Statistics /> view
 */
var Statistic = (_temp = _class = function (_React$Component) {
    _inherits(Statistic, _React$Component);

    /* eslint-enable */

    function Statistic(props) {
        _classCallCheck(this, Statistic);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(Statistic).call(this, props));
    }

    /* eslint-disable */


    _createClass(Statistic, [{
        key: 'getChildContext',
        value: function getChildContext() {
            return {
                isStatisticChild: true
            };
        }
    }, {
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }
    }, {
        key: 'render',
        value: function render() {
            /* eslint-disable no-use-before-define */
            var _props = this.props;
            var component = _props.component;
            var defaultClasses = _props.defaultClasses;
            var children = _props.children;
            var value = _props.value;
            var label = _props.label;
            var horizontal = _props.horizontal;
            var color = _props.color;
            var inverted = _props.inverted;
            var floated = _props.floated;
            var size = _props.size;

            var other = _objectWithoutProperties(_props, ['component', 'defaultClasses', 'children', 'value', 'label', 'horizontal', 'color', 'inverted', 'floated', 'size']);
            /* eslint-enable no-use-before-define */

            var Component = component;
            other.className = (0, _classnames2.default)(other.className, this.getClasses());

            children = children ? children : [];

            var typeOfValue = typeof value === 'undefined' ? 'undefined' : _typeof(value);
            var typeOfLabel = typeof label === 'undefined' ? 'undefined' : _typeof(label);
            if (typeOfValue === 'string' || typeOfValue === 'number') {
                children.push(_react2.default.createElement(_value2.default, null, value));
            }
            if (typeOfLabel === 'string' || typeOfLabel === 'number') {
                children.push(_react2.default.createElement(_label2.default, null, label));
            }
            return _react2.default.createElement(
                Component,
                other,
                children
            );
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            var classes = {
                ui: this.props.defaultClasses && !this.context.isStatisticsChild,

                // position,
                left: false,
                right: false,

                // variations
                horizontal: this.props.horizontal,
                inverted: this.props.inverted,
                floated: this.props.floated,

                // component
                statistic: this.props.defaultClasses
            };

            classes[this.props.color] = !!this.props.color;
            classes[this.props.size] = !!this.props.size;
            classes[this.props.floated] = !!this.props.floated;

            return classes;
        }
    }]);

    return Statistic;
}(_react2.default.Component), _class.contextTypes = {
    isStatisticsChild: _react2.default.PropTypes.bool
}, _class.childContextTypes = {
    isStatisticChild: _react2.default.PropTypes.bool
}, _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
    inverted: false,
    horizontal: false
}), _class.Components = {
    Value: _value2.default,
    Label: _label2.default
}, _temp);
exports.default = Statistic;
//# sourceMappingURL=statistic.js.map