## Image

    <Image src="http://semantic-ui.com/images/wireframe/image.png"/>

## You can wrap image as child element of another element:

    <div>
        <Image src="http://semantic-ui.com/images/wireframe/image.png" wrapComponent/>
        <Image src="http://semantic-ui.com/images/wireframe/image.png" wrapComponent="a"/>
    </div>

## States:

### Hidden

    <Image state="hidden" src="http://semantic-ui.com/images/wireframe/image.png"/>

### Disabled

    <Image state="disabled" src="http://semantic-ui.com/images/wireframe/image.png"/>

## Variations:

### Avatar

    <Image avatar src="http://semantic-ui.com/images/wireframe/square-image.png"/>

### Bordered

    <Image bordered src="http://semantic-ui.com/images/wireframe/white-image.png"/>

### Fluid

    <Image fluid src="http://semantic-ui.com/images/wireframe/image.png"/>

### Rounded

    <Image shape="rounded" src="http://semantic-ui.com/images/wireframe/image.png"/>

### Circular

    <Image shape="circular" src="http://semantic-ui.com/images/wireframe/image.png"/>

### Aligned

    <div>
        <Image src="http://semantic-ui.com/images/wireframe/square-image.png" size="tiny" aligned="top"/>
        <span>Top aligned</span>
        <Image src="http://semantic-ui.com/images/wireframe/square-image.png" size="tiny" aligned="middle"/>
        <span>Middle aligned</span>
        <Image src="http://semantic-ui.com/images/wireframe/square-image.png" size="tiny" aligned="bottom"/>
        <span>Bottom aligned</span>
    </div>

### Centered

    <Segment>
        <Image src="http://semantic-ui.com/images/wireframe/text-image.png" centered size="medium"/>
        <p>Eu quo homero blandit intellegebat. Incorrupte consequuntur mei id. Mei ut facer dolores adolescens, no illum aperiri quo, usu odio brute at. Qui te porro electram, ea dico facete utroque quo. Populo quodsi te eam, wisi everti eos ex, eum elitr altera utamur at. Quodsi convenire mnesarchum eu per, quas minimum postulant per id.</p>
    </Segment>

### Spaced

    <Segment>
        <p>Te eum doming eirmod, nominati pertinacia <Image size="mini" spaced src="http://semantic-ui.com/images/wireframe/image.png"/> argumentum ad his. Ex eam alia facete scriptorem, est autem aliquip detraxit at. Usu ocurreret referrentur at, cu epicurei appellantur vix. Cum ea laoreet recteque electram, eos choro alterum definiebas in. Vim dolorum definiebas an. Mei ex natum rebum iisque.</p>
    </Segment>

### Floated

    <Segment>
        <Image size="small" floated="left" src="http://semantic-ui.com/images/wireframe/text-image.png"/>
        <p>Te eum doming eirmod, nominati pertinacia argumentum ad his. Ex eam alia facete scriptorem, est autem aliquip detraxit at. Usu ocurreret referrentur at, cu epicurei appellantur vix. Cum ea laoreet recteque electram, eos choro alterum definiebas in. Vim dolorum definiebas an. Mei ex natum rebum iisque.</p>
        <Image size="small" floated="right" src="http://semantic-ui.com/images/wireframe/text-image.png"/>
        <p>Te eum doming eirmod, nominati pertinacia argumentum ad his. Ex eam alia facete scriptorem, est autem aliquip detraxit at. Usu ocurreret referrentur at, cu epicurei appellantur vix. Cum ea laoreet recteque electram, eos choro alterum definiebas in. Vim dolorum definiebas an. Mei ex natum rebum iisque.</p>
        <p>Te eum doming eirmod, nominati pertinacia argumentum ad his. Ex eam alia facete scriptorem, est autem aliquip detraxit at. Usu ocurreret referrentur at, cu epicurei appellantur vix. Cum ea laoreet recteque electram, eos choro alterum definiebas in. Vim dolorum definiebas an. Mei ex natum rebum iisque.</p>
    </Segment>

### Size

    <div>
        <Image size="mini" src="http://semantic-ui.com/images/wireframe/image.png"/>
        <Image size="tiny" src="http://semantic-ui.com/images/wireframe/image.png"/>
        <Image size="small" src="http://semantic-ui.com/images/wireframe/image.png"/>
        <Image size="medium" src="http://semantic-ui.com/images/wireframe/image.png"/>
        <Image size="large" src="http://semantic-ui.com/images/wireframe/image.png"/>
        <Image size="big" src="http://semantic-ui.com/images/wireframe/image.png"/>
        <Image size="huge" src="http://semantic-ui.com/images/wireframe/image.png"/>
        <Image size="massive" src="http://semantic-ui.com/images/wireframe/image.png"/>
    </div>
