import React from 'react';
import shallowCompare from 'react-addons-shallow-compare';
import classNames from 'classnames';
import DefaultProps from '../../defaultProps';

export default class Description extends React.Component {
    static propTypes = {
        ...DefaultProps.propTypes,
        hidden: React.PropTypes.bool,
        visible: React.PropTypes.bool
    };

    static defaultProps = {
        ...DefaultProps.defaultProps
    };

    shouldComponentUpdate(nextProps, nextState) {
        return shallowCompare(this, nextProps, nextState);
    }

    render() {
        /* eslint-disable no-use-before-define */
        let { defaultClasses, component, visible, hidden, ...other } = this.props;
        /* eslint-enable no-use-before-define */

        other.className = classNames(this.props.className, this.getClasses());

        return React.createElement(
            this.props.component,
            other,
            this.props.children
        );
    }

    getClasses() {
        return {
            // default
            description: this.props.defaultClasses,

            // animation
            visible: this.props.visible,
            hidden: this.props.hidden
        };
    }
}
