var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
define(["require", "exports", "moment", "react"], function (require, exports, moment_1, React) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    moment_1 = __importDefault(moment_1);
    React = __importStar(React);
    var BaseInput = /** @class */ (function (_super) {
        __extends(BaseInput, _super);
        function BaseInput() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.closePopup = function () {
                _this.setState({ popupIsClosed: true });
            };
            _this.openPopup = function () {
                _this.setState({ popupIsClosed: false });
            };
            _this.isPickerInFocus = function () {
                return document.activeElement === _this.calendarNode;
            };
            _this.isTriggerInFocus = function () {
                return document.activeElement === _this.inputNode;
            };
            _this.onModeSwitch = function () {
                // when using keyboard for selecting values on inline calendar
                // and when mode switches, picker looses focus.
                // In order to preserve focus on active picker
                // we call focus() on `calendarNode`.
                // `calendarNode` goes from *View component via
                // `this.onCalendarViewMount` callback
                if (_this.props.inline
                    && !_this.isPickerInFocus()
                    && _this.calendarNode) {
                    _this.calendarNode.focus();
                }
            };
            _this.onCalendarViewMount = function (calendarNode) {
                _this.calendarNode = calendarNode;
            };
            _this.onInputViewMount = function (inputNode) {
                _this.inputNode = inputNode;
            };
            return _this;
        }
        BaseInput.defaultProps = {
            inline: false,
            localization: moment_1.default.locale(),
        };
        return BaseInput;
    }(React.Component));
    exports.default = BaseInput;
});
