/*!
 * # Semantic UI 2.2.2 - Popup
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(t,e,o,n){"use strict";e="undefined"!=typeof e&&e.Math==Math?e:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),t.fn.popup=function(i){var r,a=t(this),s=t(o),p=t(e),l=t("body"),u=a.selector||"",c=!0,d=(new Date).getTime(),f=[],g=arguments[0],h="string"==typeof g,m=[].slice.call(arguments,1);return a.each(function(){var a,v,b,w,y,T,C=t.isPlainObject(i)?t.extend(!0,{},t.fn.popup.settings,i):t.extend({},t.fn.popup.settings),P=C.selector,x=C.className,k=C.error,S=C.metadata,E=C.namespace,A="."+C.namespace,D="module-"+E,O=t(this),j=t(C.context),F=t(C.scrollContext),R=t(C.boundary),H=C.target?t(C.target):O,N=0,M=!1,W=!1,G=this,I=O.data(D);T={initialize:function(){T.debug("Initializing",O),T.createID(),T.bind.events(),!T.exists()&&C.preserve&&T.create(),T.observeChanges(),T.instantiate()},instantiate:function(){T.verbose("Storing instance",T),I=T,O.data(D,I)},observeChanges:function(){"MutationObserver"in e&&(b=new MutationObserver(T.event.documentChanged),b.observe(o,{childList:!0,subtree:!0}),T.debug("Setting up mutation observer",b))},refresh:function(){C.popup?a=t(C.popup).eq(0):C.inline&&(a=H.nextAll(P.popup).eq(0),C.popup=a),C.popup?(a.addClass(x.loading),v=T.get.offsetParent(),a.removeClass(x.loading),C.movePopup&&T.has.popup()&&T.get.offsetParent(a)[0]!==v[0]&&(T.debug("Moving popup to the same offset parent as activating element"),a.detach().appendTo(v))):v=C.inline?T.get.offsetParent(H):T.has.popup()?T.get.offsetParent(a):l,v.is("html")&&v[0]!==l[0]&&(T.debug("Setting page as offset parent"),v=l),T.get.variation()&&T.set.variation()},reposition:function(){T.refresh(),T.set.position()},destroy:function(){T.debug("Destroying previous module"),b&&b.disconnect(),a&&!C.preserve&&T.removePopup(),clearTimeout(T.hideTimer),clearTimeout(T.showTimer),T.unbind.close(),T.unbind.events(),O.removeData(D)},event:{start:function(e){var o=t.isPlainObject(C.delay)?C.delay.show:C.delay;clearTimeout(T.hideTimer),W||(T.showTimer=setTimeout(T.show,o))},end:function(){var e=t.isPlainObject(C.delay)?C.delay.hide:C.delay;clearTimeout(T.showTimer),T.hideTimer=setTimeout(T.hide,e)},touchstart:function(t){W=!0,T.show()},resize:function(){T.is.visible()&&T.set.position()},documentChanged:function(e){[].forEach.call(e,function(e){e.removedNodes&&[].forEach.call(e.removedNodes,function(e){(e==G||t(e).find(G).length>0)&&(T.debug("Element removed from DOM, tearing down events"),T.destroy())})})},hideGracefully:function(e){var n=t(e.target),i=t.contains(o.documentElement,e.target),r=n.closest(P.popup).length>0;e&&!r&&i?(T.debug("Click occurred outside popup hiding popup"),T.hide()):T.debug("Click was inside popup, keeping popup open")}},create:function(){var e=T.get.html(),o=T.get.title(),n=T.get.content();e||n||o?(T.debug("Creating pop-up html"),e||(e=C.templates.popup({title:o,content:n})),a=t("<div/>").addClass(x.popup).data(S.activator,O).html(e),C.inline?(T.verbose("Inserting popup element inline",a),a.insertAfter(O)):(T.verbose("Appending popup element to body",a),a.appendTo(j)),T.refresh(),T.set.variation(),C.hoverable&&T.bind.popup(),C.onCreate.call(a,G)):0!==H.next(P.popup).length?(T.verbose("Pre-existing popup found"),C.inline=!0,C.popup=H.next(P.popup).data(S.activator,O),T.refresh(),C.hoverable&&T.bind.popup()):C.popup?(t(C.popup).data(S.activator,O),T.verbose("Used popup specified in settings"),T.refresh(),C.hoverable&&T.bind.popup()):T.debug("No content specified skipping display",G)},createID:function(){y=(Math.random().toString(16)+"000000000").substr(2,8),w="."+y,T.verbose("Creating unique id for element",y)},toggle:function(){T.debug("Toggling pop-up"),T.is.hidden()?(T.debug("Popup is hidden, showing pop-up"),T.unbind.close(),T.show()):(T.debug("Popup is visible, hiding pop-up"),T.hide())},show:function(t){if(t=t||function(){},T.debug("Showing pop-up",C.transition),T.is.hidden()&&(!T.is.active()||!T.is.dropdown())){if(T.exists()||T.create(),C.onShow.call(a,G)===!1)return void T.debug("onShow callback returned false, cancelling popup animation");C.preserve||C.popup||T.refresh(),a&&T.set.position()&&(T.save.conditions(),C.exclusive&&T.hideAll(),T.animate.show(t))}},hide:function(t){if(t=t||function(){},T.is.visible()||T.is.animating()){if(C.onHide.call(a,G)===!1)return void T.debug("onHide callback returned false, cancelling popup animation");T.remove.visible(),T.unbind.close(),T.restore.conditions(),T.animate.hide(t)}},hideAll:function(){t(P.popup).filter("."+x.visible).each(function(){t(this).data(S.activator).popup("hide")})},exists:function(){return a?C.inline||C.popup?T.has.popup():a.closest(j).length>=1?!0:!1:!1},removePopup:function(){T.has.popup()&&!C.popup&&(T.debug("Removing popup",a),a.remove(),a=n,C.onRemove.call(a,G))},save:{conditions:function(){T.cache={title:O.attr("title")},T.cache.title&&O.removeAttr("title"),T.verbose("Saving original attributes",T.cache.title)}},restore:{conditions:function(){return T.cache&&T.cache.title&&(O.attr("title",T.cache.title),T.verbose("Restoring original attributes",T.cache.title)),!0}},supports:{svg:function(){return typeof SVGGraphicsElement===n}},animate:{show:function(e){e=t.isFunction(e)?e:function(){},C.transition&&t.fn.transition!==n&&O.transition("is supported")?(T.set.visible(),a.transition({animation:C.transition+" in",queue:!1,debug:C.debug,verbose:C.verbose,duration:C.duration,onComplete:function(){T.bind.close(),e.call(a,G),C.onVisible.call(a,G)}})):T.error(k.noTransition)},hide:function(e){return e=t.isFunction(e)?e:function(){},T.debug("Hiding pop-up"),C.onHide.call(a,G)===!1?void T.debug("onHide callback returned false, cancelling popup animation"):void(C.transition&&t.fn.transition!==n&&O.transition("is supported")?a.transition({animation:C.transition+" out",queue:!1,duration:C.duration,debug:C.debug,verbose:C.verbose,onComplete:function(){T.reset(),e.call(a,G),C.onHidden.call(a,G)}}):T.error(k.noTransition))}},change:{content:function(t){a.html(t)}},get:{html:function(){return O.removeData(S.html),O.data(S.html)||C.html},title:function(){return O.removeData(S.title),O.data(S.title)||C.title},content:function(){return O.removeData(S.content),O.data(S.content)||O.attr("title")||C.content},variation:function(){return O.removeData(S.variation),O.data(S.variation)||C.variation},popup:function(){return a},popupOffset:function(){return a.offset()},calculations:function(){var t,o=H[0],n=R[0]==e,i=C.inline||C.popup&&C.movePopup?H.position():H.offset(),r=n?{top:0,left:0}:R.offset(),s={},l=n?{top:p.scrollTop(),left:p.scrollLeft()}:{top:0,left:0};return s={target:{element:H[0],width:H.outerWidth(),height:H.outerHeight(),top:i.top,left:i.left,margin:{}},popup:{width:a.outerWidth(),height:a.outerHeight()},parent:{width:v.outerWidth(),height:v.outerHeight()},screen:{top:r.top,left:r.left,scroll:{top:l.top,left:l.left},width:R.width(),height:R.height()}},C.setFluidWidth&&T.is.fluid()&&(s.container={width:a.parent().outerWidth()},s.popup.width=s.container.width),s.target.margin.top=C.inline?parseInt(e.getComputedStyle(o).getPropertyValue("margin-top"),10):0,s.target.margin.left=C.inline?T.is.rtl()?parseInt(e.getComputedStyle(o).getPropertyValue("margin-right"),10):parseInt(e.getComputedStyle(o).getPropertyValue("margin-left"),10):0,t=s.screen,s.boundary={top:t.top+t.scroll.top,bottom:t.top+t.scroll.top+t.height,left:t.left+t.scroll.left,right:t.left+t.scroll.left+t.width},s},id:function(){return y},startEvent:function(){return"hover"==C.on?"mouseenter":"focus"==C.on?"focus":!1},scrollEvent:function(){return"scroll"},endEvent:function(){return"hover"==C.on?"mouseleave":"focus"==C.on?"blur":!1},distanceFromBoundary:function(t,e){var o,n,i={};return e=e||T.get.calculations(),o=e.popup,n=e.boundary,t&&(i={top:t.top-n.top,left:t.left-n.left,right:n.right-(t.left+o.width),bottom:n.bottom-(t.top+o.height)},T.verbose("Distance from boundaries determined",t,i)),i},offsetParent:function(e){var o=e!==n?e[0]:O[0],i=o.parentNode,r=t(i);if(i)for(var a="none"===r.css("transform"),s="static"===r.css("position"),p=r.is("html");i&&!p&&s&&a;)i=i.parentNode,r=t(i),a="none"===r.css("transform"),s="static"===r.css("position"),p=r.is("html");return r&&r.length>0?r:t()},positions:function(){return{"top left":!1,"top center":!1,"top right":!1,"bottom left":!1,"bottom center":!1,"bottom right":!1,"left center":!1,"right center":!1}},nextPosition:function(t){var e=t.split(" "),o=e[0],n=e[1],i={top:"bottom",bottom:"top",left:"right",right:"left"},r={left:"center",center:"right",right:"left"},a={"top left":"top center","top center":"top right","top right":"right center","right center":"bottom right","bottom right":"bottom center","bottom center":"bottom left","bottom left":"left center","left center":"top left"},s="top"==o||"bottom"==o,p=!1,l=!1,u=!1;return M||(T.verbose("All available positions available"),M=T.get.positions()),T.debug("Recording last position tried",t),M[t]=!0,"opposite"===C.prefer&&(u=[i[o],n],u=u.join(" "),p=M[u]===!0,T.debug("Trying opposite strategy",u)),"adjacent"===C.prefer&&s&&(u=[o,r[n]],u=u.join(" "),l=M[u]===!0,T.debug("Trying adjacent strategy",u)),(l||p)&&(T.debug("Using backup position",u),u=a[t]),u}},set:{position:function(t,e){if(0===H.length||0===a.length)return void T.error(k.notFound);var o,i,r,s,p,l,u,c;if(e=e||T.get.calculations(),t=t||O.data(S.position)||C.position,o=O.data(S.offset)||C.offset,i=C.distanceAway,r=e.target,s=e.popup,p=e.parent,0===r.width&&0===r.height&&!T.is.svg(r.element))return T.debug("Popup target is hidden, no action taken"),!1;switch(C.inline&&(T.debug("Adding margin to calculation",r.margin),"left center"==t||"right center"==t?(o+=r.margin.top,i+=-r.margin.left):"top left"==t||"top center"==t||"top right"==t?(o+=r.margin.left,i-=r.margin.top):(o+=r.margin.left,i+=r.margin.top)),T.debug("Determining popup position from calculations",t,e),T.is.rtl()&&(t=t.replace(/left|right/g,function(t){return"left"==t?"right":"left"}),T.debug("RTL: Popup position updated",t)),N==C.maxSearchDepth&&"string"==typeof C.lastResort&&(t=C.lastResort),t){case"top left":l={top:"auto",bottom:p.height-r.top+i,left:r.left+o,right:"auto"};break;case"top center":l={bottom:p.height-r.top+i,left:r.left+r.width/2-s.width/2+o,top:"auto",right:"auto"};break;case"top right":l={bottom:p.height-r.top+i,right:p.width-r.left-r.width-o,top:"auto",left:"auto"};break;case"left center":l={top:r.top+r.height/2-s.height/2+o,right:p.width-r.left+i,left:"auto",bottom:"auto"};break;case"right center":l={top:r.top+r.height/2-s.height/2+o,left:r.left+r.width+i,bottom:"auto",right:"auto"};break;case"bottom left":l={top:r.top+r.height+i,left:r.left+o,bottom:"auto",right:"auto"};break;case"bottom center":l={top:r.top+r.height+i,left:r.left+r.width/2-s.width/2+o,bottom:"auto",right:"auto"};break;case"bottom right":l={top:r.top+r.height+i,right:p.width-r.left-r.width-o,left:"auto",bottom:"auto"}}if(l===n&&T.error(k.invalidPosition,t),T.debug("Calculated popup positioning values",l),a.css(l).removeClass(x.position).addClass(t).addClass(x.loading),u=T.get.popupOffset(),c=T.get.distanceFromBoundary(u,e),T.is.offstage(c,t)){if(T.debug("Position is outside viewport",t),N<C.maxSearchDepth)return N++,t=T.get.nextPosition(t),T.debug("Trying new position",t),a?T.set.position(t,e):!1;if(!C.lastResort)return T.debug("Popup could not find a position to display",a),T.error(k.cannotPlace,G),T.remove.attempts(),T.remove.loading(),T.reset(),C.onUnplaceable.call(a,G),!1;T.debug("No position found, showing with last position")}return T.debug("Position is on stage",t),T.remove.attempts(),T.remove.loading(),C.setFluidWidth&&T.is.fluid()&&T.set.fluidWidth(e),!0},fluidWidth:function(t){t=t||T.get.calculations(),T.debug("Automatically setting element width to parent width",t.parent.width),a.css("width",t.container.width)},variation:function(t){t=t||T.get.variation(),t&&T.has.popup()&&(T.verbose("Adding variation to popup",t),a.addClass(t))},visible:function(){O.addClass(x.visible)}},remove:{loading:function(){a.removeClass(x.loading)},variation:function(t){t=t||T.get.variation(),t&&(T.verbose("Removing variation",t),a.removeClass(t))},visible:function(){O.removeClass(x.visible)},attempts:function(){T.verbose("Resetting all searched positions"),N=0,M=!1}},bind:{events:function(){T.debug("Binding popup events to module"),"click"==C.on&&O.on("click"+A,T.toggle),"hover"==C.on&&c&&O.on("touchstart"+A,T.event.touchstart),T.get.startEvent()&&O.on(T.get.startEvent()+A,T.event.start).on(T.get.endEvent()+A,T.event.end),C.target&&T.debug("Target set to element",H),p.on("resize"+w,T.event.resize)},popup:function(){T.verbose("Allowing hover events on popup to prevent closing"),a&&T.has.popup()&&a.on("mouseenter"+A,T.event.start).on("mouseleave"+A,T.event.end)},close:function(){(C.hideOnScroll===!0||"auto"==C.hideOnScroll&&"click"!=C.on)&&F.one(T.get.scrollEvent()+w,T.event.hideGracefully),"hover"==C.on&&W&&(T.verbose("Binding popup close event to document"),s.on("touchstart"+w,function(t){T.verbose("Touched away from popup"),T.event.hideGracefully.call(G,t)})),"click"==C.on&&C.closable&&(T.verbose("Binding popup close event to document"),s.on("click"+w,function(t){T.verbose("Clicked away from popup"),T.event.hideGracefully.call(G,t)}))}},unbind:{events:function(){p.off(w),O.off(A)},close:function(){s.off(w),F.off(w)}},has:{popup:function(){return a&&a.length>0}},is:{offstage:function(e,o){var n=[];return t.each(e,function(t,e){e<-C.jitter&&(T.debug("Position exceeds allowable distance from edge",t,e,o),n.push(t))}),n.length>0?!0:!1},svg:function(t){return T.supports.svg()&&t instanceof SVGGraphicsElement},active:function(){return O.hasClass(x.active)},animating:function(){return a!==n&&a.hasClass(x.animating)},fluid:function(){return a!==n&&a.hasClass(x.fluid)},visible:function(){return a!==n&&a.hasClass(x.visible)},dropdown:function(){return O.hasClass(x.dropdown)},hidden:function(){return!T.is.visible()},rtl:function(){return"rtl"==O.css("direction")}},reset:function(){T.remove.visible(),C.preserve?t.fn.transition!==n&&a.transition("remove transition"):T.removePopup()},setting:function(e,o){if(t.isPlainObject(e))t.extend(!0,C,e);else{if(o===n)return C[e];C[e]=o}},internal:function(e,o){if(t.isPlainObject(e))t.extend(!0,T,e);else{if(o===n)return T[e];T[e]=o}},debug:function(){!C.silent&&C.debug&&(C.performance?T.performance.log(arguments):(T.debug=Function.prototype.bind.call(console.info,console,C.name+":"),T.debug.apply(console,arguments)))},verbose:function(){!C.silent&&C.verbose&&C.debug&&(C.performance?T.performance.log(arguments):(T.verbose=Function.prototype.bind.call(console.info,console,C.name+":"),T.verbose.apply(console,arguments)))},error:function(){C.silent||(T.error=Function.prototype.bind.call(console.error,console,C.name+":"),T.error.apply(console,arguments))},performance:{log:function(t){var e,o,n;C.performance&&(e=(new Date).getTime(),n=d||e,o=e-n,d=e,f.push({Name:t[0],Arguments:[].slice.call(t,1)||"",Element:G,"Execution Time":o})),clearTimeout(T.performance.timer),T.performance.timer=setTimeout(T.performance.display,500)},display:function(){var e=C.name+":",o=0;d=!1,clearTimeout(T.performance.timer),t.each(f,function(t,e){o+=e["Execution Time"]}),e+=" "+o+"ms",u&&(e+=" '"+u+"'"),(console.group!==n||console.table!==n)&&f.length>0&&(console.groupCollapsed(e),console.table?console.table(f):t.each(f,function(t,e){console.log(e.Name+": "+e["Execution Time"]+"ms")}),console.groupEnd()),f=[]}},invoke:function(e,o,i){var a,s,p,l=I;return o=o||m,i=G||i,"string"==typeof e&&l!==n&&(e=e.split(/[\. ]/),a=e.length-1,t.each(e,function(o,i){var r=o!=a?i+e[o+1].charAt(0).toUpperCase()+e[o+1].slice(1):e;if(t.isPlainObject(l[r])&&o!=a)l=l[r];else{if(l[r]!==n)return s=l[r],!1;if(!t.isPlainObject(l[i])||o==a)return l[i]!==n?(s=l[i],!1):!1;l=l[i]}})),t.isFunction(s)?p=s.apply(i,o):s!==n&&(p=s),t.isArray(r)?r.push(p):r!==n?r=[r,p]:p!==n&&(r=p),s}},h?(I===n&&T.initialize(),T.invoke(g)):(I!==n&&I.invoke("destroy"),T.initialize())}),r!==n?r:this},t.fn.popup.settings={name:"Popup",silent:!1,debug:!1,verbose:!1,performance:!0,namespace:"popup",observeChanges:!0,onCreate:function(){},onRemove:function(){},onShow:function(){},onVisible:function(){},onHide:function(){},onUnplaceable:function(){},onHidden:function(){},on:"hover",boundary:e,addTouchEvents:!0,position:"top left",variation:"",movePopup:!0,target:!1,popup:!1,inline:!1,preserve:!1,hoverable:!1,content:!1,html:!1,title:!1,closable:!0,hideOnScroll:"auto",exclusive:!1,context:"body",scrollContext:e,prefer:"opposite",lastResort:!1,delay:{show:50,hide:70},setFluidWidth:!0,duration:200,transition:"scale",distanceAway:0,jitter:2,offset:0,maxSearchDepth:15,error:{invalidPosition:"The position you specified is not a valid position",cannotPlace:"Popup does not fit within the boundaries of the viewport",method:"The method you called is not defined.",noTransition:"This module requires ui transitions <https://github.com/Semantic-Org/UI-Transition>",notFound:"The target or popup you specified does not exist on the page"},metadata:{activator:"activator",content:"content",html:"html",offset:"offset",position:"position",title:"title",variation:"variation"},className:{active:"active",animating:"animating",dropdown:"dropdown",fluid:"fluid",loading:"loading",popup:"ui popup",position:"top left center bottom right",visible:"visible"},selector:{popup:".ui.popup"},templates:{escape:function(t){var e=/[&<>"'`]/g,o=/[&<>"'`]/,n={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},i=function(t){return n[t]};return o.test(t)?t.replace(e,i):t},popup:function(e){var o="",i=t.fn.popup.settings.templates.escape;return typeof e!==n&&(typeof e.title!==n&&e.title&&(e.title=i(e.title),o+='<div class="header">'+e.title+"</div>"),typeof e.content!==n&&e.content&&(e.content=i(e.content),o+='<div class="content">'+e.content+"</div>")),o}}}}(jQuery,window,document);