import type { Transaction } from '@sentry/types';
export declare const MAX_PROFILE_DURATION_MS = 30000;
/**
 * Safety wrapper for startTransaction for the unlikely case that transaction starts before tracing is imported -
 * if that happens we want to avoid throwing an error from profiling code.
 * see https://github.com/getsentry/sentry-javascript/issues/4731.
 *
 * @experimental
 */
export declare function onProfilingStartRouteTransaction(transaction: Transaction | undefined): Transaction | undefined;
/**
 * Wraps startTransaction and stopTransaction with profiling related logic.
 * startProfiling is called after the call to startTransaction in order to avoid our own code from
 * being profiled. Because of that same reason, stopProfiling is called before the call to stopTransaction.
 */
export declare function wrapTransactionWithProfiling(transaction: Transaction): Transaction;
//# sourceMappingURL=hubextensions.d.ts.map