Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const util = require('node:util');
const core = require('@sentry/core');

const INTEGRATION_NAME = 'Console';

/**
 * Capture console logs as breadcrumbs.
 */
const consoleIntegration = core.defineIntegration(() => {
  return {
    name: INTEGRATION_NAME,
    setup(client) {
      core.addConsoleInstrumentationHandler(({ args, level }) => {
        if (core.getClient() !== client) {
          return;
        }

        core.addBreadcrumb(
          {
            category: 'console',
            level: core.severityLevelFromString(level),
            message: util.format.apply(undefined, args),
          },
          {
            input: [...args],
            level,
          },
        );
      });
    },
  };
});

exports.consoleIntegration = consoleIntegration;
//# sourceMappingURL=console.js.map
