Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const index = require('../http/index.js');
const amqplib = require('./amqplib.js');
const connect = require('./connect.js');
const express = require('./express.js');
const fastify = require('./fastify.js');
const genericPool = require('./genericPool.js');
const graphql = require('./graphql.js');
const index$1 = require('./hapi/index.js');
const kafka = require('./kafka.js');
const koa = require('./koa.js');
const lrumemoizer = require('./lrumemoizer.js');
const mongo = require('./mongo.js');
const mongoose = require('./mongoose.js');
const mysql = require('./mysql.js');
const mysql2 = require('./mysql2.js');
const postgres = require('./postgres.js');
const redis = require('./redis.js');
const tedious = require('./tedious.js');
const index$2 = require('./vercelai/index.js');

/**
 * With OTEL, all performance integrations will be added, as OTEL only initializes them when the patched package is actually required.
 */
function getAutoPerformanceIntegrations() {
  return [
    express.expressIntegration(),
    fastify.fastifyIntegration(),
    graphql.graphqlIntegration(),
    mongo.mongoIntegration(),
    mongoose.mongooseIntegration(),
    mysql.mysqlIntegration(),
    mysql2.mysql2Integration(),
    redis.redisIntegration(),
    postgres.postgresIntegration(),
    // For now, we do not include prisma by default because it has ESM issues
    // See https://github.com/prisma/prisma/issues/23410
    // TODO v8: Figure out a better solution for this, maybe only disable in ESM mode?
    // prismaIntegration(),
    index$1.hapiIntegration(),
    koa.koaIntegration(),
    connect.connectIntegration(),
    tedious.tediousIntegration(),
    genericPool.genericPoolIntegration(),
    kafka.kafkaIntegration(),
    amqplib.amqplibIntegration(),
    lrumemoizer.lruMemoizerIntegration(),
    index$2.vercelAIIntegration(),
  ];
}

/**
 * Get a list of methods to instrument OTEL, when preload instrumentation.
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function getOpenTelemetryInstrumentationToPreload() {
  return [
    index.instrumentOtelHttp,
    express.instrumentExpress,
    express.instrumentExpressV5,
    connect.instrumentConnect,
    fastify.instrumentFastify,
    index$1.instrumentHapi,
    kafka.instrumentKafka,
    koa.instrumentKoa,
    lrumemoizer.instrumentLruMemoizer,
    mongo.instrumentMongo,
    mongoose.instrumentMongoose,
    mysql.instrumentMysql,
    mysql2.instrumentMysql2,
    postgres.instrumentPostgres,
    index$1.instrumentHapi,
    graphql.instrumentGraphql,
    redis.instrumentRedis,
    tedious.instrumentTedious,
    genericPool.instrumentGenericPool,
    amqplib.instrumentAmqplib,
    index$2.instrumentVercelAi,
  ];
}

exports.getAutoPerformanceIntegrations = getAutoPerformanceIntegrations;
exports.getOpenTelemetryInstrumentationToPreload = getOpenTelemetryInstrumentationToPreload;
//# sourceMappingURL=index.js.map
