import { InstrumentationBase, InstrumentationNodeModuleDefinition } from '@opentelemetry/instrumentation';
/**
 * A Sentry specific http instrumentation that is applied before the otel instrumentation.
 */
export declare class SentryHttpInstrumentationBeforeOtel extends InstrumentationBase {
    constructor();
    init(): [InstrumentationNodeModuleDefinition, InstrumentationNodeModuleDefinition];
    /** Get the instrumentation for the http module. */
    private _getHttpInstrumentation;
    /** Get the instrumentation for the https module. */
    private _getHttpsInstrumentation;
    /**
     * Patch the incoming request function for request isolation.
     */
    private _getPatchIncomingRequestFunction;
}
//# sourceMappingURL=SentryHttpInstrumentationBeforeOtel.d.ts.map