import { __assign } from "tslib";
import { getGlobalObject } from '@sentry/utils';
import hoistNonReactStatics from 'hoist-non-react-statics';
import * as React from 'react';
/* eslint-enable @typescript-eslint/no-explicit-any */
var global = getGlobalObject();
var activeTransaction;
export function reactRouterV4Instrumentation(history, routes, matchPath) {
    return createReactRouterInstrumentation(history, 'react-router-v4', routes, matchPath);
}
export function reactRouterV5Instrumentation(history, routes, matchPath) {
    return createReactRouterInstrumentation(history, 'react-router-v5', routes, matchPath);
}
function createReactRouterInstrumentation(history, name, allRoutes, matchPath) {
    if (allRoutes === void 0) { allRoutes = []; }
    function getInitPathName() {
        if (history && history.location) {
            return history.location.pathname;
        }
        if (global && global.location) {
            return global.location.pathname;
        }
        return undefined;
    }
    function getTransactionName(pathname) {
        if (allRoutes.length === 0 || !matchPath) {
            return pathname;
        }
        var branches = matchRoutes(allRoutes, pathname, matchPath);
        // eslint-disable-next-line @typescript-eslint/prefer-for-of
        for (var x = 0; x < branches.length; x++) {
            if (branches[x].match.isExact) {
                return branches[x].match.path;
            }
        }
        return pathname;
    }
    return function (customStartTransaction, startTransactionOnPageLoad, startTransactionOnLocationChange) {
        if (startTransactionOnPageLoad === void 0) { startTransactionOnPageLoad = true; }
        if (startTransactionOnLocationChange === void 0) { startTransactionOnLocationChange = true; }
        var initPathName = getInitPathName();
        if (startTransactionOnPageLoad && initPathName) {
            activeTransaction = customStartTransaction({
                name: getTransactionName(initPathName),
                op: 'pageload',
                tags: {
                    'routing.instrumentation': name,
                },
            });
        }
        if (startTransactionOnLocationChange && history.listen) {
            history.listen(function (location, action) {
                if (action && (action === 'PUSH' || action === 'POP')) {
                    if (activeTransaction) {
                        activeTransaction.finish();
                    }
                    var tags = {
                        'routing.instrumentation': name,
                    };
                    activeTransaction = customStartTransaction({
                        name: getTransactionName(location.pathname),
                        op: 'navigation',
                        tags: tags,
                    });
                }
            });
        }
    };
}
/**
 * Matches a set of routes to a pathname
 * Based on implementation from
 */
function matchRoutes(routes, pathname, matchPath, branch) {
    if (branch === void 0) { branch = []; }
    routes.some(function (route) {
        var match = route.path
            ? matchPath(pathname, route)
            : branch.length
                ? branch[branch.length - 1].match // use parent match
                : computeRootMatch(pathname); // use default "root" match
        if (match) {
            branch.push({ route: route, match: match });
            if (route.routes) {
                matchRoutes(route.routes, pathname, matchPath, branch);
            }
        }
        return !!match;
    });
    return branch;
}
function computeRootMatch(pathname) {
    return { path: '/', url: '/', params: {}, isExact: pathname === '/' };
}
/* eslint-disable @typescript-eslint/no-explicit-any, @typescript-eslint/no-unsafe-member-access */
export function withSentryRouting(Route) {
    var componentDisplayName = Route.displayName || Route.name;
    var WrappedRoute = function (props) {
        if (activeTransaction && props && props.computedMatch && props.computedMatch.isExact) {
            activeTransaction.setName(props.computedMatch.path);
        }
        // @ts-ignore Setting more specific React Component typing for `R` generic above
        // will break advanced type inference done by react router params:
        // https://github.com/DefinitelyTyped/DefinitelyTyped/blob/13dc4235c069e25fe7ee16e11f529d909f9f3ff8/types/react-router/index.d.ts#L154-L164
        return React.createElement(Route, __assign({}, props));
    };
    WrappedRoute.displayName = "sentryRoute(" + componentDisplayName + ")";
    hoistNonReactStatics(WrappedRoute, Route);
    // @ts-ignore Setting more specific React Component typing for `R` generic above
    // will break advanced type inference done by react router params:
    // https://github.com/DefinitelyTyped/DefinitelyTyped/blob/13dc4235c069e25fe7ee16e11f529d909f9f3ff8/types/react-router/index.d.ts#L154-L164
    return WrappedRoute;
}
/* eslint-enable @typescript-eslint/no-explicit-any, @typescript-eslint/no-unsafe-member-access */
//# sourceMappingURL=reactrouter.js.map