import { getGlobalObject, logger } from '@sentry/utils';
import hoistNonReactStatics from 'hoist-non-react-statics';
import React__default from 'react';
import { IS_DEBUG_BUILD } from './flags.js';

var _jsxFileName = "/home/runner/work/sentry-javascript/sentry-javascript/packages/react/src/reactrouterv6.tsx";

let activeTransaction;

let _useEffect;
let _useLocation;
let _useNavigationType;
let _createRoutesFromChildren;
let _matchRoutes;
let _customStartTransaction;
let _startTransactionOnLocationChange;

var global = getGlobalObject();

var SENTRY_TAGS = {
  'routing.instrumentation': 'react-router-v6',
};

function getInitPathName() {
  if (global && global.location) {
    return global.location.pathname;
  }

  return undefined;
}

function reactRouterV6Instrumentation(
  useEffect,
  useLocation,
  useNavigationType,
  createRoutesFromChildren,
  matchRoutes,
) {
  return (
    customStartTransaction,
    startTransactionOnPageLoad = true,
    startTransactionOnLocationChange = true,
  ) => {
    var initPathName = getInitPathName();
    if (startTransactionOnPageLoad && initPathName) {
      activeTransaction = customStartTransaction({
        name: initPathName,
        op: 'pageload',
        tags: SENTRY_TAGS,
      });
    }

    _useEffect = useEffect;
    _useLocation = useLocation;
    _useNavigationType = useNavigationType;
    _matchRoutes = matchRoutes;
    _createRoutesFromChildren = createRoutesFromChildren;

    _customStartTransaction = customStartTransaction;
    _startTransactionOnLocationChange = startTransactionOnLocationChange;
  };
}

var getTransactionName = (routes, location, matchRoutes) => {
  if (!routes || routes.length === 0 || !matchRoutes) {
    return location.pathname;
  }

  var branches = matchRoutes(routes, location);

  if (branches) {
        for (let x = 0; x < branches.length; x++) {
      if (branches[x].route && branches[x].route.path && branches[x].pathname === location.pathname) {
        return branches[x].route.path || location.pathname;
      }
    }
  }

  return location.pathname;
};

function withSentryReactRouterV6Routing(Routes) {
  if (
    !_useEffect ||
    !_useLocation ||
    !_useNavigationType ||
    !_createRoutesFromChildren ||
    !_matchRoutes ||
    !_customStartTransaction
  ) {
    IS_DEBUG_BUILD &&
      logger.warn('reactRouterV6Instrumentation was unable to wrap Routes because of one or more missing parameters.');

    return Routes;
  }

  let isBaseLocation = false;
  let routes;

  var SentryRoutes = (props) => {
    var location = _useLocation();
    var navigationType = _useNavigationType();

    _useEffect(() => {
      // Performance concern:
      // This is repeated when <Routes /> is rendered.
      routes = _createRoutesFromChildren(props.children);
      isBaseLocation = true;

      if (activeTransaction) {
        activeTransaction.setName(getTransactionName(routes, location, _matchRoutes));
      }

          }, [props.children]);

    _useEffect(() => {
      if (isBaseLocation) {
        if (activeTransaction) {
          activeTransaction.finish();
        }

        return;
      }

      if (_startTransactionOnLocationChange && (navigationType === 'PUSH' || navigationType === 'POP')) {
        if (activeTransaction) {
          activeTransaction.finish();
        }

        activeTransaction = _customStartTransaction({
          name: getTransactionName(routes, location, _matchRoutes),
          op: 'navigation',
          tags: SENTRY_TAGS,
        });
      }
    }, [props.children, location, navigationType, isBaseLocation]);

    isBaseLocation = false;

    // @ts-ignore Setting more specific React Component typing for `R` generic above
    // will break advanced type inference done by react router params
    return React__default.createElement(Routes, { ...props, __self: this, __source: {fileName: _jsxFileName, lineNumber: 172}} );
  };

  hoistNonReactStatics(SentryRoutes, Routes);

  // @ts-ignore Setting more specific React Component typing for `R` generic above
  // will break advanced type inference done by react router params
  return SentryRoutes;
}

export { reactRouterV6Instrumentation, withSentryReactRouterV6Routing };
//# sourceMappingURL=reactrouterv6.js.map
