import { Transaction, TransactionContext } from '@sentry/types';
import React from 'react';
import { Action, Location } from './types';
interface RouteObject {
    caseSensitive?: boolean;
    children?: RouteObject[];
    element?: React.ReactNode;
    index?: boolean;
    path?: string;
}
declare type Params<Key extends string = string> = {
    readonly [key in Key]: string | undefined;
};
interface RouteMatch<ParamKey extends string = string> {
    params: Params<ParamKey>;
    pathname: string;
    route: RouteObject;
}
declare type UseEffect = (cb: () => void, deps: unknown[]) => void;
declare type UseLocation = () => Location;
declare type UseNavigationType = () => Action;
declare type CreateRoutesFromChildren = (children: JSX.Element[]) => RouteObject[];
declare type MatchRoutes = (routes: RouteObject[], location: Location) => RouteMatch[] | null;
export declare function reactRouterV6Instrumentation(useEffect: UseEffect, useLocation: UseLocation, useNavigationType: UseNavigationType, createRoutesFromChildren: CreateRoutesFromChildren, matchRoutes: MatchRoutes): (customStartTransaction: (context: TransactionContext) => Transaction | undefined, startTransactionOnPageLoad?: boolean, startTransactionOnLocationChange?: boolean) => void;
export declare function withSentryReactRouterV6Routing<P extends Record<string, any>, R extends React.FC<P>>(Routes: R): R;
export {};
//# sourceMappingURL=reactrouterv6.d.ts.map