Object.defineProperty(exports, '__esModule', { value: true });

var browser = require('@sentry/browser');
var sdk = require('./sdk.js');
var profiler = require('./profiler.js');
var errorboundary = require('./errorboundary.js');
var redux = require('./redux.js');
var reactrouterv3 = require('./reactrouterv3.js');
var reactrouter = require('./reactrouter.js');
var reactrouterv6 = require('./reactrouterv6.js');

;

exports.init = sdk.init;
exports.Profiler = profiler.Profiler;
exports.useProfiler = profiler.useProfiler;
exports.withProfiler = profiler.withProfiler;
exports.ErrorBoundary = errorboundary.ErrorBoundary;
exports.withErrorBoundary = errorboundary.withErrorBoundary;
exports.createReduxEnhancer = redux.createReduxEnhancer;
exports.reactRouterV3Instrumentation = reactrouterv3.reactRouterV3Instrumentation;
exports.reactRouterV4Instrumentation = reactrouter.reactRouterV4Instrumentation;
exports.reactRouterV5Instrumentation = reactrouter.reactRouterV5Instrumentation;
exports.withSentryRouting = reactrouter.withSentryRouting;
exports.reactRouterV6Instrumentation = reactrouterv6.reactRouterV6Instrumentation;
exports.withSentryReactRouterV6Routing = reactrouterv6.withSentryReactRouterV6Routing;
exports.wrapUseRoutes = reactrouterv6.wrapUseRoutes;
for (var k in browser) {
	if (k !== 'default' && !exports.hasOwnProperty(k)) exports[k] = browser[k];
}
//# sourceMappingURL=index.js.map
