var {
  _interopDefault
} = require('@sentry/utils/cjs/buildPolyfills');

Object.defineProperty(exports, '__esModule', { value: true });

var utils = require('@sentry/utils');
var hoistNonReactStatics = require('hoist-non-react-statics');
var React = require('react');

var hoistNonReactStatics__default = /*#__PURE__*/_interopDefault(hoistNonReactStatics);
var React__default = /*#__PURE__*/_interopDefault(React);

var _jsxFileName = "/home/runner/work/sentry-javascript/sentry-javascript/packages/react/src/reactrouterv6.tsx";

let activeTransaction;

let _useEffect;
let _useLocation;
let _useNavigationType;
let _createRoutesFromChildren;
let _matchRoutes;
let _customStartTransaction;
let _startTransactionOnLocationChange;

var global = utils.getGlobalObject();

var SENTRY_TAGS = {
  'routing.instrumentation': 'react-router-v6',
};

function reactRouterV6Instrumentation(
  useEffect,
  useLocation,
  useNavigationType,
  createRoutesFromChildren,
  matchRoutes,
) {
  return (
    customStartTransaction,
    startTransactionOnPageLoad = true,
    startTransactionOnLocationChange = true,
  ) => {
    var initPathName = global && global.location && global.location.pathname;
    if (startTransactionOnPageLoad && initPathName) {
      activeTransaction = customStartTransaction({
        name: initPathName,
        op: 'pageload',
        tags: SENTRY_TAGS,
        metadata: {
          source: 'url',
        },
      });
    }

    _useEffect = useEffect;
    _useLocation = useLocation;
    _useNavigationType = useNavigationType;
    _matchRoutes = matchRoutes;
    _createRoutesFromChildren = createRoutesFromChildren;

    _customStartTransaction = customStartTransaction;
    _startTransactionOnLocationChange = startTransactionOnLocationChange;
  };
}

function getNormalizedName(
  routes,
  location,
  matchRoutes,
) {
  if (!routes || routes.length === 0 || !matchRoutes) {
    return [location.pathname, 'url'];
  }

  var branches = matchRoutes(routes, location);

  let pathBuilder = '';
  if (branches) {
    // eslint-disable-next-line @typescript-eslint/prefer-for-of
    for (let x = 0; x < branches.length; x++) {
      var branch = branches[x];
      var route = branch.route;
      if (route) {
        // Early return if index route
        if (route.index) {
          return [branch.pathname, 'route'];
        }

        var path = route.path;
        if (path) {
          var newPath = path[0] === '/' ? path : `/${path}`;
          pathBuilder += newPath;
          if (branch.pathname === location.pathname) {
            // If the route defined on the element is something like
            // <Route path="/stores/:storeId/products/:productId" element={<div>Product</div>} />
            // We should check against the branch.pathname for the number of / seperators
            if (utils.getNumberOfUrlSegments(pathBuilder) !== utils.getNumberOfUrlSegments(branch.pathname)) {
              return [newPath, 'route'];
            }
            return [pathBuilder, 'route'];
          }
        }
      }
    }
  }

  return [location.pathname, 'url'];
}

function updatePageloadTransaction(location, routes) {
  if (activeTransaction) {
    activeTransaction.setName(...getNormalizedName(routes, location, _matchRoutes));
  }
}

function handleNavigation(
  location,
  routes,
  navigationType,
  isBaseLocation,
) {
  if (isBaseLocation) {
    if (activeTransaction) {
      activeTransaction.finish();
    }

    return;
  }

  if (_startTransactionOnLocationChange && (navigationType === 'PUSH' || navigationType === 'POP')) {
    if (activeTransaction) {
      activeTransaction.finish();
    }

    const [name, source] = getNormalizedName(routes, location, _matchRoutes);
    activeTransaction = _customStartTransaction({
      name,
      op: 'navigation',
      tags: SENTRY_TAGS,
      metadata: {
        source,
      },
    });
  }
}

function withSentryReactRouterV6Routing(Routes) {
  if (
    !_useEffect ||
    !_useLocation ||
    !_useNavigationType ||
    !_createRoutesFromChildren ||
    !_matchRoutes ||
    !_customStartTransaction
  ) {
    (typeof __SENTRY_DEBUG__ === 'undefined' || __SENTRY_DEBUG__) &&
      utils.logger.warn(`reactRouterV6Instrumentation was unable to wrap Routes because of one or more missing parameters.
      useEffect: ${_useEffect}. useLocation: ${_useLocation}. useNavigationType: ${_useNavigationType}.
      createRoutesFromChildren: ${_createRoutesFromChildren}. matchRoutes: ${_matchRoutes}. customStartTransaction: ${_customStartTransaction}.`);

    return Routes;
  }

  let isBaseLocation = false;
  let routes;

  var SentryRoutes = (props) => {
    var location = _useLocation();
    var navigationType = _useNavigationType();

    _useEffect(() => {
      // Performance concern:
      // This is repeated when <Routes /> is rendered.
      routes = _createRoutesFromChildren(props.children);
      isBaseLocation = true;

      updatePageloadTransaction(location, routes);
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.children]);

    _useEffect(() => {
      handleNavigation(location, routes, navigationType, isBaseLocation);
    }, [props.children, location, navigationType, isBaseLocation]);

    isBaseLocation = false;

    // @ts-ignore Setting more specific React Component typing for `R` generic above
    // will break advanced type inference done by react router params
    return React__default.createElement(Routes, { ...props, __self: this, __source: {fileName: _jsxFileName, lineNumber: 225}} );
  };

  hoistNonReactStatics__default(SentryRoutes, Routes);

  // @ts-ignore Setting more specific React Component typing for `R` generic above
  // will break advanced type inference done by react router params
  return SentryRoutes;
}

function wrapUseRoutes(origUseRoutes) {
  if (!_useEffect || !_useLocation || !_useNavigationType || !_matchRoutes || !_customStartTransaction) {
    (typeof __SENTRY_DEBUG__ === 'undefined' || __SENTRY_DEBUG__) &&
      utils.logger.warn(
        'reactRouterV6Instrumentation was unable to wrap `useRoutes` because of one or more missing parameters.',
      );

    return origUseRoutes;
  }

  let isBaseLocation = false;

  return (routes, location) => {
    var SentryRoutes = (props) => {
      var Routes = origUseRoutes(routes, location);

      var locationArgObject = typeof location === 'string' ? { pathname: location } : location;
      var locationObject = (locationArgObject ) || _useLocation();
      var navigationType = _useNavigationType();

      _useEffect(() => {
        isBaseLocation = true;

        updatePageloadTransaction(locationObject, routes);
      }, [props]);

      _useEffect(() => {
        handleNavigation(locationObject, routes, navigationType, isBaseLocation);
      }, [props, locationObject, navigationType, isBaseLocation]);

      isBaseLocation = false;

      return Routes;
    };

    return React__default.createElement(SentryRoutes, {__self: this, __source: {fileName: _jsxFileName, lineNumber: 270}} );
  };
}

exports.reactRouterV6Instrumentation = reactRouterV6Instrumentation;
exports.withSentryReactRouterV6Routing = withSentryReactRouterV6Routing;
exports.wrapUseRoutes = wrapUseRoutes;
//# sourceMappingURL=reactrouterv6.js.map
