import { configureScope } from '@sentry/browser';

/* eslint-disable @typescript-eslint/no-explicit-any */

var ACTION_BREADCRUMB_CATEGORY = 'redux.action';
var ACTION_BREADCRUMB_TYPE = 'info';

var defaultOptions = {
  actionTransformer: action => action,
  stateTransformer: state => state || null,
};

/**
 * Creates an enhancer that would be passed to Redux's createStore to log actions and the latest state to Sentry.
 *
 * @param enhancerOptions Options to pass to the enhancer
 */
function createReduxEnhancer(enhancerOptions) {
  // Note: We return an any type as to not have type conflicts.
  var options = {
    ...defaultOptions,
    ...enhancerOptions,
  };

  return (next) =>
    (reducer, initialState) => {
      var sentryReducer = (state, action) => {
        var newState = reducer(state, action);

        configureScope(scope => {
          /* Action breadcrumbs */
          var transformedAction = options.actionTransformer(action);
          if (typeof transformedAction !== 'undefined' && transformedAction !== null) {
            scope.addBreadcrumb({
              category: ACTION_BREADCRUMB_CATEGORY,
              data: transformedAction,
              type: ACTION_BREADCRUMB_TYPE,
            });
          }

          /* Set latest state to scope */
          var transformedState = options.stateTransformer(newState);
          if (typeof transformedState !== 'undefined' && transformedState !== null) {
            scope.setContext('state', { state: { type: 'redux', value: transformedState } });
          } else {
            scope.setContext('state', null);
          }

          /* Allow user to configure scope with latest state */
          // eslint-disable-next-line @typescript-eslint/unbound-method
          const { configureScopeWithState } = options;
          if (typeof configureScopeWithState === 'function') {
            configureScopeWithState(scope, newState);
          }
        });

        return newState;
      };

      return next(sentryReducer, initialState);
    };
}

export { createReduxEnhancer };
//# sourceMappingURL=redux.js.map
