/// <reference types="react" />
import type { Transaction, TransactionContext } from '@sentry/types';
export declare type Action = 'PUSH' | 'REPLACE' | 'POP';
export declare type Location = {
    pathname: string;
    action?: Action;
} & Record<string, any>;
export declare type ReactRouterInstrumentation = <T extends Transaction>(startTransaction: (context: TransactionContext) => T | undefined, startTransactionOnPageLoad?: boolean, startTransactionOnLocationChange?: boolean) => void;
export interface NonIndexRouteObject {
    caseSensitive?: boolean;
    children?: RouteObject[];
    element?: React.ReactNode | null;
    errorElement?: React.ReactNode | null;
    index?: any;
    path?: string;
}
export interface IndexRouteObject {
    caseSensitive?: boolean;
    children?: undefined;
    element?: React.ReactNode | null;
    errorElement?: React.ReactNode | null;
    index: any;
    path?: string;
}
export declare type RouteObject = (IndexRouteObject | NonIndexRouteObject) & Record<string, any>;
export declare type Params<Key extends string = string> = {
    readonly [key in Key]: string | undefined;
};
export declare type UseRoutes = (routes: RouteObject[], locationArg?: Partial<Location> | string) => React.ReactElement | null;
export interface RouteMatch<ParamKey extends string = string> {
    /**
     * The names and values of dynamic parameters in the URL.
     */
    params: Params<ParamKey>;
    /**
     * The portion of the URL pathname that was matched.
     */
    pathname: string;
    /**
     * The portion of the URL pathname that was matched before child routes.
     */
    pathnameBase: string;
    /**
     * The route object that was used to match.
     */
    route: RouteObject;
}
export declare type UseEffect = (cb: () => void, deps: unknown[]) => void;
export declare type UseLocation = () => Location;
export declare type UseNavigationType = () => Action;
export declare type RouteObjectArrayAlias = any;
export declare type RouteMatchAlias = any;
export declare type CreateRoutesFromChildren = (children: JSX.Element[]) => RouteObjectArrayAlias;
export declare type MatchRoutes = (routes: RouteObjectArrayAlias, location: Location) => RouteMatchAlias[] | null;
export declare type ShouldRevalidateFunction = (args: any) => boolean;
interface DataFunctionArgs {
    request: Request;
    params: Params;
}
declare type LoaderFunctionArgs = DataFunctionArgs;
declare type ActionFunctionArgs = DataFunctionArgs;
export interface LoaderFunction {
    (args: LoaderFunctionArgs): Promise<Response> | Response | Promise<any> | any;
}
export interface ActionFunction {
    (args: ActionFunctionArgs): Promise<Response> | Response | Promise<any> | any;
}
declare type AgnosticBaseRouteObject = {
    caseSensitive?: boolean;
    path?: string;
    id?: string;
    loader?: LoaderFunction;
    action?: ActionFunction;
    hasErrorBoundary?: boolean;
    shouldRevalidate?: ShouldRevalidateFunction;
    handle?: any;
};
export declare type AgnosticIndexRouteObject = AgnosticBaseRouteObject & Record<string, any>;
export declare type AgnosticNonIndexRouteObject = AgnosticBaseRouteObject & Record<string, any>;
export declare type AgnosticDataIndexRouteObject = AgnosticIndexRouteObject & {
    id: string;
};
export declare type AgnosticDataNonIndexRouteObject = AgnosticNonIndexRouteObject & {
    children?: AgnosticDataRouteObject[];
    id: string;
};
export interface AgnosticRouteMatch<ParamKey extends string = string, RouteObjectType extends AgnosticRouteObject = AgnosticRouteObject> {
    params: Params<ParamKey>;
    pathname: string;
    pathnameBase: string;
    route: RouteObjectType;
}
export declare type AgnosticDataRouteMatch = AgnosticRouteMatch<string, AgnosticDataRouteObject>;
interface UseMatchesMatch {
    id: string;
    pathname: string;
    params: AgnosticRouteMatch['params'];
    data: unknown;
    handle: unknown;
}
export interface GetScrollRestorationKeyFunction {
    (location: Location, matches: UseMatchesMatch[]): string | null;
}
export interface Path {
    pathname: string;
    search: string;
    hash: string;
}
export interface RouterSubscriber<TState extends RouterState = RouterState> {
    (state: TState): void;
}
export interface GetScrollPositionFunction {
    (): number;
}
declare type LinkNavigateOptions = {
    replace?: boolean;
    state?: any;
    preventScrollReset?: boolean;
};
export declare type AgnosticDataRouteObject = AgnosticDataIndexRouteObject | AgnosticDataNonIndexRouteObject;
export declare type To = string | Partial<Path>;
export declare type HydrationState = any;
export declare type FormMethod = 'get' | 'post' | 'put' | 'patch' | 'delete';
export declare type FormEncType = 'application/x-www-form-urlencoded' | 'multipart/form-data';
export declare type RouterNavigateOptions = LinkNavigateOptions | SubmissionNavigateOptions;
export declare type AgnosticRouteObject = AgnosticIndexRouteObject | AgnosticNonIndexRouteObject;
declare type SubmissionNavigateOptions = {
    replace?: boolean;
    state?: any;
    formMethod?: FormMethod;
    formEncType?: FormEncType;
    formData: FormData;
};
export interface RouterInit {
    basename: string;
    routes: AgnosticRouteObject[];
    history: History;
    hydrationData?: HydrationState;
}
export declare type NavigationStates = {
    Idle: any;
    Loading: any;
    Submitting: any;
};
export declare type Navigation = NavigationStates[keyof NavigationStates];
export declare type RouteData = any;
export declare type Fetcher = any;
export declare enum HistoryAction {
    Pop = "POP",
    Push = "PUSH",
    Replace = "REPLACE"
}
export interface RouterState {
    historyAction: Action | HistoryAction | any;
    location: any;
}
export interface Router<TState extends RouterState = RouterState> {
    state: TState;
    subscribe(fn: RouterSubscriber<TState>): () => void;
}
export declare type CreateRouterFunction<TState extends RouterState = RouterState, TRouter extends Router<TState> = Router<TState>> = (routes: RouteObject[], opts?: any) => TRouter;
export {};
//# sourceMappingURL=types.d.ts.map