import type { ReplayContainer, ReplayPerformanceEntry } from '../types';
interface FetchHandlerData {
    args: Parameters<typeof fetch>;
    fetchData: {
        method: string;
        url: string;
    };
    response: {
        type: string;
        url: string;
        redirected: boolean;
        status: number;
        ok: boolean;
    };
    startTimestamp: number;
    endTimestamp?: number;
}
/** only exported for tests */
export declare function handleFetch(handlerData: FetchHandlerData): null | ReplayPerformanceEntry;
/**
 * Returns a listener to be added to `addInstrumentationHandler('fetch', listener)`.
 */
export declare function handleFetchSpanListener(replay: ReplayContainer): (handlerData: FetchHandlerData) => void;
export {};
//# sourceMappingURL=handleFetch.d.ts.map