import type { Session, SessionOptions } from '../types';
interface GetSessionParams extends SessionOptions {
    /**
     * The length of time (in ms) which we will consider the session to be expired.
     */
    expiry: number;
    /**
     * The current session (e.g. if stickySession is off)
     */
    currentSession?: Session;
}
/**
 * Get or create a session
 */
export declare function getSession({ expiry, currentSession, stickySession, sessionSampleRate, errorSampleRate, }: GetSessionParams): {
    type: 'new' | 'saved';
    session: Session;
};
export {};
//# sourceMappingURL=getSession.d.ts.map