declare type blockClass = string | RegExp;
declare type maskTextClass = string | RegExp;
declare enum EventType {
    DomContentLoaded = 0,
    Load = 1,
    FullSnapshot = 2,
    IncrementalSnapshot = 3,
    Meta = 4,
    Custom = 5,
    Plugin = 6
}
/**
 * This is a partial copy of rrweb's eventWithTime type which only contains the properties
 * we specifcally need in the SDK.
 */
export declare type eventWithTime = {
    type: EventType;
    data: unknown;
    timestamp: number;
    delay?: number;
};
/**
 * This is a partial copy of rrweb's recording options which only contains the properties
 * we specifically us in the SDK. Users can specify additional properties, hence we add the
 * Record<string, unknown> union type.
 */
export declare type recordOptions = {
    maskAllText?: boolean;
    maskAllInputs?: boolean;
    blockClass?: blockClass;
    ignoreClass?: string;
    maskTextClass?: maskTextClass;
    maskTextSelector?: string;
    blockSelector?: string;
    maskInputOptions?: Record<string, boolean>;
} & Record<string, unknown>;
export {};
//# sourceMappingURL=rrweb.d.ts.map