import type { Session, SessionOptions, Timeouts } from '../types';
interface GetSessionParams extends SessionOptions {
    timeouts: Timeouts;
    /**
     * The current session (e.g. if stickySession is off)
     */
    currentSession?: Session;
}
/**
 * Get or create a session
 */
export declare function getSession({ timeouts, currentSession, stickySession, sessionSampleRate, errorSampleRate, }: GetSessionParams): {
    type: 'new' | 'saved';
    session: Session;
};
export {};
//# sourceMappingURL=getSession.d.ts.map