import type { DeprecatedPrivacyOptions, ReplayIntegrationPrivacyOptions } from '../types';
declare type GetPrivacyOptions = Required<Omit<ReplayIntegrationPrivacyOptions, 'maskFn'>> & Omit<DeprecatedPrivacyOptions, 'maskInputOptions'>;
interface GetPrivacyReturn {
    maskTextSelector: string;
    unmaskTextSelector: string;
    maskInputSelector: string;
    unmaskInputSelector: string;
    blockSelector: string;
    unblockSelector: string;
    ignoreSelector: string;
    blockClass?: RegExp;
    maskTextClass?: RegExp;
}
/**
 * Returns privacy related configuration for use in rrweb
 */
export declare function getPrivacyOptions({ mask, unmask, block, unblock, ignore, blockClass, blockSelector, maskTextClass, maskTextSelector, ignoreClass, }: GetPrivacyOptions): GetPrivacyReturn;
export {};
//# sourceMappingURL=getPrivacyOptions.d.ts.map