import { Baggage, BaggageObj } from '@sentry/types';
export declare const BAGGAGE_HEADER_NAME = "baggage";
export declare const SENTRY_BAGGAGE_KEY_PREFIX = "sentry-";
export declare const SENTRY_BAGGAGE_KEY_PREFIX_REGEX: RegExp;
/**
 * Max length of a serialized baggage string
 *
 * https://www.w3.org/TR/baggage/#limits
 */
export declare const MAX_BAGGAGE_STRING_LENGTH = 8192;
/** Create an instance of Baggage */
export declare function createBaggage(initItems: BaggageObj, baggageString?: string): Baggage;
/** Get a value from baggage */
export declare function getBaggageValue(baggage: Baggage, key: keyof BaggageObj): BaggageObj[keyof BaggageObj];
/** Add a value to baggage */
export declare function setBaggageValue(baggage: Baggage, key: keyof BaggageObj, value: BaggageObj[keyof BaggageObj]): void;
/** Check if the baggage object (i.e. the first element in the tuple) is empty */
export declare function isBaggageEmpty(baggage: Baggage): boolean;
/** Returns Sentry specific baggage values */
export declare function getSentryBaggageItems(baggage: Baggage): BaggageObj;
/**
 * Returns 3rd party baggage string of @param baggage
 * @param baggage
 */
export declare function getThirdPartyBaggage(baggage: Baggage): string;
/** Serialize a baggage object */
export declare function serializeBaggage(baggage: Baggage): string;
/** Parse a baggage header to a string */
export declare function parseBaggageString(inputBaggageString: string): Baggage;
/**
 * Merges the baggage header we saved from the incoming request (or meta tag) with
 * a possibly created or modified baggage header by a third party that's been added
 * to the outgoing request header.
 *
 * In case @param headerBaggageString exists, we can safely add the the 3rd party part of @param headerBaggage
 * with our @param incomingBaggage. This is possible because if we modified anything beforehand,
 * it would only affect parts of the sentry baggage (@see Baggage interface).
 *
 * @param incomingBaggage the baggage header of the incoming request that might contain sentry entries
 * @param headerBaggageString possibly existing baggage header string added from a third party to request headers
 *
 * @return a merged and serialized baggage string to be propagated with the outgoing request
 */
export declare function mergeAndSerializeBaggage(incomingBaggage?: Baggage, headerBaggageString?: string): string;
//# sourceMappingURL=baggage.d.ts.map