export { getDomElement, getLocationHref, htmlTreeAsString } from './browser.js';
export { dsnFromString, dsnToString, makeDsn } from './dsn.js';
export { SentryError } from './error.js';
export { GLOBAL_OBJ, getGlobalObject, getGlobalSingleton } from './worldwide.js';
export { addInstrumentationHandler } from './instrument.js';
export { isDOMError, isDOMException, isElement, isError, isErrorEvent, isEvent, isInstanceOf, isNaN, isPlainObject, isPrimitive, isRegExp, isString, isSyntheticEvent, isThenable } from './is.js';
export { CONSOLE_LEVELS, consoleSandbox, logger } from './logger.js';
export { memoBuilder } from './memo.js';
export { addContextToFrame, addExceptionMechanism, addExceptionTypeValue, arrayify, checkOrSetAlreadyCaught, getEventDescription, parseSemver, uuid4 } from './misc.js';
export { dynamicRequire, isNodeEnv, loadModule } from './node.js';
export { normalize, normalizeToSize, walk } from './normalize.js';
export { addNonEnumerableProperty, convertToPlainObject, dropUndefinedKeys, extractExceptionKeysForMessage, fill, getOriginalFunction, markFunctionWrapped, objectify, urlEncode } from './object.js';
export { basename, dirname, isAbsolute, join, normalizePath, relative, resolve } from './path.js';
export { makePromiseBuffer } from './promisebuffer.js';
export { addRequestDataToEvent, addRequestDataToTransaction, extractPathForTransaction, extractRequestData } from './requestdata.js';
export { severityFromString, severityLevelFromString, validSeverityLevels } from './severity.js';
export { createStackParser, getFunctionName, nodeStackLineParser, stackParserFromStackParserOptions, stripSentryFramesAndReverse } from './stacktrace.js';
export { isMatchingPattern, safeJoin, snipLine, stringMatchesSomePattern, truncate } from './string.js';
export { isNativeFetch, supportsDOMError, supportsDOMException, supportsErrorEvent, supportsFetch, supportsNativeFetch, supportsReferrerPolicy, supportsReportingObserver } from './supports.js';
export { SyncPromise, rejectedSyncPromise, resolvedSyncPromise } from './syncpromise.js';
export { _browserPerformanceTimeOriginMode, browserPerformanceTimeOrigin, dateTimestampInSeconds, timestampInSeconds, timestampWithMs, usingPerformanceAPI } from './time.js';
export { TRACEPARENT_REGEXP, extractTraceparentData } from './tracing.js';
export { getSDKSource, isBrowserBundle } from './env.js';
export { addItemToEnvelope, createAttachmentEnvelopeItem, createEnvelope, createEventEnvelopeHeaders, envelopeContainsItemType, envelopeItemTypeToDataCategory, forEachEnvelopeItem, getSdkMetadataForEnvelopeHeader, parseEnvelope, serializeEnvelope } from './envelope.js';
export { createClientReportEnvelope } from './clientreport.js';
export { DEFAULT_RETRY_AFTER, disabledUntil, isRateLimited, parseRetryAfterHeader, updateRateLimits } from './ratelimit.js';
export { BAGGAGE_HEADER_NAME, MAX_BAGGAGE_STRING_LENGTH, SENTRY_BAGGAGE_KEY_PREFIX, SENTRY_BAGGAGE_KEY_PREFIX_REGEX, baggageHeaderToDynamicSamplingContext, dynamicSamplingContextToSentryBaggageHeader } from './baggage.js';
export { getNumberOfUrlSegments, parseUrl, stripUrlQueryAndFragment } from './url.js';
export { addOrUpdateIntegration } from './userIntegrations.js';
export { escapeStringForRegex } from './vendor/escapeStringForRegex.js';
export { supportsHistory } from './vendor/supportsHistory.js';
//# sourceMappingURL=index.js.map
