import "reflect-metadata";
/**
 * Specifies a type of the property. Property needs to known about its type
 */
export declare function Type(typeFunction?: (type?: any) => Function): (target: any, key: string) => void;
/**
 * Marks property as skipped on the process of serialization and deserialization. By default it skips the property
 * for both serialization and deserialization, however you can specify on which of process (deserialization or
 * serialization) you want to skip this property.
 */
export declare function Skip(options?: {
    onSerialize: boolean;
    onDeserialize: boolean;
}): (target: any, key: string) => void;
