"use strict";
require("reflect-metadata");
var MetadataStorage_1 = require("./metadata/MetadataStorage");
var TypeMetadata_1 = require("./metadata/TypeMetadata");
var SkipMetadata_1 = require("./metadata/SkipMetadata");
/**
 * Specifies a type of the property. Property needs to known about its type
 */
function Type(typeFunction) {
    return function (target, key) {
        var type = Reflect.getMetadata("design:type", target, key);
        var isArray = type && typeof type === "string" ? type.toLowerCase() === "array" : false;
        var metadata = new TypeMetadata_1.TypeMetadata(target.constructor, key, typeFunction, isArray);
        MetadataStorage_1.defaultMetadataStorage.addTypeMetadata(metadata);
    };
}
exports.Type = Type;
/**
 * Marks property as skipped on the process of serialization and deserialization. By default it skips the property
 * for both serialization and deserialization, however you can specify on which of process (deserialization or
 * serialization) you want to skip this property.
 */
function Skip(options) {
    return function (target, key) {
        var metadata = new SkipMetadata_1.SkipMetadata(target.constructor, key, options);
        MetadataStorage_1.defaultMetadataStorage.addSkipMetadata(metadata);
    };
}
exports.Skip = Skip;
//# sourceMappingURL=Decorators.js.map