"use strict";
var MetadataStorage_1 = require("./metadata/MetadataStorage");
var Serializer = (function () {
    function Serializer() {
    }
    // -------------------------------------------------------------------------
    // Adder Methods
    // -------------------------------------------------------------------------
    Serializer.prototype.serialize = function (object, options) {
        var _this = this;
        if (object instanceof Array) {
            return object.map(function (item) { return _this.convert(item.constructor, item, "serialization"); });
        }
        else {
            var cls = object.constructor;
            return this.convert(cls, object, "serialization", options);
        }
    };
    Serializer.prototype.deserialize = function (cls, json, options) {
        var _this = this;
        if (json instanceof Array) {
            return json.map(function (item) { return _this.convert(cls, item, "deserialization"); });
        }
        else {
            return this.convert(cls, json, "deserialization", options);
        }
    };
    // -------------------------------------------------------------------------
    // Adder Methods
    // -------------------------------------------------------------------------
    Serializer.prototype.convert = function (cls, object, operationType, options) {
        var _this = this;
        if (object === null || object === undefined)
            return object;
        var newObject = operationType === "serialization" ? {} : new cls();
        var _loop_1 = function(key) {
            if (this_1.isSkipped(cls, key, operationType))
                return "continue";
            if (typeof object[key] !== "function") {
                if (options && options.skipStartedWith &&
                    key.substr(0, options.skipStartedWith.length) === options.skipStartedWith)
                    return "continue";
                var type_1 = this_1.getType(cls, key);
                if (object[key] instanceof Array) {
                    // if (object[key].length > 0 && !type && operationType === "deserialization")
                    //     throw new TypeMissingError(cls, key);
                    if (object[key].length > 0 && type_1) {
                        newObject[key] = object[key].map(function (arrayItem) { return _this.convert(type_1, arrayItem, operationType); });
                    }
                    else {
                        newObject[key] = object[key];
                    }
                }
                else if (object[key] instanceof Object && type_1) {
                    // if (!type && operationType === "deserialization")
                    //     throw new TypeMissingError(cls, key);
                    newObject[key] = this_1.convert(type_1, object[key], operationType);
                }
                else {
                    if (type_1 === Date) {
                        newObject[key] = new Date(object[key]);
                    }
                    else if (type_1 === String) {
                        newObject[key] = String(object[key]);
                    }
                    else if (type_1 === Number) {
                        newObject[key] = Number(object[key]);
                    }
                    else if (type_1 === Boolean) {
                        newObject[key] = Boolean(object[key]);
                    }
                    else {
                        newObject[key] = object[key];
                    }
                }
            }
        };
        var this_1 = this;
        for (var key in object) {
            var state_1 = _loop_1(key);
            if (state_1 === "continue") continue;
        }
        return newObject;
    };
    Serializer.prototype.isSkipped = function (target, propertyName, operationType) {
        if (!target)
            return undefined;
        var meta = MetadataStorage_1.defaultMetadataStorage.findSkipMetadata(target, propertyName);
        return operationType === "serialization" ? meta && meta.isOnSerialize : meta && meta.isOnDeserialize;
    };
    Serializer.prototype.getType = function (target, propertyName) {
        if (!target)
            return undefined;
        var meta = MetadataStorage_1.defaultMetadataStorage.findTypeMetadata(target, propertyName);
        return meta ? meta.typeFunction() : undefined;
    };
    return Serializer;
}());
exports.Serializer = Serializer;
var serializer = new Serializer();
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = serializer;
function serialize(object) {
    return serializer.serialize(object);
}
exports.serialize = serialize;
function deserialize(cls, json) {
    return serializer.deserialize(cls, json);
}
exports.deserialize = deserialize;
//# sourceMappingURL=Serializer.js.map