import { TypeMetadata } from "./TypeMetadata";
import { SkipMetadata } from "./SkipMetadata";
/**
 * Storage all serializer metadata.
 */
export declare class MetadataStorage {
    private _typeMetadatas;
    private _skipMetadatas;
    addTypeMetadata(metadata: TypeMetadata): void;
    addSkipMetadata(metadata: SkipMetadata): void;
    findSkipMetadata(target: Function, propertyName: string): SkipMetadata;
    findTypeMetadata(target: Function, propertyName: string): TypeMetadata;
}
/**
 * Default metadata storage is used as singleton and can be used to storage all metadatas.
 */
export declare let defaultMetadataStorage: MetadataStorage;
