"use strict";
/**
 * Storage all serializer metadata.
 */
var MetadataStorage = (function () {
    function MetadataStorage() {
        // -------------------------------------------------------------------------
        // Properties
        // -------------------------------------------------------------------------
        this._typeMetadatas = [];
        this._skipMetadatas = [];
    }
    // -------------------------------------------------------------------------
    // Adder Methods
    // -------------------------------------------------------------------------
    MetadataStorage.prototype.addTypeMetadata = function (metadata) {
        this._typeMetadatas.push(metadata);
    };
    MetadataStorage.prototype.addSkipMetadata = function (metadata) {
        this._skipMetadatas.push(metadata);
    };
    // -------------------------------------------------------------------------
    // Public Methods
    // -------------------------------------------------------------------------
    MetadataStorage.prototype.findSkipMetadata = function (target, propertyName) {
        var metadataFromTarget = this._skipMetadatas.find(function (meta) { return meta.target === target && meta.key === propertyName; });
        var metadataFromChildren = this._skipMetadatas.find(function (meta) { return target.prototype instanceof meta.target && meta.key === propertyName; });
        return metadataFromTarget || metadataFromChildren;
    };
    MetadataStorage.prototype.findTypeMetadata = function (target, propertyName) {
        var metadataFromTarget = this._typeMetadatas.find(function (meta) { return meta.target === target && meta.key === propertyName; });
        var metadataFromChildren = this._typeMetadatas.find(function (meta) { return target.prototype instanceof meta.target && meta.key === propertyName; });
        return metadataFromTarget || metadataFromChildren;
    };
    return MetadataStorage;
}());
exports.MetadataStorage = MetadataStorage;
/**
 * Default metadata storage is used as singleton and can be used to storage all metadatas.
 */
exports.defaultMetadataStorage = new MetadataStorage();
//# sourceMappingURL=MetadataStorage.js.map