# set-value [![NPM version](https://badge.fury.io/js/set-value.svg)](http://badge.fury.io/js/set-value)  [![Build Status](https://travis-ci.org/jonschlinkert/set-value.svg)](https://travis-ci.org/jonschlinkert/set-value)

> Create nested values and any intermediaries using dot notation (`'a.b.c'`) paths.

Install with [npm](https://www.npmjs.com/)

```bash
npm i set-value --save
```

## Usage

```js
var set = require('set-value');

var obj = {};
set(obj, 'a.b.c', 'd');
console.log(obj);
//=> {a: {b: c: 'd'}}
```

## Related projects

* [any](https://github.com/jonschlinkert/any): Returns `true` if a value exists in the given string, array or object.
* [get-value](https://github.com/jonschlinkert/get-value): Use property paths (`  a.b.c`) get a nested value from an object.
* [has-own-deep](https://github.com/jonschlinkert/has-own-deep): Returns true if an object has an own, nested property using dot notation paths ('a.b.c').
* [has-value](https://github.com/jonschlinkert/has-value): Returns true if a value exists, false if empty. Works with deeply nested values using… [more](https://github.com/jonschlinkert/has-value)
* [has-any](https://github.com/jonschlinkert/has-any): Returns true if an object has any of the specified keys.
* [has-any-deep](https://github.com/jonschlinkert/has-any-deep): Return true if `key` exists deeply on the given object.

## Running tests

Install dev dependencies:

```bash
npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/set-value/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright (c) 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on May 12, 2015._

<!-- deps: mocha should -->