/*! @license
 * Shaka Player
 * Copyright 2016 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */

declare class GlobalError extends Error {}

//!! generated by clutz.
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka {
  class Player extends shaka.util.FakeEventTarget implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_Player : any;
    constructor (mediaElement ? : HTMLMediaElement | null , dependencyInjector ? : (a : shaka.Player | null ) => any ) ;
    /**
     * Adds the given chapters track to the loaded manifest.  <code>load()</code>
     * must resolve before calling.  The presentation must have a duration.
     * This returns the created track.
     */
    addChaptersTrack (uri : string , language : string , mimeType ? : string ) : Promise < shaka.extern.Track > ;
    /**
     * Adds the given text track to the loaded manifest.  <code>load()</code> must
     * resolve before calling.  The presentation must have a duration.
     * This returns the created track, which can immediately be selected by the
     * application.  The track will not be automatically selected.
     */
    addTextTrackAsync (uri : string , language : string , kind : string , mimeType ? : string , codec ? : string , label ? : string , forced ? : boolean ) : Promise < shaka.extern.Track > ;
    /**
     * Tell the player to use <code>mediaElement</code> for all <code>load</code>
     * requests until <code>detach</code> or <code>destroy</code> are called.
     * <p>
     * Calling <code>attach</code> with <code>initializedMediaSource=true</code>
     * will tell the player to take the initial load step and initialize media
     * source.
     * <p>
     * Calls to <code>attach</code> will interrupt any in-progress calls to
     * <code>load</code> but cannot interrupt calls to <code>attach</code>,
     * <code>detach</code>, or <code>unload</code>.
     */
    attach (mediaElement : HTMLMediaElement , initializeMediaSource ? : boolean ) : Promise < any > ;
    /**
     * Cancel trick-play. If the player has not loaded content or is still loading
     * content this will be a no-op.
     */
    cancelTrickPlay ( ) : any ;
    /**
     * Changes configuration settings on the Player.  This checks the names of
     * keys and the types of values to avoid coding errors.  If there are errors,
     * this logs them to the console and returns false.  Correct fields are still
     * applied even if there are other errors.  You can pass an explicit
     * <code>undefined</code> value to restore the default value.  This has two
     * modes of operation:
     * <p>
     * First, this can be passed a single "plain" object.  This object should
     * follow the {@link shaka.extern.PlayerConfiguration} object.  Not all fields
     * need to be set; unset fields retain their old values.
     * <p>
     * Second, this can be passed two arguments.  The first is the name of the key
     * to set.  This should be a '.' separated path to the key.  For example,
     * <code>'streaming.alwaysStreamText'</code>.  The second argument is the
     * value to set.
     * @param config This should either be a field name or an object.
     * @param value In the second mode, this is the value to set.
     */
    configure (config : string | object , value ? : any ) : boolean ;
    /**
     * After destruction, a Player object cannot be used again.
     */
    destroy ( ) : Promise < any > ;
    /**
     * Tell the player to stop using its current media element. If the player is:
     * <ul>
     * <li>detached, this will do nothing,
     * <li>attached, this will release the media element,
     * <li>loading, this will abort loading, unload, and release the media
     * element,
     * <li>playing content, this will stop playback, unload, and release the
     * media element.
     * </ul>
     * <p>
     * Calls to <code>detach</code> will interrupt any in-progress calls to
     * <code>load</code> but cannot interrupt calls to <code>attach</code>,
     * <code>detach</code>, or <code>unload</code>.
     */
    detach ( ) : Promise < any > ;
    /**
     * Get the drm info used to initialize EME. If EME is not being used, this
     * will return <code>null</code>. If the player is idle or has not initialized
     * EME yet, this will return <code>null</code>.
     */
    drmInfo ( ) : shaka.extern.DrmInfo | null ;
    /**
     * Returns a shaka.ads.AdManager instance, responsible for Dynamic
     * Ad Insertion functionality.
     */
    getAdManager ( ) : shaka.extern.IAdManager | null ;
    /**
     * Get the uri to the asset that the player has loaded. If the player has not
     * loaded content, this will return <code>null</code>.
     */
    getAssetUri ( ) : string | null ;
    /**
     * Return a list of audio languages available. If the player has not loaded
     * any content, this will return an empty list.
     */
    getAudioLanguages ( ) : string [] ;
    /**
     * Return a list of audio language-role combinations available.  If the
     * player has not loaded any content, this will return an empty list.
     */
    getAudioLanguagesAndRoles ( ) : shaka.extern.LanguageRole [] ;
    /**
     * Returns the ratio of video length buffered compared to buffering Goal
     */
    getBufferFullness ( ) : number ;
    /**
     * Get information about what the player has buffered. If the player has not
     * loaded content or is currently loading content, the buffered content will
     * be empty.
     */
    getBufferedInfo ( ) : shaka.extern.BufferedInfo ;
    /**
     * This returns the list of chapters.
     */
    getChapters (language : string ) : shaka.extern.Chapter [] ;
    /**
     * Return a list of chapters tracks.
     */
    getChaptersTracks ( ) : shaka.extern.TrackList ;
    /**
     * Return a copy of the current configuration.  Modifications of the returned
     * value will not affect the Player's active configuration.  You must call
     * <code>player.configure()</code> to make changes.
     */
    getConfiguration ( ) : shaka.extern.PlayerConfiguration ;
    /**
     * Get the next known expiration time for any EME session. If the session
     * never expires, this will return <code>Infinity</code>. If there are no EME
     * sessions, this will return <code>Infinity</code>. If the player has not
     * loaded content, this will return <code>Infinity</code>.
     */
    getExpiration ( ) : number ;
    /**
     * Return a list of image tracks that can be switched to.
     * If the player has not loaded content, this will return an empty list.
     */
    getImageTracks ( ) : shaka.extern.TrackList ;
    /**
     * Gets a map of EME key ID to the current key status.
     */
    getKeyStatuses ( ) : { [ key: string ]: string } ;
    /**
     * Get the current load mode.
     */
    getLoadMode ( ) : shaka.Player.LoadMode ;
    /**
     * Get the manifest that the player has loaded. If the player has not loaded
     * any content, this will return <code>null</code>.
     * NOTE: This structure is NOT covered by semantic versioning compatibility
     * guarantees.  It may change at any time!
     * This is marked as deprecated to warn Closure Compiler users at compile-time
     * to avoid using this method.
     */
    getManifest ( ) : shaka.extern.Manifest | null ;
    /**
     * Get the type of manifest parser that the player is using. If the player has
     * not loaded any content, this will return <code>null</code>.
     */
    getManifestParserFactory ( ) : ( shaka.extern.ManifestParser.Factory ) | null ;
    /**
     * Get the media element that the player is currently using to play loaded
     * content. If the player has not loaded content, this will return
     * <code>null</code>.
     */
    getMediaElement ( ) : HTMLMediaElement | null ;
    getNetworkingEngine ( ) : shaka.net.NetworkingEngine | null ;
    /**
     * Get the playback rate of what is playing right now. If we are using trick
     * play, this will return the trick play rate.
     * If no content is playing, this will return 0.
     * If content is buffering, this will return the expected playback rate once
     * the video starts playing.
     * <p>
     * If the player has not loaded content, this will return a playback rate of
     * 0.
     */
    getPlaybackRate ( ) : number ;
    /**
     * Get the current playhead position as a date. This should only be called
     * when the player has loaded a live stream. If the player has not loaded a
     * live stream, this will return <code>null</code>.
     */
    getPlayheadTimeAsDate ( ) : Date | null ;
    /**
     * Get the presentation start time as a date. This should only be called when
     * the player has loaded a live stream. If the player has not loaded a live
     * stream, this will return <code>null</code>.
     */
    getPresentationStartTimeAsDate ( ) : Date | null ;
    /**
     * Get statistics for the current playback session. If the player is not
     * playing content, this will return an empty stats object.
     */
    getStats ( ) : shaka.extern.Stats ;
    /**
     * Return a list of text languages available. If the player has not loaded
     * any content, this will return an empty list.
     */
    getTextLanguages ( ) : string [] ;
    /**
     * Return a list of text language-role combinations available.  If the player
     * has not loaded any content, this will be return an empty list.
     */
    getTextLanguagesAndRoles ( ) : shaka.extern.LanguageRole [] ;
    /**
     * Return a list of text tracks that can be switched to.
     * <p>
     * If the player has not loaded content, this will return an empty list.
     */
    getTextTracks ( ) : shaka.extern.TrackList ;
    /**
     * Return a Thumbnail object from a image track Id and time.
     * If the player has not loaded content, this will return a null.
     */
    getThumbnails (trackId : number , time : number ) : Promise < shaka.extern.Thumbnail | null > ;
    /**
     * Return a list of variant tracks that can be switched to.
     * <p>
     * If the player has not loaded content, this will return an empty list.
     */
    getVariantTracks ( ) : shaka.extern.TrackList ;
    /**
     * Go to live in a live stream.
     */
    goToLive ( ) : any ;
    /**
     * Check if the manifest contains only audio-only content. If the player has
     * not loaded content, this will return <code>false</code>.
     * <p>
     * The player does not support content that contain more than one type of
     * variants (i.e. mixing audio-only, video-only, audio-video). Content will be
     * filtered to only contain one type of variant.
     */
    isAudioOnly ( ) : boolean ;
    /**
     * Check if the player is currently in a buffering state (has too little
     * content to play smoothly). If the player has not loaded content, this will
     * return <code>false</code>.
     */
    isBuffering ( ) : boolean ;
    /**
     * Get if the player is playing in-progress content. If the player has not
     * loaded content, this will return <code>false</code>.
     */
    isInProgress ( ) : boolean ;
    /**
     * Get if the player is playing live content. If the player has not loaded
     * content, this will return <code>false</code>.
     */
    isLive ( ) : boolean ;
    /**
     * Check if the text displayer is enabled.
     */
    isTextTrackVisible ( ) : boolean ;
    /**
     * Get the key system currently used by EME. If EME is not being used, this
     * will return an empty string. If the player has not loaded content, this
     * will return an empty string.
     */
    keySystem ( ) : string ;
    /**
     * Tell the player to load the content at <code>assetUri</code> and start
     * playback at <code>startTime</code>. Before calling <code>load</code>,
     * a call to <code>attach</code> must have succeeded.
     * <p>
     * Calls to <code>load</code> will interrupt any in-progress calls to
     * <code>load</code> but cannot interrupt calls to <code>attach</code>,
     * <code>detach</code>, or <code>unload</code>.
     * @param startTime When <code>startTime</code> is <code>null</code> or <code>undefined</code>, playback will start at the default start time (0 for VOD and liveEdge for LIVE).
     */
    load (assetUri : string , startTime ? : number | null , mimeType ? : string ) : Promise < any > ;
    /**
     * Reset configuration to default.
     */
    resetConfiguration ( ) : any ;
    /**
     * Retry streaming after a streaming failure has occurred. When the player has
     * not loaded content or is loading content, this will be a no-op and will
     * return <code>false</code>.
     * <p>
     * If the player has loaded content, and streaming has not seen an error, this
     * will return <code>false</code>.
     * <p>
     * If the player has loaded content, and streaming seen an error, but the
     * could not resume streaming, this will return <code>false</code>.
     */
    retryStreaming ( ) : boolean ;
    /**
     * Get the range of time (in seconds) that seeking is allowed. If the player
     * has not loaded content, this will return a range from 0 to 0.
     */
    seekRange ( ) : shaka.extern.BufferedRange ;
    /**
     * Sets the current audio language and current variant role to the selected
     * language and role, and chooses a new variant if need be. If the player has
     * not loaded any content, this will be a no-op.
     */
    selectAudioLanguage (language : string , role ? : string ) : any ;
    /**
     * Sets the current text language and current text role to the selected
     * language and role, and chooses a new variant if need be. If the player has
     * not loaded any content, this will be a no-op.
     */
    selectTextLanguage (language : string , role ? : string , forced ? : boolean ) : any ;
    /**
     * Select a specific text track. <code>track</code> should come from a call to
     * <code>getTextTracks</code>. If the track is not found, this will be a
     * no-op. If the player has not loaded content, this will be a no-op.
     * <p>
     * Note that <code>AdaptationEvents</code> are not fired for manual track
     * selections.
     */
    selectTextTrack (track : shaka.extern.Track ) : any ;
    /**
     * Select a specific variant track to play.  <code>track</code> should come
     * from a call to <code>getVariantTracks</code>. If <code>track</code> cannot
     * be found, this will be a no-op. If the player has not loaded content, this
     * will be a no-op.
     * <p>
     * Changing variants will take effect once the currently buffered content has
     * been played. To force the change to happen sooner, use
     * <code>clearBuffer</code> with <code>safeMargin</code>. Setting
     * <code>clearBuffer</code> to <code>true</code> will clear all buffered
     * content after <code>safeMargin</code>, allowing the new variant to start
     * playing sooner.
     * <p>
     * Note that <code>AdaptationEvents</code> are not fired for manual track
     * selections.
     * @param safeMargin Optional amount of buffer (in seconds) to retain when clearing the buffer. Useful for switching variant quickly without causing a buffering event. Defaults to 0 if not provided. Ignored if clearBuffer is false. Can cause hiccups on some browsers if chosen too small, e.g. The amount of two segments is a fair minimum to consider as safeMargin value.
     */
    selectVariantTrack (track : shaka.extern.Track , clearBuffer ? : boolean , safeMargin ? : number ) : any ;
    /**
     * Select variant tracks that have a given label. This assumes the
     * label uniquely identifies an audio stream, so all the variants
     * are expected to have the same variant.audio.
     */
    selectVariantsByLabel (label : string ) : any ;
    /**
     * Set the maximum resolution that the platform's hardware can handle.
     * This will be called automatically by <code>shaka.cast.CastReceiver</code>
     * to enforce limitations of the Chromecast hardware.
     */
    setMaxHardwareResolution (width : number , height : number ) : any ;
    /**
     * Enable or disable the text displayer.  If the player is in an unloaded
     * state, the request will be applied next time content is loaded.
     */
    setTextTrackVisibility (isVisible : boolean ) : any ;
    /**
     * Set the videoContainer to construct UITextDisplayer.
     */
    setVideoContainer (videoContainer : HTMLElement | null ) : any ;
    /**
     * Enable trick play to skip through content without playing by repeatedly
     * seeking. For example, a rate of 2.5 would result in 2.5 seconds of content
     * being skipped every second. A negative rate will result in moving
     * backwards.
     * <p>
     * If the player has not loaded content or is still loading content this will
     * be a no-op. Wait until <code>load</code> has completed before calling.
     * <p>
     * Trick play will be canceled automatically if the playhead hits the
     * beginning or end of the seekable range for the content.
     */
    trickPlay (rate : number ) : any ;
    /**
     * Tell the player to either return to:
     * <ul>
     * <li>detached (when it does not have a media element),
     * <li>attached (when it has a media element and
     * <code>initializedMediaSource=false</code>)
     * <li>media source initialized (when it has a media element and
     * <code>initializedMediaSource=true</code>)
     * </ul>
     * <p>
     * Calls to <code>unload</code> will interrupt any in-progress calls to
     * <code>load</code> but cannot interrupt calls to <code>attach</code>,
     * <code>detach</code>, or <code>unload</code>.
     */
    unload (initializeMediaSource ? : boolean ) : Promise < any > ;
    /**
     * Provides a way to update the stream start position during the media loading
     * process. Can for example be called from the <code>manifestparsed</code>
     * event handler to update the start position based on information in the
     * manifest.
     */
    updateStartTime (startTime : number ) : any ;
    /**
     * Return whether the browser provides basic support.  If this returns false,
     * Shaka Player cannot be used at all.  In this case, do not construct a
     * Player instance and do not use the library.
     */
    static isBrowserSupported ( ) : boolean ;
    /**
     * Probes the browser to determine what features are supported.  This makes a
     * number of requests to EME/MSE/etc which may result in user prompts.  This
     * should only be used for diagnostics.
     * <p>
     * NOTE: This may show a request to the user for permission.
     */
    static probeSupport (promptsOkay ? : boolean ) : Promise < shaka.extern.SupportType > ;
    /**
     * Registers a plugin callback that will be called with
     * <code>support()</code>.  The callback will return the value that will be
     * stored in the return value from <code>support()</code>.
     */
    static registerSupportPlugin (name : string , callback : ( ) => any ) : any ;
    /**
     * Set a factory to create an ad manager during player construction time.
     * This method needs to be called bafore instantiating the Player class.
     */
    static setAdManagerFactory (factory : shaka.extern.IAdManager.Factory ) : any ;
    static version : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.Player {
  /**
   * In order to know what method of loading the player used for some content, we
   * have this enum. It lets us know if content has not been loaded, loaded with
   * media source, or loaded with src equals.
   * This enum has a low resolution, because it is only meant to express the
   * outer limits of the various states that the player is in. For example, when
   * someone calls a public method on player, it should not matter if they have
   * initialized drm engine, it should only matter if they finished loading
   * content.
   */
  /**
   * In order to know what method of loading the player used for some content, we
   * have this enum. It lets us know if content has not been loaded, loaded with
   * media source, or loaded with src equals.
   * This enum has a low resolution, because it is only meant to express the
   * outer limits of the various states that the player is in. For example, when
   * someone calls a public method on player, it should not matter if they have
   * initialized drm engine, it should only matter if they finished loading
   * content.
   */
  enum LoadMode {
    DESTROYED = 0.0 ,
    MEDIA_SOURCE = 2.0 ,
    NOT_LOADED = 1.0 ,
    SRC_EQUALS = 3.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.abr {
  class SimpleAbrManager implements shaka.extern.AbrManager {
    private noStructuralTyping_shaka_abr_SimpleAbrManager : any;
    chooseVariant ( ) : any ;
    configure (config : any ) : any ;
    disable ( ) : any ;
    enable ( ) : any ;
    getBandwidthEstimate ( ) : any ;
    init (switchCallback : any ) : any ;
    playbackRateChanged (rate : any ) : any ;
    segmentDownloaded (deltaTimeMs : any , numBytes : any ) : any ;
    setMediaElement (mediaElement : any ) : any ;
    setVariants (variants : any ) : any ;
    stop ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.ads {
  /**
   * A class responsible for ad-related interactions.
   */
  class AdManager extends shaka.util.FakeEventTarget implements shaka.extern.IAdManager , shaka.util.IReleasable {
    private noStructuralTyping_shaka_ads_AdManager : any;
    getServerSideCuePoints ( ) : shaka.extern.AdCuePoint [] ;
    getStats ( ) : shaka.extern.AdsStats ;
    initClientSide (adContainer : any , video : any ) : any ;
    initServerSide (adContainer : any , video : any ) : any ;
    onAssetUnload ( ) : any ;
    onCueMetadataChange (value : any ) : any ;
    onDashTimedMetadata (region : any ) : any ;
    onHlsTimedMetadata (metadata : any , timestamp : any ) : any ;
    release ( ) : any ;
    replaceServerSideAdTagParameters (adTagParameters : any ) : any ;
    requestClientSideAds (imaRequest : any ) : any ;
    requestServerSideStream (imaRequest : google.ima.dai.api.StreamRequest , backupUrl ? : string ) : Promise < string > ;
    setLocale (locale : any ) : any ;
    /**
     * The event name for when a sequence of ads has been loaded.
     */
    static ADS_LOADED : string ;
    /**
     * The event name for when the client side SDK signalled its readiness
     * to play a VPAID ad or an ad rule.
     */
    static AD_BREAK_READY : string ;
    /**
     * The event name for when the ad is buffering.
     */
    static AD_BUFFERING : string ;
    /**
     * The event name for when the ad was clicked.
     */
    static AD_CLICKED : string ;
    /**
     * The event name for when the ad was closed by the user.
     */
    static AD_CLOSED : string ;
    /**
     * The event name for when an ad has completed playing.
     */
    static AD_COMPLETE : string ;
    /**
     * The event name for when the ad's duration changed.
     */
    static AD_DURATION_CHANGED : string ;
    /**
     * The event name for when an ad playhead crosses first quartile.
     */
    static AD_FIRST_QUARTILE : string ;
    /**
     * The event name for when the ad's URL was hit.
     */
    static AD_IMPRESSION : string ;
    /**
     * The event name for when the interaction callback for the ad was
     * triggered.
     */
    static AD_INTERACTION : string ;
    /**
     * The event name for when the ad changes from or to linear.
     */
    static AD_LINEAR_CHANGED : string ;
    /**
     * The event name for when the ad data becomes available.
     */
    static AD_LOADED : string ;
    /**
     * The event name for when the ad's metadata becomes available.
     */
    static AD_METADATA : string ;
    /**
     * The event name for when an ad playhead crosses midpoint.
     */
    static AD_MIDPOINT : string ;
    /**
     * The event name for when the ad was muted.
     */
    static AD_MUTED : string ;
    /**
     * The event name for when the ad was paused.
     */
    static AD_PAUSED : string ;
    /**
     * The event name for when there is an update to the current ad's progress.
     */
    static AD_PROGRESS : string ;
    /**
     * The event name for when the ad display encountered a recoverable
     * error.
     */
    static AD_RECOVERABLE_ERROR : string ;
    /**
     * The event name for when the ad was resumed after a pause.
     */
    static AD_RESUMED : string ;
    /**
     * The event name for when an ad is skipped by the user..
     */
    static AD_SKIPPED : string ;
    /**
     * The event name for when the ad's skip status changes
     * (usually it becomes skippable when it wasn't before).
     */
    static AD_SKIP_STATE_CHANGED : string ;
    /**
     * The event name for when an ad has started playing.
     */
    static AD_STARTED : string ;
    /**
     * The event name for when an ad has finished playing
     * (played all the way through, was skipped, or was unable to proceed
     * due to an error).
     */
    static AD_STOPPED : string ;
    /**
     * The event name for when an ad playhead crosses third quartile.
     */
    static AD_THIRD_QUARTILE : string ;
    /**
     * The event name for when the ad volume has changed.
     */
    static AD_VOLUME_CHANGED : string ;
    /**
     * The event name for when all the ads were completed.
     */
    static ALL_ADS_COMPLETED : string ;
    /**
     * The event name for when the ad's cue points (start/end markers)
     * have changed.
     */
    static CUEPOINTS_CHANGED : string ;
    /**
     * The event name for when the native IMA ad manager object has
     * loaded and become available.
     */
    static IMA_AD_MANAGER_LOADED : string ;
    /**
     * The event name for when the native IMA stream manager object has
     * loaded and become available.
     */
    static IMA_STREAM_MANAGER_LOADED : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.ads {
  class ClientSideAd implements shaka.extern.IAd {
    private noStructuralTyping_shaka_ads_ClientSideAd : any;
    constructor (imaAd : google.ima.Ad , imaAdManager : google.ima.AdsManager , video : HTMLMediaElement | null ) ;
    canSkipNow ( ) : any ;
    getDuration ( ) : any ;
    getMinSuggestedDuration ( ) : any ;
    getPositionInSequence ( ) : any ;
    getRemainingTime ( ) : any ;
    getSequenceLength ( ) : any ;
    getTimeUntilSkippable ( ) : any ;
    getVolume ( ) : any ;
    isLinear ( ) : any ;
    isMuted ( ) : any ;
    isPaused ( ) : any ;
    isSkippable ( ) : any ;
    pause ( ) : any ;
    play ( ) : any ;
    release ( ) : any ;
    resize (width : any , height : any ) : any ;
    setMuted (muted : any ) : any ;
    setVolume (volume : any ) : any ;
    skip ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.ads {
  class ServerSideAd implements shaka.extern.IAd {
    private noStructuralTyping_shaka_ads_ServerSideAd : any;
    constructor (imaAd : google.ima.dai.api.Ad | null , video : HTMLMediaElement | null ) ;
    canSkipNow ( ) : any ;
    getDuration ( ) : any ;
    getMinSuggestedDuration ( ) : any ;
    getPositionInSequence ( ) : any ;
    getRemainingTime ( ) : any ;
    getSequenceLength ( ) : any ;
    getTimeUntilSkippable ( ) : any ;
    getVolume ( ) : any ;
    isLinear ( ) : any ;
    isMuted ( ) : any ;
    isPaused ( ) : any ;
    isSkippable ( ) : any ;
    pause ( ) : any ;
    play ( ) : any ;
    release ( ) : any ;
    resize (width : any , height : any ) : any ;
    setMuted (muted : any ) : any ;
    setVolume (volume : any ) : any ;
    skip ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.cast {
  class CastProxy extends shaka.util.FakeEventTarget implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_cast_CastProxy : any;
    constructor (video : HTMLMediaElement , player : shaka.Player , receiverAppId : string , androidReceiverCompatible : boolean ) ;
    canCast ( ) : boolean ;
    cast ( ) : Promise < any > ;
    changeReceiverId (newAppId : string , newCastAndroidReceiver ? : boolean ) : any ;
    /**
     * Destroys the proxy and the underlying local Player.
     * @param forceDisconnect If true, force the receiver app to shut down by disconnecting.  Does nothing if not connected.
     */
    destroy (forceDisconnect ? : boolean ) : Promise < any > ;
    /**
     * Force the receiver app to shut down by disconnecting.
     */
    forceDisconnect ( ) : any ;
    /**
     * Get a proxy for the Player that delegates to local and remote Player
     * objects as appropriate.
     */
    getPlayer ( ) : shaka.Player ;
    /**
     * Get a proxy for the video element that delegates to local and remote video
     * elements as appropriate.
     */
    getVideo ( ) : HTMLMediaElement ;
    isCasting ( ) : boolean ;
    receiverName ( ) : string ;
    /**
     * Set application-specific data.
     * @param appData Application-specific data to relay to the receiver.
     */
    setAppData (appData : object | null ) : any ;
    /**
     * Show a dialog where user can choose to disconnect from the cast connection.
     */
    suggestDisconnect ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.cast {
  /**
   * A receiver to communicate between the Chromecast-hosted player and the
   * sender application.
   */
  class CastReceiver extends shaka.util.FakeEventTarget implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_cast_CastReceiver : any;
    /**
     * A receiver to communicate between the Chromecast-hosted player and the
     * sender application.
     */
    constructor (video : HTMLMediaElement , player : shaka.Player , appDataCallback ? : (a : object | null ) => any , contentIdCallback ? : (a : string ) => string ) ;
    /**
     * Clear all Cast content metadata.
     * Should be called from an appDataCallback.
     */
    clearContentMetadata ( ) : any ;
    /**
     * Destroys the underlying Player, then terminates the cast receiver app.
     */
    destroy ( ) : Promise < any > ;
    isConnected ( ) : boolean ;
    isIdle ( ) : boolean ;
    /**
     * Set the Cast content's artist.
     * Also sets the metadata type to music.
     * Should be called from an appDataCallback.
     */
    setContentArtist (artist : string ) : any ;
    /**
     * Set the Cast content's thumbnail image.
     * Should be called from an appDataCallback.
     */
    setContentImage (imageUrl : string ) : any ;
    /**
     * Set all Cast content metadata, as defined by the Cast SDK.
     * Should be called from an appDataCallback.
     * For a simpler way to set basic metadata, see:
     * - setContentTitle()
     * - setContentImage()
     * - setContentArtist()
     * @param metadata A Cast metadata object, one of: - https://developers.google.com/cast/docs/reference/messages#GenericMediaMetadata - https://developers.google.com/cast/docs/reference/messages#MovieMediaMetadata - https://developers.google.com/cast/docs/reference/messages#TvShowMediaMetadata - https://developers.google.com/cast/docs/reference/messages#MusicTrackMediaMetadata
     */
    setContentMetadata (metadata : object | null ) : any ;
    /**
     * Set the Cast content's title.
     * Should be called from an appDataCallback.
     */
    setContentTitle (title : string ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.dash {
  /**
   * Creates a new DASH parser.
   */
  class DashParser implements shaka.extern.ManifestParser {
    private noStructuralTyping_shaka_dash_DashParser : any;
    configure (config : any ) : any ;
    onExpirationUpdated (sessionId : any , expiration : any ) : any ;
    start (uri : any , playerInterface : any ) : any ;
    stop ( ) : any ;
    update ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka {
  class dependencies {
    private noStructuralTyping_shaka_dependencies : any;
    /**
     * Registers a new dependency.
     * @param key which is used for retrieving a dependency
     * @param dep a dependency
     */
    static add (key : shaka.dependencies.Allowed , dep : any ) : any ;
    /**
     * Check if we have a dependency for the key.
     * @param key key
     */
    static has (key : shaka.dependencies.Allowed ) : boolean ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.dependencies {
  enum Allowed {
    muxjs = 'muxjs' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.hls {
  /**
   * HLS parser.
   */
  class HlsParser implements shaka.extern.ManifestParser {
    private noStructuralTyping_shaka_hls_HlsParser : any;
    configure (config : any ) : any ;
    onExpirationUpdated (sessionId : any , expiration : any ) : any ;
    start (uri : any , playerInterface : any ) : any ;
    stop ( ) : any ;
    update ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.media {
  /**
   * Creates an InitSegmentReference, which provides the location to an
   * initialization segment.
   */
  class InitSegmentReference {
    private noStructuralTyping_shaka_media_InitSegmentReference : any;
    constructor (uris : ( ) => string [] , startByte : number , endByte : number | null , mediaQuality ? : null | shaka.extern.MediaQualityInfo ) ;
    /**
     * Returns the offset from the start of the resource to the end of the
     * segment, inclusive.  A value of null indicates that the segment extends
     * to the end of the resource.
     */
    getEndByte ( ) : number | null ;
    /**
     * Returns the offset from the start of the resource to the
     * start of the segment.
     */
    getStartByte ( ) : number ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.media {
  class ManifestParser {
    private noStructuralTyping_shaka_media_ManifestParser : any;
    /**
     * Registers a manifest parser by file extension.
     * @param extension The file extension of the manifest.
     * @param parserFactory The factory used to create parser instances.
     */
    static registerParserByExtension (extension : string , parserFactory : shaka.extern.ManifestParser.Factory ) : any ;
    /**
     * Registers a manifest parser by MIME type.
     * @param mimeType The MIME type of the manifest.
     * @param parserFactory The factory used to create parser instances.
     */
    static registerParserByMime (mimeType : string , parserFactory : shaka.extern.ManifestParser.Factory ) : any ;
    /**
     * Unregisters a manifest parser by MIME type.
     * @param mimeType The MIME type of the manifest.
     */
    static unregisterParserByMime (mimeType : string ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.media {
  /**
   * A meta-SegmentIndex composed of multiple other SegmentIndexes.
   * Used in constructing multi-Period Streams for DASH.
   */
  class MetaSegmentIndex extends shaka.media.SegmentIndex implements Iterable < shaka.media.SegmentReference > {
    private noStructuralTyping_shaka_media_MetaSegmentIndex : any;
    /**
     * A meta-SegmentIndex composed of multiple other SegmentIndexes.
     * Used in constructing multi-Period Streams for DASH.
     */
    constructor ( ) ;
    //!! Symbol.iterator inserted by Clutz for Iterable subtype
    [Symbol.iterator]():  Iterator < shaka.media.SegmentReference > ;
    evict (time : number ) : any ;
    find (time : number ) : number | null ;
    fit (windowStart : number , windowEnd : number | null , c ? : boolean ) : any ;
    get (position : number ) : shaka.media.SegmentReference | null ;
    merge (references : any ) : any ;
    mergeAndEvict (references : shaka.media.SegmentReference [] , windowStart : number ) : any ;
    offset (offset : number ) : any ;
    release ( ) : any ;
    updateEvery (interval : number , updateCallback : ( ) => ( shaka.media.SegmentReference | null ) [] | null ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.media {
  /**
   * PresentationTimeline.
   */
  class PresentationTimeline {
    private noStructuralTyping_shaka_media_PresentationTimeline : any;
    constructor (presentationStartTime : number | null , presentationDelay : number , autoCorrectDrift ? : boolean ) ;
    /**
     * Gets the presentation delay in seconds.
     */
    getDelay ( ) : number ;
    getDuration ( ) : number ;
    getMaxSegmentDuration ( ) : number ;
    getPresentationStartTime ( ) : number | null ;
    /**
     * Gets the seek range start time, offset by the given amount.  This is used
     * to ensure that we don't "fall" back out of the seek window while we are
     * buffering.
     * @param offset The offset to add to the start time for live streams.
     */
    getSafeSeekRangeStart (offset : number ) : number ;
    /**
     * Gets the seek range end.
     */
    getSeekRangeEnd ( ) : number ;
    /**
     * Gets the seek range start time.
     */
    getSeekRangeStart ( ) : number ;
    /**
     * Gets the presentation's current segment availability end time.  Segments
     * starting after this time should be assumed to be unavailable.
     */
    getSegmentAvailabilityEnd ( ) : number ;
    /**
     * Gets the presentation's current segment availability start time.  Segments
     * ending at or before this time should be assumed to be unavailable.
     */
    getSegmentAvailabilityStart ( ) : number ;
    isInProgress ( ) : boolean ;
    isLive ( ) : boolean ;
    /**
     * Lock the presentation timeline's start time.  After this is called, no
     * further adjustments to presentationStartTime_ will be permitted.
     * This should be called after all Periods have been parsed, and all calls to
     * notifySegments() from the initial manifest parse have been made.
     * Without this, we can get assertion failures in SegmentIndex for certain
     * DAI content.  If DAI adds ad segments to the manifest faster than
     * real-time, adjustments to presentationStartTime_ can cause availability
     * windows to jump around on updates.
     */
    lockStartTime ( ) : any ;
    /**
     * Gives PresentationTimeline a Stream's maximum segment duration so it can
     * size and position the segment availability window.  This function should be
     * called once for each Stream (no more, no less), but does not have to be
     * called if notifySegments() is called instead for a particular stream.
     * @param maxSegmentDuration The maximum segment duration for a particular stream.
     */
    notifyMaxSegmentDuration (maxSegmentDuration : number ) : any ;
    /**
     * Gives PresentationTimeline a Stream's minimum segment start time.
     */
    notifyMinSegmentStartTime (startTime : number ) : any ;
    /**
     * Gives PresentationTimeline a Stream's segments so it can size and position
     * the segment availability window, and account for missing segment
     * information.  This function should be called once for each Stream (no more,
     * no less).
     */
    notifySegments (references : shaka.media.SegmentReference [] ) : any ;
    /**
     * Offsets the segment times by the given amount.
     * @param offset The number of seconds to offset by.  A positive number adjusts the segment times forward.
     */
    offset (offset : number ) : any ;
    /**
     * Sets the presentation's segment availability time offset. This should be
     * only set for Low Latency Dash.
     * The segments are available earlier for download than the availability start
     * time, so we can move closer to the live edge.
     */
    setAvailabilityTimeOffset (offset : number ) : any ;
    /**
     * Sets the clock offset, which is the difference between the client's clock
     * and the server's clock, in milliseconds (i.e., serverTime = Date.now() +
     * clockOffset).
     * @param offset The clock offset, in ms.
     */
    setClockOffset (offset : number ) : any ;
    /**
     * Sets the presentation delay in seconds.
     */
    setDelay (delay : number ) : any ;
    /**
     * Sets the presentation's duration.
     * @param duration The presentation's duration in seconds. Infinity indicates that the presentation continues indefinitely.
     */
    setDuration (duration : number ) : any ;
    /**
     * Sets the presentation's segment availability duration. The segment
     * availability duration should only be set for live.
     * @param segmentAvailabilityDuration The presentation's new segment availability duration in seconds.
     */
    setSegmentAvailabilityDuration (segmentAvailabilityDuration : number ) : any ;
    /**
     * Sets the presentation's static flag.
     * @param isStatic If true, the presentation is static, meaning all segments are available at once.
     */
    setStatic (isStatic : boolean ) : any ;
    /**
     * Sets the start time of the user-defined seek range.  This is only used for
     * VOD content.
     */
    setUserSeekStart (time : number ) : any ;
    /**
     * True if the presentation start time is being used to calculate the live
     * edge.
     * Using the presentation start time means that the stream may be subject to
     * encoder drift.  At runtime, we will avoid using the presentation start time
     * whenever possible.
     */
    usingPresentationStartTime ( ) : boolean ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.media {
  /**
   * SegmentIndex.
   */
  class SegmentIndex implements Iterable < shaka.media.SegmentReference > {
    private noStructuralTyping_shaka_media_SegmentIndex : any;
    /**
     * SegmentIndex.
     */
    constructor (references : shaka.media.SegmentReference [] ) ;
    //!! Symbol.iterator inserted by Clutz for Iterable subtype
    [Symbol.iterator]():  Iterator < shaka.media.SegmentReference > ;
    /**
     * Removes all SegmentReferences that end before the given time.
     * @param time The time in seconds.
     */
    evict (time : number ) : any ;
    /**
     * Finds the position of the segment for the given time, in seconds, relative
     * to the start of the presentation.  Returns the position of the segment
     * with the largest end time if more than one segment is known for the given
     * time.
     */
    find (time : number ) : number | null ;
    /**
     * Drops references that start after windowEnd, or end before windowStart,
     * and contracts the last reference so that it ends at windowEnd.
     * Do not call on the last period of a live presentation (unknown duration).
     * It is okay to call on the other periods of a live presentation, where the
     * duration is known and another period has been added.
     * @param isNew Whether this is a new SegmentIndex and we shouldn't update the number of evicted elements.
     */
    fit (windowStart : number , windowEnd : number | null , isNew ? : boolean ) : any ;
    /**
     * Gets the SegmentReference for the segment at the given position.
     * @param position The position of the segment as returned by find().
     */
    get (position : number ) : shaka.media.SegmentReference | null ;
    /**
     * Returns a new iterator that initially points to the segment that contains
     * the given time.  Like the normal iterator, next() must be called first to
     * get to the first element. Returns null if we do not find a segment at the
     * requested time.
     */
    getIteratorForTime (time : number ) : shaka.media.SegmentIterator | null ;
    /**
     * Marks the index as immutable.  Segments cannot be added or removed after
     * this point.  This doesn't affect the references themselves.  This also
     * makes the destroy/release methods do nothing.
     * This is mainly for testing.
     */
    markImmutable ( ) : any ;
    /**
     * Merges the given SegmentReferences and evicts the ones that end before the
     * given time.  Supports extending the original references only.
     * Will not replace old references or interleave new ones.
     * Used, for example, by the DASH and HLS parser, where manifests may not list
     * all available references, so we must keep available references in memory to
     * fill the availability window.
     * @param references The list of SegmentReferences, which must be sorted first by their start times (ascending) and second by their end times (ascending).
     * @param windowStart The start of the availability window to filter out the references that are no longer available.
     */
    mergeAndEvict (references : shaka.media.SegmentReference [] , windowStart : number ) : any ;
    /**
     * Offset all segment references by a fixed amount.
     * @param offset The amount to add to each segment's start and end times.
     */
    offset (offset : number ) : any ;
    release ( ) : any ;
    /**
     * Updates the references every so often.  Stops when the references list
     * returned by the callback is null.
     * @param interval The interval in seconds.
     */
    updateEvery (interval : number , updateCallback : ( ) => ( shaka.media.SegmentReference | null ) [] | null ) : any ;
    /**
     * Create a SegmentIndex for a single segment of the given start time and
     * duration at the given URIs.
     */
    static forSingleSegment (startTime : number , duration : number , uris : string [] ) : shaka.media.SegmentIndex ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.media {
  /**
   * An iterator over a SegmentIndex's references.
   */
  class SegmentIterator implements Iterator < shaka.media.SegmentReference | null > {
    private noStructuralTyping_shaka_media_SegmentIterator : any;
    /**
     * An iterator over a SegmentIndex's references.
     */
    constructor (segmentIndex : shaka.media.SegmentIndex | null , index : number , partialSegmentIndex : number ) ;
    current ( ) : shaka.media.SegmentReference | null ;
    currentPosition ( ) : number ;
    next ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.media {
  /**
   * SegmentReference provides the start time, end time, and location to a media
   * segment.
   */
  class SegmentReference {
    private noStructuralTyping_shaka_media_SegmentReference : any;
    constructor (startTime : number , endTime : number , uris : ( ) => string [] , startByte : number , endByte : number | null , initSegmentReference : shaka.media.InitSegmentReference | null , timestampOffset : number , appendWindowStart : number , appendWindowEnd : number , partialReferences ? : shaka.media.SegmentReference [] , tilesLayout ? : string | null , tileDuration ? : number | null , syncTime ? : number | null , status ? : shaka.media.SegmentReference.Status , hlsAes128Key ? : shaka.extern.HlsAes128Key | null ) ;
    /**
     * Returns the offset from the start of the resource to the end of the
     * segment, inclusive.  A value of null indicates that the segment extends to
     * the end of the resource.
     */
    getEndByte ( ) : number | null ;
    /**
     * Returns the segment's end time in seconds.
     */
    getEndTime ( ) : number ;
    /**
     * Returns the offset from the start of the resource to the
     * start of the segment.
     */
    getStartByte ( ) : number ;
    /**
     * Returns the segment's start time in seconds.
     */
    getStartTime ( ) : number ;
    /**
     * Returns the segment's status.
     */
    getStatus ( ) : shaka.media.SegmentReference.Status ;
    /**
     * Returns the segment's explicit tile duration.
     * Only defined in image segments.
     */
    getTileDuration ( ) : number | null ;
    /**
     * Returns the segment's tiles layout. Only defined in image segments.
     */
    getTilesLayout ( ) : string | null ;
    /**
     * Creates and returns the URIs of the resource containing the segment.
     */
    getUris ( ) : string [] ;
    /**
     * Mark the reference as unavailable.
     */
    markAsUnavailable ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.media.SegmentReference {
  /**
   * Rather than using booleans to communicate what the state of the reference,
   * we have this enum.
   */
  /**
   * Rather than using booleans to communicate what the state of the reference,
   * we have this enum.
   */
  enum Status {
    AVAILABLE = 0.0 ,
    MISSING = 2.0 ,
    UNAVAILABLE = 1.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.net {
  class DataUriPlugin {
    private noStructuralTyping_shaka_net_DataUriPlugin : any;
    static parse (uri : string , request : shaka.extern.Request , requestType : shaka.net.NetworkingEngine.RequestType , progressUpdated : shaka.extern.ProgressUpdated ) : shaka.extern.IAbortableOperation < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.net {
  class HttpFetchPlugin {
    private noStructuralTyping_shaka_net_HttpFetchPlugin : any;
    /**
     * Determine if the Fetch API is supported in the browser. Note: this is
     * deliberately exposed as a method to allow the client app to use the same
     * logic as Shaka when determining support.
     */
    static isSupported ( ) : boolean ;
    static parse (uri : string , request : shaka.extern.Request , requestType : shaka.net.NetworkingEngine.RequestType , progressUpdated : shaka.extern.ProgressUpdated , headersReceived : shaka.extern.HeadersReceived ) : shaka.extern.IAbortableOperation < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.net {
  class HttpXHRPlugin {
    private noStructuralTyping_shaka_net_HttpXHRPlugin : any;
    static parse (uri : string , request : shaka.extern.Request , requestType : shaka.net.NetworkingEngine.RequestType , progressUpdated : shaka.extern.ProgressUpdated , headersReceived : shaka.extern.HeadersReceived ) : shaka.extern.IAbortableOperation < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.net {
  /**
   * NetworkingEngine wraps all networking operations.  This accepts plugins that
   * handle the actual request.  A plugin is registered using registerScheme.
   * Each scheme has at most one plugin to handle the request.
   */
  class NetworkingEngine extends shaka.util.FakeEventTarget implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_net_NetworkingEngine : any;
    /**
     * NetworkingEngine wraps all networking operations.  This accepts plugins that
     * handle the actual request.  A plugin is registered using registerScheme.
     * Each scheme has at most one plugin to handle the request.
     */
    constructor (onProgressUpdated ? : (a : number , b : number ) => any , onHeadersReceived ? : shaka.net.NetworkingEngine.OnHeadersReceived , onDownloadFailed ? : shaka.net.NetworkingEngine.OnDownloadFailed ) ;
    /**
     * Clears all request filters.
     */
    clearAllRequestFilters ( ) : any ;
    /**
     * Clears all response filters.
     */
    clearAllResponseFilters ( ) : any ;
    destroy ( ) : Promise < any > ;
    /**
     * Registers a new request filter.  All filters are applied in the order they
     * are registered.
     */
    registerRequestFilter (filter : shaka.extern.RequestFilter ) : any ;
    /**
     * Registers a new response filter.  All filters are applied in the order they
     * are registered.
     */
    registerResponseFilter (filter : shaka.extern.ResponseFilter ) : any ;
    /**
     * Makes a network request and returns the resulting data.
     */
    request (type : shaka.net.NetworkingEngine.RequestType , request : shaka.extern.Request ) : shaka.net.NetworkingEngine.PendingRequest ;
    setForceHTTPS (forceHTTPS : boolean ) : any ;
    /**
     * Removes a request filter.
     */
    unregisterRequestFilter (filter : shaka.extern.RequestFilter ) : any ;
    /**
     * Removes a response filter.
     */
    unregisterResponseFilter (filter : shaka.extern.ResponseFilter ) : any ;
    /**
     * Gets a copy of the default retry parameters.
     */
    static defaultRetryParameters ( ) : shaka.extern.RetryParameters ;
    /**
     * Makes a simple network request for the given URIs.
     */
    static makeRequest (uris : string [] , retryParams : shaka.extern.RetryParameters , streamDataCallback ? : ( (a : ArrayBuffer | ArrayBufferView ) => Promise < any > ) | null ) : shaka.extern.Request ;
    /**
     * Registers a scheme plugin.  This plugin will handle all requests with the
     * given scheme.  If a plugin with the same scheme already exists, it is
     * replaced, unless the existing plugin is of higher priority.
     * If no priority is provided, this defaults to the highest priority of
     * APPLICATION.
     */
    static registerScheme (scheme : string , plugin : shaka.extern.SchemePlugin , priority ? : number , progressSupport ? : boolean ) : any ;
    /**
     * Removes a scheme plugin.
     */
    static unregisterScheme (scheme : string ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.net.NetworkingEngine {
  /**
   * A wrapper class for the number of bytes remaining to be downloaded for the
   * request.
   * Instead of using PendingRequest directly, this class is needed to be sent to
   * plugin as a parameter, and a Promise is returned, before PendingRequest is
   * created.
   */
  class NumBytesRemainingClass {
    private noStructuralTyping_shaka_net_NetworkingEngine_NumBytesRemainingClass : any;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.net.NetworkingEngine {
  type OnDownloadFailed = (a : shaka.extern.Request , b : shaka.util.Error | null , c : number , d : boolean ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.net.NetworkingEngine {
  type OnHeadersReceived = (a : { [ key: string ]: string } , b : shaka.extern.Request , c : shaka.net.NetworkingEngine.RequestType ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.net.NetworkingEngine {
  /**
   * A pending network request. This can track the current progress of the
   * download, and allows the request to be aborted if the network is slow.
   */
  class PendingRequest extends shaka.util.AbortableOperation < any > implements shaka.extern.IAbortableOperation < any > {
    private noStructuralTyping_shaka_net_NetworkingEngine_PendingRequest : any;
    /**
     * A pending network request. This can track the current progress of the
     * download, and allows the request to be aborted if the network is slow.
     */
    constructor (promise : Promise < any > , onAbort : shaka.extern.CreateSegmentIndexFunction , numBytesRemainingObj : shaka.net.NetworkingEngine.NumBytesRemainingClass | null ) ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.net.NetworkingEngine {
  /**
   * Priority level for network scheme plugins.
   * If multiple plugins are provided for the same scheme, only the
   * highest-priority one is used.
   */
  /**
   * Priority level for network scheme plugins.
   * If multiple plugins are provided for the same scheme, only the
   * highest-priority one is used.
   */
  enum PluginPriority {
    APPLICATION = 3.0 ,
    FALLBACK = 1.0 ,
    PREFERRED = 2.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.net.NetworkingEngine {
  /**
   * Request types.  Allows a filter to decide which requests to read/alter.
   */
  /**
   * Request types.  Allows a filter to decide which requests to read/alter.
   */
  enum RequestType {
    APP = 3.0 ,
    KEY = 6.0 ,
    LICENSE = 2.0 ,
    MANIFEST = 0.0 ,
    SEGMENT = 1.0 ,
    SERVER_CERTIFICATE = 5.0 ,
    TIMING = 4.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.offline {
  class OfflineScheme {
    private noStructuralTyping_shaka_offline_OfflineScheme : any;
    static plugin (uri : string , request : shaka.extern.Request , requestType : shaka.net.NetworkingEngine.RequestType , progressUpdated : shaka.extern.ProgressUpdated ) : shaka.extern.IAbortableOperation < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.offline {
  class Storage implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_offline_Storage : any;
    constructor (player ? : shaka.Player ) ;
    /**
     * Sets configuration values for Storage.  This is associated with
     * Player.configure and will change the player instance given at
     * initialization.
     * @param config This should either be a field name or an object following the form of {@link shaka.extern.PlayerConfiguration}, where you may omit any field you do not wish to change.
     * @param value This should be provided if the previous parameter was a string field name.
     */
    configure (config : string | object , value ? : any ) : boolean ;
    destroy ( ) : Promise < any > ;
    /**
     * Return a copy of the current configuration.  Modifications of the returned
     * value will not affect the Storage instance's active configuration.  You
     * must call storage.configure() to make changes.
     */
    getConfiguration ( ) : shaka.extern.PlayerConfiguration ;
    /**
     * Return the networking engine that storage is using. If storage was
     * initialized with a player instance, then the networking engine returned
     * will be the same as |player.getNetworkingEngine()|.
     * The returned value will only be null if |destroy| was called before
     * |getNetworkingEngine|.
     */
    getNetworkingEngine ( ) : shaka.net.NetworkingEngine | null ;
    /**
     * Lists all the stored content available.
     */
    list ( ) : Promise < shaka.extern.StoredContent [] > ;
    /**
     * Removes the given stored content.  This will also attempt to release the
     * licenses, if any.
     */
    remove (contentUri : string ) : Promise < any > ;
    /**
     * Removes any EME sessions that were not successfully removed before.  This
     * returns whether all the sessions were successfully removed.
     */
    removeEmeSessions ( ) : Promise < boolean > ;
    /**
     * Stores the given manifest.  If the content is encrypted, and encrypted
     * content cannot be stored on this platform, the Promise will be rejected
     * with error code 6001, REQUESTED_KEY_SYSTEM_CONFIG_UNAVAILABLE.
     * Multiple assets can be downloaded at the same time, but note that since
     * the storage instance has a single networking engine, multiple storage
     * objects will be necessary if some assets require unique network filters.
     * This snapshots the storage config at the time of the call, so it will not
     * honor any changes to config mid-store operation.
     * @param uri The URI of the manifest to store.
     * @param appMetadata An arbitrary object from the application that will be stored along-side the offline content.  Use this for any application-specific metadata you need associated with the stored content.  For details on the data types that can be stored here, please refer to {@link https://bit.ly/StructClone}
     * @param mimeType The mime type for the content |manifestUri| points to.
     */
    store (uri : string , appMetadata ? : object , mimeType ? : string ) : shaka.extern.IAbortableOperation < any > ;
    /**
     * Delete the on-disk storage and all the content it contains. This should not
     * be done in normal circumstances. Only do it when storage is rendered
     * unusable, such as by a version mismatch. No business logic will be run, and
     * licenses will not be released.
     */
    static deleteAll ( ) : Promise < any > ;
    /**
     * Gets whether offline storage is supported.  Returns true if offline storage
     * is supported for clear content.  Support for offline storage of encrypted
     * content will not be determined until storage is attempted.
     */
    static support ( ) : boolean ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.offline {
  /**
   * StorageMuxer is responsible for managing StorageMechanisms and addressing
   * cells. The primary purpose of the muxer is to give the caller the correct
   * cell for the operations they want to perform.
   * |findActive| will be used when the caller wants a cell that supports
   * add-operations. This will be used when saving new content to storage.
   * |findAll| will be used when the caller want to look at all the content
   * in storage.
   * |resolvePath| will be used to convert a path (from |findActive| and
   * |findAll|) into a cell, which it then returns.
   */
  class StorageMuxer implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_offline_StorageMuxer : any;
    /**
     * Free all resources used by the muxer, mechanisms, and cells. This should
     * not affect the stored content.
     */
    destroy ( ) : Promise < any > ;
    /**
     * Register a storage mechanism for use with the default storage muxer. This
     * will have no effect on any storage muxer already in main memory.
     */
    static register (name : string , factory : ( ) => shaka.extern.StorageMechanism | null ) : any ;
    /**
     * Unregister a storage mechanism for use with the default storage muxer. This
     * will have no effect on any storage muxer already in main memory.
     * @param name The name that the storage mechanism was registered under.
     */
    static unregister (name : string ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka {
  class polyfill {
    private noStructuralTyping_shaka_polyfill : any;
    /**
     * Install all polyfills.
     */
    static installAll ( ) : any ;
    /**
     * Registers a new polyfill to be installed.
     * @param priority An optional number priority.  Higher priorities will be executed before lower priority ones.  Default is 0.
     */
    static register (polyfill : ( ) => any , priority ? : number ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class Aria {
    private noStructuralTyping_shaka_polyfill_Aria : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class EncryptionScheme {
    private noStructuralTyping_shaka_polyfill_EncryptionScheme : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class Fullscreen {
    private noStructuralTyping_shaka_polyfill_Fullscreen : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class MediaCapabilities {
    private noStructuralTyping_shaka_polyfill_MediaCapabilities : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
    /**
     * A copy of the MediaCapabilities instance, to prevent Safari from
     * garbage-collecting the polyfilled method on it.  We make it public and export
     * it to ensure that it is not stripped out by the compiler.
     */
    static originalMcap : any | null ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class MediaSource {
    private noStructuralTyping_shaka_polyfill_MediaSource : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class Orientation {
    private noStructuralTyping_shaka_polyfill_Orientation : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class PatchedMediaKeysApple {
    private noStructuralTyping_shaka_polyfill_PatchedMediaKeysApple : any;
    /**
     * Installs the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class PatchedMediaKeysNop {
    private noStructuralTyping_shaka_polyfill_PatchedMediaKeysNop : any;
    /**
     * Installs the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class PatchedMediaKeysWebkit {
    private noStructuralTyping_shaka_polyfill_PatchedMediaKeysWebkit : any;
    /**
     * Installs the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class PiPWebkit {
    private noStructuralTyping_shaka_polyfill_PiPWebkit : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class RandomUUID {
    private noStructuralTyping_shaka_polyfill_RandomUUID : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class StorageEstimate {
    private noStructuralTyping_shaka_polyfill_StorageEstimate : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class Symbol {
    private noStructuralTyping_shaka_polyfill_Symbol : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class VTTCue {
    private noStructuralTyping_shaka_polyfill_VTTCue : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class VideoPlayPromise {
    private noStructuralTyping_shaka_polyfill_VideoPlayPromise : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.polyfill {
  class VideoPlaybackQuality {
    private noStructuralTyping_shaka_polyfill_VideoPlaybackQuality : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  class Cue implements shaka.extern.Cue {
    private noStructuralTyping_shaka_text_Cue : any;
    constructor (startTime : number , endTime : number , payload : string ) ;
    backgroundColor : any ;
    backgroundImage : any ;
    border : any ;
    cellResolution : any ;
    color : any ;
    direction : any ;
    /**
     * Set the captions at the bottom of the text container by default.
     */
    displayAlign : any ;
    endTime : any ;
    fontFamily : any ;
    fontSize : any ;
    fontStyle : any ;
    fontWeight : any ;
    id : any ;
    isContainer : any ;
    letterSpacing : any ;
    line : any ;
    /**
     * Line Alignment is set to start by default.
     */
    lineAlign : any ;
    lineBreak : any ;
    lineHeight : any ;
    lineInterpretation : any ;
    linePadding : any ;
    nestedCues : any ;
    opacity : any ;
    payload : any ;
    position : any ;
    positionAlign : any ;
    region : any ;
    size : any ;
    startTime : any ;
    textAlign : any ;
    textDecoration : any ;
    textShadow : any ;
    textStrokeColor : any ;
    textStrokeWidth : any ;
    wrapLine : any ;
    writingMode : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  /**
   * Default text background color according to
   * https://w3c.github.io/webvtt/#default-text-background
   */
  /**
   * Default text background color according to
   * https://w3c.github.io/webvtt/#default-text-background
   */
  enum defaultTextBackgroundColor {
    bg_black = '#000' ,
    bg_blue = '#00F' ,
    bg_cyan = '#0FF' ,
    bg_lime = '#0F0' ,
    bg_magenta = '#F0F' ,
    bg_red = '#F00' ,
    bg_white = '#FFF' ,
    bg_yellow = '#FF0' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  /**
   * Default text color according to
   * https://w3c.github.io/webvtt/#default-text-color
   */
  /**
   * Default text color according to
   * https://w3c.github.io/webvtt/#default-text-color
   */
  enum defaultTextColor {
    black = '#000' ,
    blue = '#00F' ,
    cyan = '#0FF' ,
    lime = '#0F0' ,
    magenta = '#F0F' ,
    red = '#F00' ,
    white = '#FFF' ,
    yellow = '#FF0' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  enum direction {
    HORIZONTAL_LEFT_TO_RIGHT = 'ltr' ,
    HORIZONTAL_RIGHT_TO_LEFT = 'rtl' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  /**
   * Vertical alignments of the cues within their extents.
   * 'BEFORE' means displaying at the top of the captions container box, 'CENTER'
   * means in the middle, 'AFTER' means at the bottom.
   */
  /**
   * Vertical alignments of the cues within their extents.
   * 'BEFORE' means displaying at the top of the captions container box, 'CENTER'
   * means in the middle, 'AFTER' means at the bottom.
   */
  enum displayAlign {
    AFTER = 'after' ,
    BEFORE = 'before' ,
    CENTER = 'center' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  enum fontStyle {
    ITALIC = 'italic' ,
    NORMAL = 'normal' ,
    OBLIQUE = 'oblique' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  /**
   * In CSS font weight can be a number, where 400 is normal and 700 is bold.
   * Use these values for the enum for consistency.
   */
  /**
   * In CSS font weight can be a number, where 400 is normal and 700 is bold.
   * Use these values for the enum for consistency.
   */
  enum fontWeight {
    BOLD = 700.0 ,
    NORMAL = 400.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  enum lineAlign {
    CENTER = 'center' ,
    END = 'end' ,
    START = 'start' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  enum lineInterpretation {
    LINE_NUMBER = 0.0 ,
    PERCENTAGE = 1.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  enum positionAlign {
    AUTO = 'auto' ,
    CENTER = 'center' ,
    LEFT = 'line-left' ,
    RIGHT = 'line-right' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  enum textAlign {
    CENTER = 'center' ,
    END = 'end' ,
    LEFT = 'left' ,
    RIGHT = 'right' ,
    START = 'start' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  enum textDecoration {
    LINE_THROUGH = 'lineThrough' ,
    OVERLINE = 'overline' ,
    UNDERLINE = 'underline' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.Cue {
  enum writingMode {
    HORIZONTAL_TOP_TO_BOTTOM = 'horizontal-tb' ,
    VERTICAL_LEFT_TO_RIGHT = 'vertical-lr' ,
    VERTICAL_RIGHT_TO_LEFT = 'vertical-rl' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  class CueRegion implements shaka.extern.CueRegion {
    private noStructuralTyping_shaka_text_CueRegion : any;
    height : any ;
    heightUnits : any ;
    id : any ;
    regionAnchorX : any ;
    regionAnchorY : any ;
    scroll : any ;
    viewportAnchorUnits : any ;
    viewportAnchorX : any ;
    viewportAnchorY : any ;
    width : any ;
    widthUnits : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.CueRegion {
  enum scrollMode {
    NONE = '' ,
    UP = 'up' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text.CueRegion {
  enum units {
    LINES = 2.0 ,
    PERCENTAGE = 1.0 ,
    PX = 0.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  /**
   * LRC file format: https://en.wikipedia.org/wiki/LRC_(file_format)
   */
  class LrcTextParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_LrcTextParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  class Mp4TtmlParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_Mp4TtmlParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  class Mp4VttParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_Mp4VttParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  class SbvTextParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_SbvTextParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  /**
   * A text displayer plugin using the browser's native VTTCue interface.
   */
  class SimpleTextDisplayer implements shaka.extern.TextDisplayer {
    private noStructuralTyping_shaka_text_SimpleTextDisplayer : any;
    /**
     * A text displayer plugin using the browser's native VTTCue interface.
     */
    constructor (video : HTMLMediaElement | null ) ;
    append (cues : any ) : any ;
    destroy ( ) : any ;
    isTextVisible ( ) : any ;
    remove (start : any , end : any ) : any ;
    setTextVisibility (on : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  class SrtTextParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_SrtTextParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
    /**
     * Convert a SRT format to WebVTT
     */
    static srt2webvtt (data : string ) : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  /**
   * Documentation: http://moodub.free.fr/video/ass-specs.doc
   * https://en.wikipedia.org/wiki/SubStation_Alpha
   */
  class SsaTextParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_SsaTextParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  class TextEngine implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_text_TextEngine : any;
    constructor (displayer : shaka.extern.TextDisplayer | null ) ;
    destroy ( ) : Promise < any > ;
    static findParser (mimeType : any ) : ( shaka.extern.TextParserPlugin ) | null ;
    static registerParser (mimeType : string , plugin : shaka.extern.TextParserPlugin ) : any ;
    static unregisterParser (mimeType : string ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  class TtmlTextParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_TtmlTextParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  /**
   * The text displayer plugin for the Shaka Player UI.  Can also be used directly
   * by providing an appropriate container element.
   */
  class UITextDisplayer implements shaka.extern.TextDisplayer {
    private noStructuralTyping_shaka_text_UITextDisplayer : any;
    /**
     * The text displayer plugin for the Shaka Player UI.  Can also be used directly
     * by providing an appropriate container element.
     */
    constructor (video : HTMLMediaElement | null , videoContainer : HTMLElement | null ) ;
    append (cues : any ) : any ;
    destroy ( ) : any ;
    isTextVisible ( ) : any ;
    remove (start : any , end : any ) : any ;
    setTextVisibility (on : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  class VttTextParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_VttTextParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.text {
  class WebVttGenerator {
    private noStructuralTyping_shaka_text_WebVttGenerator : any;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  /**
   * A utility to wrap abortable operations.  Note that these are not cancelable.
   * Cancelation implies undoing what has been done so far, whereas aborting only
   * means that further work is stopped.
   */
  class AbortableOperation < T > implements shaka.extern.IAbortableOperation < T > {
    private noStructuralTyping_shaka_util_AbortableOperation : any;
    /**
     * A utility to wrap abortable operations.  Note that these are not cancelable.
     * Cancelation implies undoing what has been done so far, whereas aborting only
     * means that further work is stopped.
     */
    constructor (promise : Promise < T > , onAbort : shaka.extern.CreateSegmentIndexFunction ) ;
    abort ( ) : any ;
    chain < U > (onSuccess : undefined | Function , onError ? : (a : any ) => any ) : shaka.util.AbortableOperation < U > ;
    finally (onFinal : any ) : any ;
    promise : Promise < T > ;
    static aborted ( ) : shaka.util.AbortableOperation < any > ;
    static all (operations : shaka.util.AbortableOperation < any > [] ) : shaka.util.AbortableOperation < any > ;
    static completed < U > (value : U ) : shaka.util.AbortableOperation < U > ;
    static failed (error : shaka.util.Error ) : shaka.util.AbortableOperation < any > ;
    static notAbortable < U > (promise : Promise < U > ) : shaka.util.AbortableOperation < U > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class BufferUtils {
    private noStructuralTyping_shaka_util_BufferUtils : any;
    /**
     * Compare two buffers for equality.  For buffers of different types, this
     * compares the underlying buffers as binary data.
     */
    static equal (arr1 : ArrayBuffer | ArrayBufferView | null , arr2 : ArrayBuffer | ArrayBufferView | null ) : boolean ;
    /**
     * Gets an ArrayBuffer that contains the data from the given TypedArray.  Note
     * this will allocate a new ArrayBuffer if the object is a partial view of
     * the data.
     */
    static toArrayBuffer (view : ArrayBuffer | ArrayBufferView ) : ArrayBuffer ;
    /**
     * Creates a DataView over the given buffer.
     */
    static toDataView (buffer : ArrayBuffer | ArrayBufferView , offset ? : number , length ? : number ) : DataView ;
    /**
     * Creates a new Uint8Array view on the same buffer.  This clamps the values
     * to be within the same view (i.e. you can't use this to move past the end
     * of the view, even if the underlying buffer is larger).  However, you can
     * pass a negative offset to access the data before the view.
     * @param offset The offset from the beginning of this data's view to start the new view at.
     * @param length The byte length of the new view.
     */
    static toUint8 (data : ArrayBuffer | ArrayBufferView , offset ? : number , length ? : number ) : Uint8Array ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util.CmcdManager {
  type ManifestInfo = { format : shaka.util.CmcdManager.StreamingFormat } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util.CmcdManager {
  type SegmentInfo = { bandwidth ? : number , codecs : string , duration : number , init : boolean , mimeType : string , type : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util.CmcdManager {
  enum StreamingFormat {
    DASH = 'd' ,
    HLS = 'h' ,
    OTHER = 'o' ,
    SMOOTH = 's' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class ConfigUtils {
    private noStructuralTyping_shaka_util_ConfigUtils : any;
    /**
     * Convert config from ('fieldName', value) format to a partial config object.
     * E. g. from ('manifest.retryParameters.maxAttempts', 1) to
     * { manifest: { retryParameters: { maxAttempts: 1 }}}.
     */
    static convertToConfigObject (fieldName : string , value : any ) : object ;
    static mergeConfigObjects (destination : object , source : object , template : object , overrides : object , path : string ) : boolean ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class DataViewReader {
    private noStructuralTyping_shaka_util_DataViewReader : any;
    constructor (data : ArrayBuffer | ArrayBufferView , endianness : shaka.util.DataViewReader.Endianness ) ;
    /**
     * Gets the byte length of the DataView.
     */
    getLength ( ) : number ;
    /**
     * Gets the current byte position.
     */
    getPosition ( ) : number ;
    hasMoreData ( ) : boolean ;
    /**
     * Reads the specified number of raw bytes.
     * @param bytes The number of bytes to read.
     */
    readBytes (bytes : number ) : Uint8Array ;
    /**
     * Reads a signed 32 bit integer, and advances the reader.
     */
    readInt32 ( ) : number ;
    /**
     * Keeps reading until it reaches a byte that equals to zero.  The text is
     * assumed to be UTF-8.
     */
    readTerminatedString ( ) : string ;
    /**
     * Reads an unsigned 16 bit integer, and advances the reader.
     */
    readUint16 ( ) : number ;
    /**
     * Reads an unsigned 32 bit integer, and advances the reader.
     */
    readUint32 ( ) : number ;
    /**
     * Reads an unsigned 64 bit integer, and advances the reader.
     */
    readUint64 ( ) : number ;
    /**
     * Reads an unsigned 8 bit integer, and advances the reader.
     */
    readUint8 ( ) : number ;
    /**
     * Rewinds the specified number of bytes.
     * @param bytes The number of bytes to rewind.
     */
    rewind (bytes : number ) : any ;
    /**
     * Seeks to a specified position.
     * @param position The desired byte position within the DataView.
     */
    seek (position : number ) : any ;
    /**
     * Skips the specified number of bytes.
     * @param bytes The number of bytes to skip.
     */
    skip (bytes : number ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util.DataViewReader {
  /**
   * Endianness.
   */
  /**
   * Endianness.
   */
  enum Endianness {
    BIG_ENDIAN = 0.0 ,
    LITTLE_ENDIAN = 1.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class Dom {
    private noStructuralTyping_shaka_util_Dom : any;
    /**
     * Remove all of the child nodes of an element.
     */
    static removeAllChildren (element : Element ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class Error extends GlobalError implements shaka.extern.Error {
    private noStructuralTyping_shaka_util_Error : any;
    constructor (severity : shaka.util.Error.Severity , category : shaka.util.Error.Category , code : shaka.util.Error.Code ,  ...varArgs : any [] ) ;
    category : any ;
    code : any ;
    data : any ;
    handled : any ;
    severity : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util.Error {
  enum Category {
    ADS = 10.0 ,
    CAST = 8.0 ,
    DRM = 6.0 ,
    MANIFEST = 4.0 ,
    MEDIA = 3.0 ,
    NETWORK = 1.0 ,
    PLAYER = 7.0 ,
    STORAGE = 9.0 ,
    STREAMING = 5.0 ,
    TEXT = 2.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util.Error {
  enum Code {
    ALREADY_CASTING = 8002.0 ,
    ATTEMPTS_EXHAUSTED = 1010.0 ,
    BAD_ENCODING = 2004.0 ,
    BAD_HTTP_STATUS = 1001.0 ,
    BUFFER_READ_OUT_OF_BOUNDS = 3000.0 ,
    CANNOT_ADD_EXTERNAL_TEXT_TO_LIVE_STREAM = 4033.0 ,
    CANNOT_ADD_EXTERNAL_TEXT_TO_SRC_EQUALS = 2012.0 ,
    CANNOT_STORE_LIVE_OFFLINE = 9005.0 ,
    CAST_API_UNAVAILABLE = 8000.0 ,
    CAST_CANCELED_BY_USER = 8004.0 ,
    CAST_CONNECTION_TIMED_OUT = 8005.0 ,
    CAST_RECEIVER_APP_UNAVAILABLE = 8006.0 ,
    CHAPTERS_TRACK_FAILED = 2015.0 ,
    CONTENT_NOT_LOADED = 7004.0 ,
    CONTENT_TRANSFORMATION_FAILED = 3019.0 ,
    CONTENT_UNSUPPORTED_BY_BROWSER = 4032.0 ,
    CS_AD_MANAGER_NOT_INITIALIZED = 10001.0 ,
    CS_IMA_SDK_MISSING = 10000.0 ,
    CURRENT_DAI_REQUEST_NOT_FINISHED = 10004.0 ,
    DASH_CONFLICTING_KEY_IDS = 4010.0 ,
    DASH_DUPLICATE_REPRESENTATION_ID = 4018.0 ,
    DASH_EMPTY_ADAPTATION_SET = 4003.0 ,
    DASH_EMPTY_PERIOD = 4004.0 ,
    DASH_INVALID_XML = 4001.0 ,
    DASH_MULTIPLE_KEY_IDS_NOT_SUPPORTED = 4009.0 ,
    DASH_NO_COMMON_KEY_SYSTEM = 4008.0 ,
    DASH_NO_SEGMENT_INFO = 4002.0 ,
    DASH_PSSH_BAD_ENCODING = 4007.0 ,
    DASH_UNSUPPORTED_CONTAINER = 4006.0 ,
    DASH_UNSUPPORTED_XLINK_ACTUATE = 4027.0 ,
    DASH_WEBM_MISSING_INIT = 4005.0 ,
    DASH_XLINK_DEPTH_LIMIT = 4028.0 ,
    DEPRECATED_OPERATION_ABORTED = 9002.0 ,
    DOWNLOAD_SIZE_CALLBACK_ERROR = 9015.0 ,
    EBML_BAD_FLOATING_POINT_SIZE = 3003.0 ,
    EBML_OVERFLOW = 3002.0 ,
    ENCRYPTED_CONTENT_WITHOUT_DRM_INFO = 6010.0 ,
    EXPIRED = 6014.0 ,
    FAILED_TO_ATTACH_TO_VIDEO = 6003.0 ,
    FAILED_TO_CREATE_CDM = 6002.0 ,
    FAILED_TO_CREATE_SESSION = 6005.0 ,
    FAILED_TO_GENERATE_LICENSE_REQUEST = 6006.0 ,
    HLS_AES_128_INVALID_IV_LENGTH = 4043.0 ,
    HLS_AES_128_INVALID_KEY_LENGTH = 4044.0 ,
    HLS_COULD_NOT_GUESS_CODECS = 4025.0 ,
    HLS_INVALID_PLAYLIST_HIERARCHY = 4017.0 ,
    HLS_KEYFORMATS_NOT_SUPPORTED = 4026.0 ,
    HLS_MSE_ENCRYPTED_LEGACY_APPLE_MEDIA_KEYS_NOT_SUPPORTED = 4041.0 ,
    HLS_MSE_ENCRYPTED_MP2T_NOT_SUPPORTED = 4040.0 ,
    HLS_MULTIPLE_MEDIA_INIT_SECTIONS_FOUND = 4020.0 ,
    HLS_PLAYLIST_HEADER_MISSING = 4015.0 ,
    HLS_REQUIRED_ATTRIBUTE_MISSING = 4023.0 ,
    HLS_REQUIRED_TAG_MISSING = 4024.0 ,
    HLS_VARIABLE_NOT_FOUND = 4039.0 ,
    HTTP_ERROR = 1002.0 ,
    INCONSISTENT_DRM_ACROSS_PERIODS = 4038.0 ,
    INDEXED_DB_ERROR = 9001.0 ,
    INIT_DATA_TRANSFORM_ERROR = 6016.0 ,
    INVALID_HLS_TAG = 4016.0 ,
    INVALID_MP4_CEA = 2010.0 ,
    INVALID_MP4_TTML = 2007.0 ,
    INVALID_MP4_VTT = 2008.0 ,
    INVALID_SERVER_CERTIFICATE = 6004.0 ,
    INVALID_TEXT_CUE = 2001.0 ,
    INVALID_TEXT_HEADER = 2000.0 ,
    INVALID_XML = 2005.0 ,
    JS_INTEGER_OVERFLOW = 3001.0 ,
    KEY_NOT_FOUND = 9012.0 ,
    LICENSE_REQUEST_FAILED = 6007.0 ,
    LICENSE_RESPONSE_REJECTED = 6008.0 ,
    LOAD_INTERRUPTED = 7000.0 ,
    LOCAL_PLAYER_INSTANCE_REQUIRED = 9008.0 ,
    MALFORMED_DATA_URI = 1004.0 ,
    MALFORMED_OFFLINE_URI = 9004.0 ,
    MALFORMED_TEST_URI = 1008.0 ,
    MEDIA_SOURCE_OPERATION_FAILED = 3014.0 ,
    MEDIA_SOURCE_OPERATION_THREW = 3015.0 ,
    MISSING_STORAGE_CELL = 9013.0 ,
    MISSING_TEXT_PLUGIN = 2014.0 ,
    MODIFY_OPERATION_NOT_SUPPORTED = 9016.0 ,
    MP4_SIDX_INVALID_TIMESCALE = 3005.0 ,
    MP4_SIDX_TYPE_NOT_SUPPORTED = 3006.0 ,
    MP4_SIDX_WRONG_BOX_TYPE = 3004.0 ,
    NEW_KEY_OPERATION_NOT_SUPPORTED = 9011.0 ,
    NO_CAST_RECEIVERS = 8001.0 ,
    NO_INIT_DATA_FOR_OFFLINE = 9007.0 ,
    NO_LICENSE_SERVER_GIVEN = 6012.0 ,
    NO_RECOGNIZED_KEY_SYSTEMS = 6000.0 ,
    NO_VARIANTS = 4036.0 ,
    NO_VIDEO_ELEMENT = 7002.0 ,
    NO_WEB_CRYPTO_API = 4042.0 ,
    OBJECT_DESTROYED = 7003.0 ,
    OFFLINE_SESSION_REMOVED = 6013.0 ,
    OPERATION_ABORTED = 7001.0 ,
    PERIOD_FLATTENING_FAILED = 4037.0 ,
    QUOTA_EXCEEDED_ERROR = 3017.0 ,
    REQUESTED_ITEM_NOT_FOUND = 9003.0 ,
    REQUESTED_KEY_SYSTEM_CONFIG_UNAVAILABLE = 6001.0 ,
    REQUEST_FILTER_ERROR = 1006.0 ,
    RESPONSE_FILTER_ERROR = 1007.0 ,
    RESTRICTIONS_CANNOT_BE_MET = 4012.0 ,
    SEGMENT_MISSING = 1011.0 ,
    SERVER_CERTIFICATE_REQUEST_FAILED = 6017.0 ,
    SERVER_CERTIFICATE_REQUIRED = 6015.0 ,
    SS_AD_MANAGER_NOT_INITIALIZED = 10003.0 ,
    SS_IMA_SDK_MISSING = 10002.0 ,
    STORAGE_LIMIT_REACHED = 9014.0 ,
    STORAGE_NOT_SUPPORTED = 9000.0 ,
    STREAMING_ENGINE_STARTUP_INVALID_STATE = 5006.0 ,
    TEXT_COULD_NOT_GUESS_MIME_TYPE = 2011.0 ,
    TEXT_ONLY_WEBVTT_SRC_EQUALS = 2013.0 ,
    TIMEOUT = 1003.0 ,
    TRANSMUXING_FAILED = 3018.0 ,
    UNABLE_TO_DETECT_ENCODING = 2003.0 ,
    UNABLE_TO_EXTRACT_CUE_START_TIME = 2009.0 ,
    UNABLE_TO_GUESS_MANIFEST_TYPE = 4000.0 ,
    UNEXPECTED_CAST_ERROR = 8003.0 ,
    UNEXPECTED_TEST_REQUEST = 1009.0 ,
    UNSUPPORTED_SCHEME = 1000.0 ,
    VIDEO_ERROR = 3016.0 ,
    WEBM_CUES_ELEMENT_MISSING = 3007.0 ,
    WEBM_CUE_TIME_ELEMENT_MISSING = 3013.0 ,
    WEBM_CUE_TRACK_POSITIONS_ELEMENT_MISSING = 3012.0 ,
    WEBM_DURATION_ELEMENT_MISSING = 3011.0 ,
    WEBM_EBML_HEADER_ELEMENT_MISSING = 3008.0 ,
    WEBM_INFO_ELEMENT_MISSING = 3010.0 ,
    WEBM_SEGMENT_ELEMENT_MISSING = 3009.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util.Error {
  enum Severity {
    CRITICAL = 2.0 ,
    RECOVERABLE = 1.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class EventManager implements shaka.util.IReleasable {
    private noStructuralTyping_shaka_util_EventManager : any;
    /**
     * Attaches an event listener to an event target.
     * @param target The event target.
     * @param type The event type.
     * @param listener The event listener.
     * @param options An object that specifies characteristics about the event listener. The passive option, if true, indicates that this function will never call preventDefault(), which improves scrolling performance.
     */
    listen (target : EventTarget | null , type : string , listener : shaka.util.EventManager.ListenerType , options ? : boolean | AddEventListenerOptions ) : any ;
    /**
     * Attaches an event listener to an event target.  The listener will be
     * removed when the first instance of the event is fired.
     * @param target The event target.
     * @param type The event type.
     * @param listener The event listener.
     * @param options An object that specifies characteristics about the event listener. The passive option, if true, indicates that this function will never call preventDefault(), which improves scrolling performance.
     */
    listenOnce (target : EventTarget | null , type : string , listener : shaka.util.EventManager.ListenerType , options ? : boolean | AddEventListenerOptions ) : any ;
    /**
     * Detaches all event listeners.
     */
    release ( ) : any ;
    /**
     * Detaches all event listeners from all targets.
     */
    removeAll ( ) : any ;
    /**
     * Detaches an event listener from an event target.
     * @param target The event target.
     * @param type The event type.
     * @param listener The event listener.
     */
    unlisten (target : EventTarget | null , type : string , listener ? : shaka.util.EventManager.ListenerType ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util.EventManager {
  type ListenerType = (a : Event ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class FairPlayUtils {
    private noStructuralTyping_shaka_util_FairPlayUtils : any;
    /**
     * Common FairPlay response transform for some DRMs providers.
     */
    static commonFairPlayResponse (type : shaka.net.NetworkingEngine.RequestType , response : shaka.extern.Response ) : any ;
    /**
     * Conax FairPlay request.
     */
    static conaxFairPlayRequest (type : shaka.net.NetworkingEngine.RequestType , request : shaka.extern.Request ) : any ;
    /**
     * Conax initDataTransform configuration.
     */
    static conaxInitDataTransform (initData : Uint8Array , initDataType : string , drmInfo : shaka.extern.DrmInfo | null ) : any ;
    /**
     * Using the default method, extract a content ID from the init data.  This is
     * based on the FairPlay example documentation.
     */
    static defaultGetContentId (initData : ArrayBuffer | ArrayBufferView ) : string ;
    /**
     * EZDRM FairPlay request.
     */
    static ezdrmFairPlayRequest (type : shaka.net.NetworkingEngine.RequestType , request : shaka.extern.Request ) : any ;
    /**
     * EZDRM initDataTransform configuration.
     */
    static ezdrmInitDataTransform (initData : Uint8Array , initDataType : string , drmInfo : shaka.extern.DrmInfo | null ) : any ;
    /**
     * Transforms the init data buffer using the given data.  The format is:
     * <pre>
     * [4 bytes] initDataSize
     * [initDataSize bytes] initData
     * [4 bytes] contentIdSize
     * [contentIdSize bytes] contentId
     * [4 bytes] certSize
     * [certSize bytes] cert
     * </pre>
     * @param cert The server certificate; this will throw if not provided.
     */
    static initDataTransform (initData : ArrayBuffer | ArrayBufferView , contentId : ArrayBuffer | ArrayBufferView | string , cert : ArrayBuffer | ArrayBufferView | null ) : Uint8Array ;
    /**
     * Check if FairPlay is supported.
     */
    static isFairPlaySupported ( ) : Promise < boolean > ;
    /**
     * Verimatrix FairPlay request.
     */
    static verimatrixFairPlayRequest (type : shaka.net.NetworkingEngine.RequestType , request : shaka.extern.Request ) : any ;
    /**
     * Verimatrix initDataTransform configuration.
     */
    static verimatrixInitDataTransform (initData : Uint8Array , initDataType : string , drmInfo : shaka.extern.DrmInfo | null ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class FakeEvent extends Event {
    private noStructuralTyping_shaka_util_FakeEvent : any;
    constructor (type : string , dict ? : Map < string , object | null > | null ) ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class FakeEventTarget implements EventTarget , shaka.util.IReleasable {
    private noStructuralTyping_shaka_util_FakeEventTarget : any;
    /**
     * Add an event listener to this object.
     * @param type The event type to listen for.
     * @param listener The callback or listener object to invoke.
     * @param options Ignored.
     */
    addEventListener (type : string , listener : EventListener | null | ( (a : Event ) => any ) , options ? : AddEventListenerOptions | boolean ) : any ;
    /**
     * Dispatch an event from this object.
     * @param event The event to be dispatched from this object.
     */
    dispatchEvent (event : Event ) : boolean ;
    /**
     * Add an event listener to this object that is invoked for all events types
     * the object fires.
     * @param listener The callback or listener object to invoke.
     */
    listenToAllEvents (listener : EventListener | null | ( (a : Event ) => any ) ) : any ;
    release ( ) : any ;
    /**
     * Remove an event listener from this object.
     * @param type The event type for which you wish to remove a listener.
     * @param listener The callback or listener object to remove.
     * @param options Ignored.
     */
    removeEventListener (type : string , listener : EventListener | null | ( (a : Event ) => any ) , options ? : EventListenerOptions | null | boolean ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util.FakeEventTarget {
  /**
   * These are the listener types defined in the closure extern for EventTarget.
   */
  type ListenerType = EventListener | null | ( (a : Event ) => any ) ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  /**
   * An interface to standardize how objects are destroyed.
   */
  interface IDestroyable {
    /**
     * Request that this object be destroyed, releasing all resources and shutting
     * down all operations. Returns a Promise which is resolved when destruction
     * is complete. This Promise should never be rejected.
     */
    destroy ( ) : Promise < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  /**
   * An interface to standardize how objects release internal references
   * synchronously. If an object needs to asynchronously release references, then
   * it should use 'shaka.util.IDestroyable'.
   */
  interface IReleasable {
    /**
     * Request that this object release all internal references.
     */
    release ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class LanguageUtils {
    private noStructuralTyping_shaka_util_LanguageUtils : any;
    /**
     * Check if |locale1| and |locale2| are language-compatible.
     * Language compatible is when the language component of each locale matches.
     * This means that no matter what region they have (or don't have) as long as
     * the language components match, they are language-compatible.
     * Examples:
     * Locale A | Locale B | Language-Compatible
     * -----------------------------------------
     * en-US    | en-US    | true
     * en-US    | en       | true
     * en-US    | en-CA    | true
     * en-CA    | fr-CA    | false
     */
    static areLanguageCompatible (locale1 : string , locale2 : string ) : boolean ;
    /**
     * Check if |locale1| and |locale2| are locale-compatible.
     * Locale-compatible is defined as all components in each locale match. Since
     * we only respect the language and region components, we only check that
     * the language and region components match.
     * Examples:
     * Locale A | Locale B | Locale Compatible
     * ---------------------------------------
     * en-US    | en-US    | true
     * en       | en-US    | false
     * en-US    | en-CA    | false
     */
    static areLocaleCompatible (locale1 : string , locale2 : string ) : boolean ;
    /**
     * Check if two language codes are siblings. Language codes are siblings if
     * they share the same base language while neither one is the base language.
     * For example, "en-US" and "en-CA" are siblings but "en-US" and "en" are not
     * siblings.
     */
    static areSiblings (a : string , b : string ) : boolean ;
    /**
     * Find the locale in |searchSpace| that comes closest to |target|. If no
     * locale is found to be close to |target|, then |null| will be returned.
     */
    static findClosestLocale (target : string , searchSpace : Iterable < string > ) : string | null ;
    /**
     * Get the normalized base language for a language code.
     */
    static getBase (lang : string ) : string ;
    /**
     * Get the normalized language of the given text stream. Will return 'und' if
     * a language is not found on the text stream.
     * This should always be used to get the language from a text stream.
     */
    static getLocaleForText (stream : shaka.extern.Stream ) : string ;
    /**
     * Get the normalized locale for the given variant. This will look through
     * the variant to find the locale that represents the content in the variant.
     * This will return 'und' if no language can be found.
     * This should always be used to get the locale from a variant.
     */
    static getLocaleForVariant (variant : shaka.extern.Variant ) : string ;
    /**
     * Check if |possibleParent| is the parent locale of |possibleChild|. Because
     * we do not support dialects, the parent-child relationship is a lot simpler.
     * In a parent child relationship:
     * - The parent and child have the same language-component
     * - The parent has no region-component
     * - The child has a region-component
     * Example:
     * Locale A | Locale B | Is A The parent of B?
     * --------------------------------------------
     * en-US    | en-US    | no
     * en-US    | en       | no
     * en       | en-US    | yes
     * en       | en       | no
     * en       | fr       | no
     */
    static isParentOf (possibleParent : string , possibleChild : string ) : boolean ;
    /**
     * Check if |localeA| shares the same parent with |localeB|. Since we don't
     * support dialect, we will only look at language and region. For two locales
     * to be siblings:
     * - Both must have language-components
     * - Both must have region-components
     * - Both must have the same language-component
     * Example:
     * Locale A | Locale B | Siblings?
     * --------------------------------------------
     * en-US    | en-US    | yes
     * en-US    | en-CA    | yes
     * en-US    | en       | no
     * en       | en-US    | no
     * en       | en       | no
     * en       | fr       | no
     */
    static isSiblingOf (localeA : string , localeB : string ) : boolean ;
    /**
     * Normalize a locale. This will take a locale and canonicalize it to a state
     * that we are prepared to work with.
     * We only support with:
     * - language
     * - language-REGION
     * If given a dialect, we will discard it. We will convert any 3-character
     * codes to 2-character codes. We will force language codes to lowercase and
     * region codes to uppercase.
     */
    static normalize (locale : string ) : string ;
    /**
     * Compute a numerical relatedness for language codes.  Language codes with a
     * higher relatedness are a better match.  Unrelated language codes have a
     * relatedness score of 0.
     */
    static relatedness (target : string , candidate : string ) : number ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class MimeUtils {
    private noStructuralTyping_shaka_util_MimeUtils : any;
    /**
     * Takes a MIME type and optional codecs string and produces the full MIME
     * type.
     */
    static getFullType (mimeType : string , codecs ? : string ) : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class Mp4Parser {
    private noStructuralTyping_shaka_util_Mp4Parser : any;
    /**
     * Declare a box type as a Box.
     */
    box (type : string , definition : shaka.util.Mp4Parser.CallbackType ) : shaka.util.Mp4Parser ;
    /**
     * Declare a box type as a Full Box.
     */
    fullBox (type : string , definition : shaka.util.Mp4Parser.CallbackType ) : shaka.util.Mp4Parser ;
    /**
     * Parse the given data using the added callbacks.
     * @param partialOkay If true, allow reading partial payloads from some boxes. If the goal is a child box, we can sometimes find it without enough data to find all child boxes.
     * @param stopOnPartial If true, stop reading if an incomplete box is detected.
     */
    parse (data : ArrayBuffer | ArrayBufferView , partialOkay ? : boolean , stopOnPartial ? : boolean ) : any ;
    /**
     * Parse the next box on the current level.
     * @param absStart The absolute start position in the original byte array.
     * @param partialOkay If true, allow reading partial payloads from some boxes. If the goal is a child box, we can sometimes find it without enough data to find all child boxes.
     * @param stopOnPartial If true, stop reading if an incomplete box is detected.
     */
    parseNext (absStart : number , reader : shaka.util.DataViewReader , partialOkay ? : boolean , stopOnPartial ? : boolean ) : any ;
    /**
     * Stop parsing.  Useful for extracting information from partial segments and
     * avoiding an out-of-bounds error once you find what you are looking for.
     */
    stop ( ) : any ;
    /**
     * Create a callback that tells the Mp4 parser to treat the body of a box as a
     * binary blob and to parse the body's contents using the provided callback.
     */
    static allData (callback : (a : Uint8Array ) => any ) : shaka.util.Mp4Parser.CallbackType ;
    /**
     * A callback that tells the Mp4 parser to treat the body of a box as a series
     * of boxes. The number of boxes is limited by the size of the parent box.
     */
    static children (box : shaka.extern.ParsedBox ) : any ;
    /**
     * Find the header size of the box.
     * Useful for modifying boxes in place or finding the exact offset of a field.
     */
    static headerSize (box : shaka.extern.ParsedBox ) : number ;
    /**
     * A callback that tells the Mp4 parser to treat the body of a box as a sample
     * description. A sample description box has a fixed number of children. The
     * number of children is represented by a 4 byte unsigned integer. Each child
     * is a box.
     */
    static sampleDescription (box : shaka.extern.ParsedBox ) : any ;
    /**
     * Convert an integer type from a box into an ascii string name.
     * Useful for debugging.
     * @param type The type of the box, a uint32.
     */
    static typeToString (type : number ) : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util.Mp4Parser {
  type CallbackType = (a : shaka.extern.ParsedBox ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class PlayerConfiguration {
    private noStructuralTyping_shaka_util_PlayerConfiguration : any;
    static createDefault ( ) : shaka.extern.PlayerConfiguration ;
    /**
     * Merges the given configuration changes into the given destination.  This
     * uses the default Player configurations as the template.
     */
    static mergeConfigObjects (destination : shaka.extern.PlayerConfiguration , updates : object , template ? : shaka.extern.PlayerConfiguration ) : boolean ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class StringUtils {
    private noStructuralTyping_shaka_util_StringUtils : any;
    /**
     * Creates a string from the given buffer, auto-detecting the encoding that is
     * being used.  If it cannot detect the encoding, it will throw an exception.
     */
    static fromBytesAutoDetect (data : ArrayBuffer | ArrayBufferView | null ) : string ;
    /**
     * Creates a string from the given buffer as UTF-16 encoding.
     * @param littleEndian true to read little endian, false to read big.
     * @param noThrow true to avoid throwing in cases where we may expect invalid input.  If noThrow is true and the data has an odd length,it will be truncated.
     */
    static fromUTF16 (data : ArrayBuffer | ArrayBufferView | null , littleEndian : boolean , noThrow ? : boolean ) : string ;
    /**
     * Creates a string from the given buffer as UTF-8 encoding.
     */
    static fromUTF8 (data : ArrayBuffer | ArrayBufferView | null ) : string ;
    /**
     * Resets the fromCharCode method's implementation.
     * For debug use.
     */
    static resetFromCharCode ( ) : any ;
    /**
     * Creates a ArrayBuffer from the given string, converting to UTF-16 encoding.
     */
    static toUTF16 (str : string , littleEndian : boolean ) : ArrayBuffer ;
    /**
     * Creates a ArrayBuffer from the given string, converting to UTF-8 encoding.
     */
    static toUTF8 (str : string ) : ArrayBuffer ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  /**
   * A timer allows a single function to be executed at a later time or at
   * regular intervals.
   */
  class Timer {
    private noStructuralTyping_shaka_util_Timer : any;
    constructor (onTick : ( ) => any ) ;
    /**
     * Stop the timer and clear the previous behaviour. The timer is still usable
     * after calling |stop|.
     */
    stop ( ) : any ;
    /**
     * Have the timer call |onTick| after |seconds| has elapsed unless |stop| is
     * called first.
     */
    tickAfter (seconds : number ) : shaka.util.Timer ;
    /**
     * Have the timer call |onTick| every |seconds| until |stop| is called.
     */
    tickEvery (seconds : number ) : shaka.util.Timer ;
    /**
     * Have the timer call |onTick| now.
     */
    tickNow ( ) : shaka.util.Timer ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.compiled.debug.externs.js
declare namespace shaka.util {
  class Uint8ArrayUtils {
    private noStructuralTyping_shaka_util_Uint8ArrayUtils : any;
    /**
     * Concatenate buffers.
     */
    static concat ( ...varArgs : ( ArrayBuffer | ArrayBufferView ) [] ) : Uint8Array ;
    /**
     * Convert a base64 string to a Uint8Array.  Accepts either the standard
     * alphabet or the alternate "base64url" alphabet.
     */
    static fromBase64 (str : string ) : Uint8Array ;
    /**
     * Convert a hex string to a Uint8Array.
     */
    static fromHex (str : string ) : Uint8Array ;
    /**
     * Convert a buffer to a base64 string.  The output will always use the
     * alternate encoding/alphabet also known as "base64url".
     * @param padding If true, pad the output with equals signs. Defaults to true.
     */
    static toBase64 (data : ArrayBuffer | ArrayBufferView , padding ? : boolean ) : string ;
    /**
     * Convert a buffer to a hex string.
     */
    static toHex (data : ArrayBuffer | ArrayBufferView ) : string ;
    /**
     * Convert a buffer to a base64 string. The output will be standard
     * alphabet as opposed to base64url safe alphabet.
     */
    static toStandardBase64 (data : ArrayBuffer | ArrayBufferView ) : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/airplay.js
declare namespace ಠ_ಠ.clutz {
  class AirPlayEvent extends Event {
    private noStructuralTyping_AirPlayEvent : any;
    constructor ( ...a : any [] ) ;
    availability : String | null ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/awesomplete.js
declare namespace ಠ_ಠ.clutz {
  class Awesomplete {
    private noStructuralTyping_Awesomplete : any;
    constructor (input : Element ) ;
    list : string [] ;
    minChars : number ;
    evaluate ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace ಠ_ಠ.clutz {
  function __onGCastApiAvailable (a : boolean ) : any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace cast.receiver {
  class CastChannel {
    private noStructuralTyping_cast_receiver_CastChannel : any;
    send (message : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace cast.receiver {
  class CastMessageBus {
    private noStructuralTyping_cast_receiver_CastMessageBus : any;
    broadcast (message : any ) : any ;
    getCastChannel (senderId : string ) : cast.receiver.CastChannel ;
    onMessage : Function | null ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace cast.receiver.CastMessageBus {
  class Event {
    private noStructuralTyping_cast_receiver_CastMessageBus_Event : any;
    data : any ;
    senderId : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace cast.receiver {
  class CastReceiverManager {
    private noStructuralTyping_cast_receiver_CastReceiverManager : any;
    onSenderConnected : Function | null ;
    onSenderDisconnected : Function | null ;
    onSystemVolumeChanged : Function | null ;
    getCastMessageBus (namespace : string , messageType ? : string ) : cast.receiver.CastMessageBus | null ;
    getSenders ( ) : string [] | null ;
    getSystemVolume ( ) : cast.receiver.system.SystemVolumeData | null ;
    isSystemReady ( ) : boolean ;
    setSystemVolumeLevel (level : number ) : any ;
    setSystemVolumeMuted (muted : number ) : any ;
    start ( ) : any ;
    stop ( ) : any ;
    static getInstance ( ) : cast.receiver.CastReceiverManager | null ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace cast.receiver.media {
  enum MetadataType {
    GENERIC = 0.0 ,
    MOVIE = 1.0 ,
    MUSIC_TRACK = 3.0 ,
    PHOTO = 4.0 ,
    TV_SHOW = 2.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace cast.receiver.system {
  class SystemVolumeData {
    private noStructuralTyping_cast_receiver_system_SystemVolumeData : any;
    level : number ;
    muted : boolean ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace chrome.cast {
  class ApiConfig {
    private noStructuralTyping_chrome_cast_ApiConfig : any;
    constructor (sessionRequest : chrome.cast.SessionRequest | null , sessionListener : Function | null , receiverListener : Function | null , autoJoinPolicy ? : string , defaultActionPolicy ? : string ) ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace chrome.cast {
  class Error {
    private noStructuralTyping_chrome_cast_Error : any;
    constructor (code : string , description ? : string , details ? : object | null ) ;
    code : string ;
    description : string | null ;
    details : object | null ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace chrome.cast {
  class Receiver {
    private noStructuralTyping_chrome_cast_Receiver : any;
    friendlyName : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace chrome.cast {
  class Session {
    private noStructuralTyping_chrome_cast_Session : any;
    receiver : chrome.cast.Receiver | null ;
    sessionId : string ;
    status : string ;
    addMessageListener (namespace : string , listener : Function | null ) : any ;
    addUpdateListener (listener : Function | null ) : any ;
    leave (successCallback : Function | null , errorCallback : Function | null ) : any ;
    removeMessageListener (namespace : string , listener : Function | null ) : any ;
    removeUpdateListener (listener : Function | null ) : any ;
    sendMessage (namespace : string , message : object | string , successCallback : Function | null , errorCallback : Function | null ) : any ;
    stop (successCallback : Function | null , errorCallback : Function | null ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace chrome.cast {
  class SessionRequest {
    private noStructuralTyping_chrome_cast_SessionRequest : any;
    constructor (appId : string , capabilities : ( object | null ) [] | null , timeout : number | null , androidReceiverCompatible : boolean , credentialsData : object | null ) ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace chrome.cast.SessionStatus {
  let STOPPED : string ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/chromecast.js
declare namespace chrome.cast {
  let isAvailable : boolean ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/cmcd.js
declare namespace ಠ_ಠ.clutz {
  type CmcdData = { bl ? : number , br ? : number , bs ? : boolean , cid ? : string , d ? : number , dl ? : number , mtp ? : number , nor ? : string , nrr ? : string , ot ? : string , pr ? : number , rtp ? : number , sf ? : string , sid ? : string , st ? : string , su ? : boolean , tb ? : number , v ? : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/ima.js
declare namespace google.ima.AdErrorEvent {
  enum Type {
    AD_ERROR = 'AD_ERROR' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/ima.js
declare namespace google.ima.AdEvent {
  enum Type {
    AD_BREAK_READY = 'AD_BREAK_READY' ,
    AD_BUFFERING = 'AD_BUFFERING' ,
    AD_ERROR = 'AD_ERROR' ,
    AD_METADATA = 'AD_METADATA' ,
    AD_PROGRESS = 'AD_PROGRESS' ,
    ALL_ADS_COMPLETED = 'ALL_ADS_COMPLETED' ,
    CLICK = 'CLICK' ,
    COMPLETE = 'COMPLETE' ,
    CONTENT_PAUSE_REQUESTED = 'CONTENT_PAUSE_REQUESTED' ,
    CONTENT_RESUME_REQUESTED = 'CONTENT_RESUME_REQUESTED' ,
    DURATION_CHANGE = 'DURATION_CHANGE' ,
    FIRST_QUARTILE = 'FIRST_QUARTILE' ,
    IMPRESSION = 'IMPRESSION' ,
    INTERACTION = 'INTERACTION' ,
    LINEAR_CHANGED = 'LINEAR_CHANGED' ,
    LOADED = 'LOADED' ,
    LOG = 'LOG' ,
    MIDPOINT = 'MIDPOINT' ,
    PAUSED = 'PAUSED' ,
    RESUMED = 'RESUMED' ,
    SKIPPABLE_STATE_CHANGED = 'SKIPPABLE_STATE_CHANGED' ,
    SKIPPED = 'SKIPPED' ,
    STARTED = 'STARTED' ,
    THIRD_QUARTILE = 'THIRD_QUARTILE' ,
    USER_CLOSE = 'USER_CLOSE' ,
    VOLUME_CHANGED = 'VOLUME_CHANGED' ,
    VOLUME_MUTED = 'VOLUME_MUTED' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/ima.js
declare namespace google.ima {
  class AdsLoader implements EventTarget {
    private noStructuralTyping_google_ima_AdsLoader : any;
    constructor (container : google.ima.AdDisplayContainer ) ;
    addEventListener ( ) : any ;
    contentComplete ( ) : any ;
    destroy ( ) : any ;
    dispatchEvent ( ) : any ;
    getSettings ( ) : google.ima.ImaSdkSettings | null ;
    removeEventListener ( ) : any ;
    requestAds (request : google.ima.AdsRequest ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/ima.js
declare namespace google.ima {
  class AdsManager implements EventTarget {
    private noStructuralTyping_google_ima_AdsManager : any;
    addEventListener ( ) : any ;
    destroy ( ) : any ;
    dispatchEvent ( ) : any ;
    getAdSkippableState ( ) : boolean ;
    getCuePoints ( ) : number [] ;
    getRemainingTime ( ) : number ;
    getVolume ( ) : any ;
    init (width : number , height : number , viewMode : google.ima.ViewMode ) : any ;
    pause ( ) : any ;
    removeEventListener ( ) : any ;
    resize (width : number , height : number , viewMode : google.ima.ViewMode ) : any ;
    resume ( ) : any ;
    setVolume (volume : number ) : any ;
    skip ( ) : any ;
    start ( ) : any ;
    stop ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/ima.js
declare namespace google.ima.AdsManagerLoadedEvent {
  enum Type {
    ADS_MANAGER_LOADED = 'ADS_MANAGER_LOADED' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/ima.js
declare namespace google.ima {
  type AdsRequest = { adTagUrl ? : string , adsResponse ? : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/ima.js
declare namespace google.ima.ImaSdkSettings {
  enum VpaidMode {
    DISABLED = 0.0 ,
    ENABLED = 1.0 ,
    INSECURE = 2.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/ima.js
declare namespace google.ima {
  enum ViewMode {
    FULLSCREEN = 'FULLSCREEN' ,
    NORMAL = 'NORMAL' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/ima.js
declare namespace google.ima.dai.api.StreamEvent {
  enum Type {
    AD_BREAK_ENDED = 'adBreakEnded' ,
    AD_BREAK_STARTED = 'adBreakStarted' ,
    AD_PERIOD_ENDED = 'adPeriodEnded' ,
    AD_PERIOD_STARTED = 'adPeriodStarted' ,
    AD_PROGRESS = 'adProgress' ,
    CLICK = 'click' ,
    COMPLETE = 'complete' ,
    CUEPOINTS_CHANGED = 'cuepointsChanged' ,
    ERROR = 'error' ,
    FIRST_QUARTILE = 'firstquartile' ,
    LOADED = 'loaded' ,
    MIDPOINT = 'midpoint' ,
    SKIPPABLE_STATE_CHANGED = 'skippableStateChanged' ,
    SKIPPED = 'skip' ,
    STARTED = 'started' ,
    STREAM_INITIALIZED = 'streamInitialized' ,
    THIRD_QUARTILE = 'thirdquartile' ,
    VIDEO_CLICKED = 'videoClicked' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/ima.js
declare namespace google.ima.dai.api {
  class StreamManager implements EventTarget {
    private noStructuralTyping_google_ima_dai_api_StreamManager : any;
    constructor (videoElement : HTMLMediaElement | null , adUiElement ? : HTMLElement | null , uiSettings ? : google.ima.dai.api.UiSettings | null ) ;
    addEventListener (type : string | any [] | null , handler : null | object , capture ? : boolean | AddEventListenerOptions , handlerScope ? : object | null ) : any ;
    contentTimeForStreamTime (streamTime : number ) : any ;
    dispatchEvent ( ) : any ;
    onTimedMetadata (metadata : object | null ) : any ;
    previousCuePointForStreamTime (streamTime : number ) : any ;
    processMetadata (type : string , data : Uint8Array | null | string , timestamp : number ) : any ;
    removeEventListener ( ) : any ;
    replaceAdTagParameters (adTagParameters : object | null ) : any ;
    requestStream (streamRequest : google.ima.dai.api.StreamRequest | null ) : any ;
    reset ( ) : any ;
    setClickElement (clickElement : Element | null ) : any ;
    streamTimeForContentTime (contentTime : number ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/ima.js
declare namespace google.ima {
  let settings : google.ima.ImaSdkSettings ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/jwk_set.js
declare namespace ಠ_ಠ.clutz {
  /**
   * A JSON Web Key.
   */
  class JWK {
    private noStructuralTyping_JWK : any;
    /**
     * A key in base 64.  Used with kty="oct".
     */
    k : string ;
    /**
     * A key ID.  Any ASCII string.
     */
    kid : string ;
    /**
     * A key type.  One of:
     * 1. "oct" (symmetric key octect sequence)
     * 2. "RSA" (RSA key)
     * 3. "EC" (elliptical curve key)
     * Use "oct" for clearkey.
     */
    kty : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/jwk_set.js
declare namespace ಠ_ಠ.clutz {
  /**
   * A JSON Web Key set.
   */
  class JWKSet {
    private noStructuralTyping_JWKSet : any;
    keys : ( JWK | null ) [] | null ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/mdl.js
declare namespace ಠ_ಠ.clutz {
  class MaterialLayout {
    private noStructuralTyping_MaterialLayout : any;
    Constant_ : { MENU_ICON : string } ;
    toggleDrawer ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/mediasession.js
declare namespace ಠ_ಠ.clutz {
  class MediaMetadata {
    private noStructuralTyping_MediaMetadata : any;
    constructor (options : any ) ;
    artist : string ;
    artwork : object ;
    title : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/mediasession.js
declare namespace ಠ_ಠ.clutz {
  class MediaSession {
    private noStructuralTyping_MediaSession : any;
    metadata : MediaMetadata | null ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/mux.js
declare namespace muxjs.mp4 {
  class CaptionParser {
    private noStructuralTyping_muxjs_mp4_CaptionParser : any;
    /**
     * Clear the parsed closed captions data for new data.
     */
    clearParsedCaptions ( ) : any ;
    /**
     * Initializes the closed caption parser.
     */
    init ( ) : any ;
    /**
     * Return true if a new video track is selected or if the timescale is
     * changed.
     * @param videoTrackIds A list of video tracks found in the init segment.
     * @param timescales The map of track Ids and the tracks' timescales in the init segment.
     */
    isNewInit (videoTrackIds : number [] , timescales : { [ key: number ]: number } ) : boolean ;
    /**
     * Parses embedded CEA closed captions and interacts with the underlying
     * CaptionStream, and return the parsed captions.
     * @param segment The fmp4 segment containing embedded captions
     * @param videoTrackIds A list of video tracks found in the init segment.
     * @param timescales The timescales found in the init segment.
     */
    parse (segment : Uint8Array , videoTrackIds : number [] , timescales : { [ key: number ]: number } ) : muxjs.mp4.ParsedClosedCaptions ;
    /**
     * Reset the captions stream.
     */
    resetCaptionStream ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/mux.js
declare namespace muxjs.mp4 {
  type ClosedCaption = { endPts : number , endTime : number , startPts : number , startTime : number , stream : string , text : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/mux.js
declare namespace muxjs.mp4 {
  type Metadata = { cueTime : number , data : Uint8Array , dispatchType : string , dts : number , frames : muxjs.mp4.MetadataFrame [] , pts : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/mux.js
declare namespace muxjs.mp4 {
  type MetadataFrame = { data : string , description : string , id : string , key : string , value : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/mux.js
declare namespace muxjs.mp4 {
  type ParsedClosedCaptions = { captionStreams : { [ key: string ]: boolean } | null , captions : muxjs.mp4.ClosedCaption [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/mux.js
declare namespace muxjs.mp4 {
  class Transmuxer {
    private noStructuralTyping_muxjs_mp4_Transmuxer : any;
    constructor (options ? : object | null ) ;
    /**
     * Remove all handlers and clean up.
     */
    dispose ( ) : any ;
    flush ( ) : any ;
    /**
     * Remove a handler for a specified event type.
     * @param type Event name
     * @param listener The callback to be removed
     */
    off (type : string , listener : Function | null ) : any ;
    /**
     * Add a handler for a specified event type.
     * @param type Event name
     * @param listener The callback to be invoked
     */
    on (type : string , listener : Function | null ) : any ;
    push (data : Uint8Array ) : any ;
    setBaseMediaDecodeTime (time : number ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/mux.js
declare namespace muxjs.mp4.Transmuxer {
  type Segment = { captions : any [] , data : Uint8Array , initSegment : Uint8Array , metadata : any [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/polyfill.js
declare namespace window {
  let shakaMediaKeysPolyfill : boolean ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/prefixed_eme.js
declare namespace ಠ_ಠ.clutz {
  class MediaKeyError {
    private noStructuralTyping_MediaKeyError : any;
    code : number ;
    systemCode : number ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/prefixed_eme.js
declare namespace ಠ_ಠ.clutz {
  class MediaKeyEvent extends Event {
    private noStructuralTyping_MediaKeyEvent : any;
    constructor (type : string , eventInitDict ? : object | null ) ;
    defaultURL : string ;
    errorCode : MediaKeyError | null ;
    initData : Uint8Array ;
    keySystem : string ;
    message : Uint8Array ;
    sessionId : string ;
    systemCode : number ;
    target : HTMLMediaElement ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/abortable.js
declare namespace shaka.extern {
  /**
   * A representation of an abortable operation.  Note that these are not
   * cancelable.  Cancelation implies undoing what has been done so far,
   * whereas aborting only means that further work is stopped.
   */
  interface IAbortableOperation < T > {
    /**
     * Can be called by anyone holding this object to abort the underlying
     * operation.  This is not cancelation, and will not necessarily result in
     * any work being undone.  abort() should return a Promise which is resolved
     * when the underlying operation has been aborted.  The returned Promise
     * should never be rejected.
     */
    abort ( ) : Promise < any > ;
    finally (onFinal : (a : boolean ) => any ) : shaka.extern.IAbortableOperation < T > ;
    /**
     * A Promise which represents the underlying operation.  It is resolved when
     * the operation is complete, and rejected if the operation fails or is
     * aborted.  Aborted operations should be rejected with a shaka.util.Error
     * object using the error code OPERATION_ABORTED.
     */
    promise : Promise < T > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/abr_manager.js
declare namespace shaka.extern {
  /**
   * An object which selects Streams from a set of possible choices.  This also
   * watches for system changes to automatically adapt for the current streaming
   * requirements.  For example, when the network slows down, this class is in
   * charge of telling the Player which streams to switch to in order to reduce
   * the required bandwidth.
   *
   * This class is given a set of streams to choose from when the Player starts
   * up.  This class should store these and use them to make future decisions
   * about ABR.  It is up to this class how those decisions are made.  All the
   * Player will do is tell this class what streams to choose from.
   */
  interface AbrManager {
    /**
     * Chooses one variant to switch to.  Called by the Player.
     */
    chooseVariant ( ) : shaka.extern.Variant ;
    /**
     * Sets the ABR configuration.
     *
     * It is the responsibility of the AbrManager implementation to implement the
     * restrictions behavior described in shaka.extern.AbrConfiguration.
     */
    configure (config : shaka.extern.AbrConfiguration ) : any ;
    /**
     * Disables automatic Stream suggestions. After this, the AbrManager may not
     * call switchCallback().
     */
    disable ( ) : any ;
    /**
     * Enables automatic Variant choices from the last ones passed to setVariants.
     * After this, the AbrManager may call switchCallback() at any time.
     */
    enable ( ) : any ;
    /**
     * Gets an estimate of the current bandwidth in bit/sec.  This is used by the
     * Player to generate stats.
     */
    getBandwidthEstimate ( ) : number ;
    /**
     * Initializes the AbrManager.
     */
    init (switchCallback : shaka.extern.AbrManager.SwitchCallback ) : any ;
    /**
     * Updates manager playback rate.
     */
    playbackRateChanged (rate : number ) : any ;
    /**
     * Notifies the AbrManager that a segment has been downloaded (includes MP4
     * SIDX data, WebM Cues data, initialization segments, and media segments).
     * @param deltaTimeMs The duration, in milliseconds, that the request took to complete.
     * @param numBytes The total number of bytes transferred.
     */
    segmentDownloaded (deltaTimeMs : number , numBytes : number ) : any ;
    /**
     * Set media element.
     */
    setMediaElement (mediaElement : HTMLMediaElement | null ) : any ;
    /**
     * Updates manager's variants collection.
     */
    setVariants (variants : shaka.extern.Variant [] ) : any ;
    /**
     * Stops any background timers and frees any objects held by this instance.
     * This will only be called after a call to init.
     */
    stop ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/abr_manager.js
declare namespace shaka.extern.AbrManager {
  /**
   * A factory for creating the abr manager.
   */
  type Factory = ( ) => shaka.extern.AbrManager ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/abr_manager.js
declare namespace shaka.extern.AbrManager {
  /**
   * A callback into the Player that should be called when the AbrManager decides
   * it's time to change to a different variant.
   *
   * The first argument is a variant to switch to.
   *
   * The second argument is an optional boolean. If true, all data will be removed
   * from the buffer, which will result in a buffering event. Unless a third
   * argument is passed.
   *
   * The third argument in an optional number that specifies how much data (in
   * seconds) should be retained when clearing the buffer. This can help achieve
   * a fast switch that doesn't involve a buffering event. A minimum of two video
   * segments should always be kept buffered to avoid temporary hiccups.
   */
  type SwitchCallback = (a : shaka.extern.Variant , b ? : boolean , c ? : number ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern {
  type AdCuePoint = { end : number | null , start : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern {
  type AdsStats = { loadTimes : number [] , playedCompletely : number , skipped : number , started : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern {
  /**
   * Interface for Ad objects.
   */
  interface IAd extends shaka.util.IReleasable {
    canSkipNow ( ) : boolean ;
    getDuration ( ) : number ;
    /**
     * Gets the minimum suggested duration.  Defaults to being equivalent to
     * getDuration() for server-side ads.
     */
    getMinSuggestedDuration ( ) : number ;
    getPositionInSequence ( ) : number ;
    getRemainingTime ( ) : number ;
    getSequenceLength ( ) : number ;
    getTimeUntilSkippable ( ) : number ;
    getVolume ( ) : number ;
    isLinear ( ) : boolean ;
    isMuted ( ) : boolean ;
    isPaused ( ) : boolean ;
    isSkippable ( ) : boolean ;
    pause ( ) : any ;
    play ( ) : any ;
    resize (width : number , height : number ) : any ;
    setMuted (muted : boolean ) : any ;
    setVolume (volume : number ) : any ;
    skip ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern {
  /**
   * An object that's responsible for all the ad-related logic
   * in the player.
   */
  interface IAdManager extends EventTarget {
    getServerSideCuePoints ( ) : shaka.extern.AdCuePoint [] ;
    /**
     * Get statistics for the current playback session. If the player is not
     * playing content, this will return an empty stats object.
     */
    getStats ( ) : any ;
    initClientSide (adContainer : HTMLElement , video : HTMLMediaElement ) : any ;
    initServerSide (adContainer : HTMLElement , video : HTMLMediaElement ) : any ;
    onAssetUnload ( ) : any ;
    onCueMetadataChange (value : shaka.extern.ID3Metadata ) : any ;
    onDashTimedMetadata (region : shaka.extern.TimelineRegionInfo ) : any ;
    onHlsTimedMetadata (metadata : shaka.extern.ID3Metadata , timestampOffset : number ) : any ;
    release ( ) : any ;
    replaceServerSideAdTagParameters (adTagParameters : object | null ) : any ;
    requestClientSideAds (imaRequest : google.ima.AdsRequest ) : any ;
    requestServerSideStream (imaRequest : google.ima.dai.api.StreamRequest , backupUrl ? : string ) : Promise < string > ;
    setLocale (locale : string ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern.IAdManager {
  /**
   * A factory for creating the ad manager.
   */
  type Factory = ( ) => shaka.extern.IAdManager ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/error.js
declare namespace shaka.extern {
  interface Error {
    category : shaka.util.Error.Category ;
    code : shaka.util.Error.Code ;
    data : any [] ;
    handled : boolean ;
    severity : shaka.util.Error.Severity ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/error.js
declare namespace shaka.extern {
  type RestrictionInfo = { hasAppRestrictions : boolean , missingKeys : string [] , restrictedKeyStatuses : string [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  /**
   * Creates a SegmentIndex; returns a Promise that resolves after the
   * SegmentIndex has been created.
   */
  type CreateSegmentIndexFunction = ( ) => Promise < any > ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type DrmInfo = { audioRobustness : string , distinctiveIdentifierRequired : boolean , initData : shaka.extern.InitDataOverride [] | null , keyIds : Set < string > | null , keySystem : string , licenseServerUri : string , persistentStateRequired : boolean , serverCertificate : Uint8Array | null , serverCertificateUri : string , sessionType : string , videoRobustness : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  /**
   * A function that fetches the crypto keys for AES-128.
   * Returns a promise that resolves when the keys have been fetched.
   */
  type FetchCryptoKeysFunction = ( ) => Promise < any > ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type HlsAes128Key = { cryptoKey ? : webCrypto.CryptoKey | null , fetchKey ? : shaka.extern.CreateSegmentIndexFunction , firstMediaSequenceNumber : number , iv ? : Uint8Array , method : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type InitDataOverride = { initData : Uint8Array , initDataType : string , keyId : string | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type Manifest = { imageStreams : shaka.extern.Stream [] , minBufferTime : number , offlineSessionIds : string [] , presentationTimeline : shaka.media.PresentationTimeline , sequenceMode : boolean , textStreams : shaka.extern.Stream [] , variants : shaka.extern.Variant [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type Stream = { audioSamplingRate : number | null , bandwidth ? : number , channelsCount : number | null , closeSegmentIndex ? : ( ) => any , closedCaptions : Map < string , string > | null , codecs : string , createSegmentIndex : shaka.extern.CreateSegmentIndexFunction , drmInfos : shaka.extern.DrmInfo [] , emsgSchemeIdUris : string [] | null , encrypted : boolean , forced : boolean , frameRate ? : number , hdr ? : string , height ? : number , id : number , keyIds : Set < string > , kind ? : string , label : string | null , language : string , matchedStreams ? : any [] , mimeType : string , originalId : string | null , pixelAspectRatio ? : string , primary : boolean , roles : string [] , segmentIndex : shaka.media.SegmentIndex | null , spatialAudio : boolean , tilesLayout ? : string , trickModeVideo : any , type : string , width ? : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type Variant = { allowedByApplication : boolean , allowedByKeySystem : boolean , audio : shaka.extern.Stream | null , bandwidth : number , decodingInfos : ( any | null ) [] , disabledUntilTime : number , id : number , language : string , primary : boolean , video : shaka.extern.Stream | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest_parser.js
declare namespace shaka.extern {
  /**
   * Parses media manifests and handles manifest updates.
   *
   * Given a URI where the initial manifest is found, a parser will request the
   * manifest, parse it, and return the resulting Manifest object.
   *
   * If the manifest requires updates (e.g. for live media), the parser will use
   * background timers to update the same Manifest object.
   *
   * There are many ways for |start| and |stop| to be called. Implementations
   * should support all cases:
   *
   * BASIC
   * await parser.start(uri, playerInterface);
   * await parser.stop();
   *
   * INTERRUPTING
   * const p = parser.start(uri, playerInterface);
   * await parser.stop();
   * await p;
   *
   * |p| should be rejected with an OPERATION_ABORTED error.
   *
   * STOPPED BEFORE STARTING
   * await parser.stop();
   */
  interface ManifestParser {
    /**
     * Called by the Player to provide an updated configuration any time the
     * configuration changes.  Will be called at least once before start().
     */
    configure (config : shaka.extern.ManifestConfiguration ) : any ;
    /**
     * Tells the parser that the expiration time of an EME session has changed.
     * Implementing this is optional.
     */
    onExpirationUpdated (sessionId : string , expiration : number ) : any ;
    /**
     * Initialize and start the parser. When |start| resolves, it should return
     * the initial version of the manifest. |start| will only be called once. If
     * |stop| is called while |start| is pending, |start| should reject.
     * @param uri The URI of the manifest.
     * @param playerInterface The player interface contains the callbacks and members that the parser can use to communicate with the player and outside world.
     */
    start (uri : string , playerInterface : shaka.extern.ManifestParser.PlayerInterface ) : Promise < shaka.extern.Manifest > ;
    /**
     * Tell the parser that it must stop and free all internal resources as soon
     * as possible. Only once all internal resources are stopped and freed will
     * the promise resolve. Once stopped a parser will not be started again.
     *
     * The parser should support having |stop| called multiple times and the
     * promise should always resolve.
     */
    stop ( ) : Promise < any > ;
    /**
     * Tells the parser to do a manual manifest update.  Implementing this is
     * optional.  This is only called when 'emsg' boxes are present.
     */
    update ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest_parser.js
declare namespace shaka.extern.ManifestParser {
  /**
   * A factory for creating the manifest parser.  This function is registered with
   * shaka.media.ManifestParser to create parser instances.
   */
  type Factory = ( ) => shaka.extern.ManifestParser ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest_parser.js
declare namespace shaka.extern.ManifestParser {
  type PlayerInterface = { enableLowLatencyMode : ( ) => any , filter : (a : shaka.extern.Manifest ) => Promise < any > , isAutoLowLatencyMode : ( ) => boolean , isLowLatencyMode : ( ) => boolean , makeTextStreamsForClosedCaptions : (a : shaka.extern.Manifest ) => any , modifyManifestRequest : (a : shaka.extern.Request , b : shaka.util.CmcdManager.ManifestInfo ) => any , modifySegmentRequest : (a : shaka.extern.Request , b : shaka.util.CmcdManager.SegmentInfo ) => any , networkingEngine : shaka.net.NetworkingEngine , onError : (a : shaka.util.Error ) => any , onEvent : shaka.util.EventManager.ListenerType , onTimelineRegionAdded : (a : shaka.extern.TimelineRegionInfo ) => any } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/mp4_parser.js
declare namespace shaka.extern {
  type ParsedBox = { flags : number | null , has64BitSize : boolean , parser : shaka.util.Mp4Parser , partialOkay : boolean , reader : shaka.util.DataViewReader , size : number , start : number , version : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type HeadersReceived = (a : { [ key: string ]: string } ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type ProgressUpdated = (a : number , b : number , c : number ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type Request = { allowCrossSiteCredentials : boolean , body : ArrayBuffer | ArrayBufferView | null , drmInfo : shaka.extern.DrmInfo | null , headers : { [ key: string ]: string } , initData : Uint8Array | null , initDataType : string | null , licenseRequestType : string | null , method : string , retryParameters : shaka.extern.RetryParameters , sessionId : string | null , streamDataCallback : ( (a : ArrayBuffer | ArrayBufferView ) => Promise < any > ) | null , uris : string [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  /**
   * Defines a filter for requests.  This filter takes the request and modifies
   * it before it is sent to the scheme plugin.
   * A request filter can run asynchronously by returning a promise; in this case,
   * the request will not be sent until the promise is resolved.
   */
  type RequestFilter = (a : shaka.net.NetworkingEngine.RequestType , b : shaka.extern.Request ) => Promise < any > | void ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type Response = { data : ArrayBuffer | ArrayBufferView , fromCache ? : boolean , headers : { [ key: string ]: string } , status ? : number , timeMs ? : number , uri : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  /**
   * Defines a filter for responses.  This filter takes the response and modifies
   * it before it is returned.
   * A response filter can run asynchronously by returning a promise.
   */
  type ResponseFilter = (a : shaka.net.NetworkingEngine.RequestType , b : shaka.extern.Response ) => Promise < any > | void ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type RetryParameters = { backoffFactor : number , baseDelay : number , connectionTimeout : number , fuzzFactor : number , maxAttempts : number , stallTimeout : number , timeout : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type SchemePlugin = (a : string , b : shaka.extern.Request , c : shaka.net.NetworkingEngine.RequestType , d : shaka.extern.ProgressUpdated , e : shaka.extern.HeadersReceived ) => shaka.extern.IAbortableOperation < shaka.extern.Response > ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type EmeSessionDB = { audioCapabilities : { contentType : string , robustness : string } [] , keySystem : string , licenseUri : string , serverCertificate : Uint8Array | null , sessionId : string , videoCapabilities : { contentType : string , robustness : string } [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  /**
   * Similar to storage cells (shaka.extern.StorageCell), an EmeSessionStorageCell
   * stores data persistently.  This only stores the license's session info, not
   * the license itself.  The license itself is stored using EME.
   */
  interface EmeSessionStorageCell {
    /**
     * Adds the given sessions to the store.
     */
    add (sessions : shaka.extern.EmeSessionDB [] ) : Promise < any > ;
    /**
     * Free all resources used by this cell. This won't affect the stored content.
     */
    destroy ( ) : Promise < any > ;
    /**
     * Gets the currently stored sessions.
     */
    getAll ( ) : Promise < shaka.extern.EmeSessionDB [] > ;
    /**
     * Removes the given session IDs from the store.
     */
    remove (sessionIds : string [] ) : Promise < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type ManifestDB = { appMetadata : object | null , creationTime : number , drmInfo : shaka.extern.DrmInfo | null , duration : number , expiration : number , isIncomplete ? : boolean , originalManifestUri : string , sequenceMode ? : boolean , sessionIds : string [] , size : number , streams : shaka.extern.StreamDB [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type OfflineSupport = { basic : boolean , encrypted : { [ key: string ]: boolean } } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type SegmentDB = { appendWindowEnd : number , appendWindowStart : number , dataKey : number , endTime : number , initSegmentKey : number | null , pendingInitSegmentRefId ? : string , pendingSegmentRefId ? : string , startTime : number , tilesLayout : string | null , timestampOffset : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type SegmentDataDB = { data : ArrayBuffer } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  /**
   * An interface that defines access to collection of segments and manifests. All
   * methods are designed to be batched operations allowing the implementations to
   * optimize their operations based on how they store data.
   *
   * The storage cell is one of two exposed APIs used to control where and how
   * offline content is saved. The storage cell is responsible for converting
   * information between its internal structures and the external (library)
   * structures.
   */
  interface StorageCell {
    /**
     * Add a group of manifests. Will return a promise that resolves with a list
     * of keys for each manifest. If one manifest fails to be added, all manifests
     * should fail to be added.
     */
    addManifests (manifests : shaka.extern.ManifestDB [] ) : Promise < number [] > ;
    /**
     * Add a group of segments. Will return a promise that resolves with a list
     * of keys for each segment. If one segment fails to be added, all segments
     * should fail to be added.
     */
    addSegments (segments : shaka.extern.SegmentDataDB [] ) : Promise < number [] > ;
    /**
     * Free all resources used by this cell. This should not affect the stored
     * content.
     */
    destroy ( ) : Promise < any > ;
    /**
     * Get all manifests stored in this cell. Since manifests are small compared
     * to the asset they describe, it is assumed that it is feasible to have them
     * all in main memory at one time.
     */
    getAllManifests ( ) : Promise < Map < number , shaka.extern.ManifestDB > > ;
    /**
     * Get a group of manifests using their keys to identify them. If any key is
     * not found, the promise chain will be rejected.
     */
    getManifests (keys : number [] ) : Promise < shaka.extern.ManifestDB [] > ;
    /**
     * Get a group of segments using their keys to identify them. If any key is
     * not found, the promise chain will be rejected.
     */
    getSegments (keys : number [] ) : Promise < shaka.extern.SegmentDataDB [] > ;
    /**
     * Check if the cell can support new keys. If a cell has a fixed key space,
     * then all add-operations will fail as no new keys can be added. All
     * remove-operations and update-operations should still work.
     */
    hasFixedKeySpace ( ) : boolean ;
    /**
     * Remove a group of manifests using their keys to identify them. If a key
     * is not found, then that removal should be considered successful.
     * @param onRemove A callback for when a manifest is removed from the cell. The key of the manifest will be passed to the callback.
     */
    removeManifests (keys : number [] , onRemove : (a : number ) => any ) : Promise < any > ;
    /**
     * Remove a group of segments using their keys to identify them. If a key
     * is not found, then that removal should be considered successful.
     * @param onRemove A callback for when a segment is removed from the cell. The key of the segment will be passed to the callback.
     */
    removeSegments (keys : number [] , onRemove : (a : number ) => any ) : Promise < any > ;
    /**
     * Updates the given manifest, stored at the given key.
     */
    updateManifest (key : number , manifest : shaka.extern.ManifestDB ) : Promise < any > ;
    /**
     * Replace the expiration time of the manifest stored under |key| with
     * |newExpiration|. If no manifest is found under |key| then this should
     * act as a no-op.
     */
    updateManifestExpiration (key : number , expiration : number ) : Promise < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  /**
   * Storage mechanisms are one of two exported storage APIs. Storage mechanisms
   * are groups of storage cells (shaka.extern.StorageCell). Storage mechanisms
   * are responsible for managing the life cycle of resources shared between
   * storage cells in the same block.
   *
   * For example, a storage mechanism may manage a single database connection
   * while each cell would manage different tables in the database via the same
   * connection.
   */
  interface StorageMechanism {
    /**
     * Free all resources used by the storage mechanism and its cells. This should
     * not affect the stored content.
     */
    destroy ( ) : Promise < any > ;
    /**
     * Erase all content from storage and leave storage in an empty state. Erase
     * may be called with or without |init|.  This allows for storage to be wiped
     * in case of a version mismatch.
     *
     * After calling |erase|, the mechanism will be in an initialized state.
     */
    erase ( ) : Promise < any > ;
    /**
     * Get a map of all the cells managed by the storage mechanism. Editing the
     * map should have no effect on the storage mechanism. The map key is the
     * cell's address in the mechanism and should be consistent between calls to
     * |getCells|.
     */
    getCells ( ) : Map < string , shaka.extern.StorageCell > ;
    /**
     * Get the current EME session storage cell.
     */
    getEmeSessionCell ( ) : shaka.extern.EmeSessionStorageCell ;
    /**
     * Initialize the storage mechanism for first use. This should only be called
     * once. Calling |init| multiple times has an undefined behaviour.
     */
    init ( ) : Promise < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type StoredContent = { appMetadata : object | null , duration : number , expiration : number , isIncomplete : boolean , offlineUri : string | null , originalManifestUri : string , size : number , tracks : shaka.extern.TrackList } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type StreamDB = { audioSamplingRate : number | null , channelsCount : number | null , closedCaptions : Map < string , string > | null , codecs : string , encrypted : boolean , forced : boolean , frameRate ? : number , hdr ? : string , height : number | null , id : number , keyIds : Set < string > , kind ? : string , label : string | null , language : string , mimeType : string , originalId : string | null , pixelAspectRatio ? : string , primary : boolean , roles : string [] , segments : shaka.extern.SegmentDB [] , spatialAudio : boolean , tilesLayout ? : string , type : string , variantIds : number [] , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v1.js
declare namespace shaka.extern {
  type ManifestDBV1 = { appMetadata : object | null , drmInfo : shaka.extern.DrmInfo | null , duration : number , expiration : number , key : number , originalManifestUri : string , periods : shaka.extern.PeriodDBV1 [] , sessionIds : string [] , size : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v1.js
declare namespace shaka.extern {
  type PeriodDBV1 = { startTime : number , streams : shaka.extern.StreamDBV1 [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v1.js
declare namespace shaka.extern {
  type SegmentDBV1 = { endTime : number , startTime : number , uri : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v1.js
declare namespace shaka.extern {
  type SegmentDataDBV1 = { data : ArrayBuffer , key : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v1.js
declare namespace shaka.extern {
  type StreamDBV1 = { codecs : string , contentType : string , encrypted : boolean , frameRate ? : number , height : number | null , id : number , initSegmentUri : string | null , keyId : string | null , kind ? : string , label : string | null , language : string , mimeType : string , presentationTimeOffset : number , primary : boolean , segments : shaka.extern.SegmentDBV1 [] , variantIds : number [] , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v2.js
declare namespace shaka.extern {
  type ManifestDBV2 = { appMetadata : object | null , drmInfo : shaka.extern.DrmInfo | null , duration : number , expiration : number , originalManifestUri : string , periods : shaka.extern.PeriodDBV2 [] , sessionIds : string [] , size : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v2.js
declare namespace shaka.extern {
  type PeriodDBV2 = { startTime : number , streams : shaka.extern.StreamDBV2 [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v2.js
declare namespace shaka.extern {
  type SegmentDBV2 = { dataKey : number , endTime : number , startTime : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v2.js
declare namespace shaka.extern {
  type SegmentDataDBV2 = { data : ArrayBuffer } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v2.js
declare namespace shaka.extern {
  type StreamDBV2 = { codecs : string , contentType : string , encrypted : boolean , frameRate ? : number , height : number | null , id : number , initSegmentKey : number | null , keyId : string | null , kind ? : string , label : string | null , language : string , mimeType : string , originalId : string | null , pixelAspectRatio ? : string , presentationTimeOffset : number , primary : boolean , segments : shaka.extern.SegmentDBV2 [] , variantIds : number [] , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type AbrConfiguration = { advanced : shaka.extern.AdvancedAbrConfiguration , bandwidthDowngradeTarget : number , bandwidthUpgradeTarget : number , defaultBandwidthEstimate : number , enabled : boolean , ignoreDevicePixelRatio : boolean , restrictToElementSize : boolean , restrictions : shaka.extern.Restrictions , switchInterval : number , useNetworkInformation : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type AdvancedAbrConfiguration = { fastHalfLife : number , minBytes : number , minTotalBytes : number , slowHalfLife : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type AdvancedDrmConfiguration = { audioRobustness : string , distinctiveIdentifierRequired : boolean , individualizationServer : string , persistentStateRequired : boolean , serverCertificate : Uint8Array | null , serverCertificateUri : string , sessionType : string , videoRobustness : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type BufferedInfo = { audio : shaka.extern.BufferedRange [] , text : shaka.extern.BufferedRange [] , total : shaka.extern.BufferedRange [] , video : shaka.extern.BufferedRange [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type BufferedRange = { end : number , start : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type Chapter = { endTime : number , id : string , startTime : number , title : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type CmcdConfiguration = { contentId : string , enabled : boolean , sessionId : string , useHeaders : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type DashManifestConfiguration = { autoCorrectDrift : boolean , clockSyncUri : string , disableXlinkProcessing : boolean , ignoreDrmInfo : boolean , ignoreEmptyAdaptationSet : boolean , ignoreMaxSegmentDuration : boolean , ignoreMinBufferTime : boolean , ignoreSuggestedPresentationDelay : boolean , initialSegmentLimit : number , keySystemsByURI : { [ key: string ]: string } , manifestPreprocessor : (a : Element ) => any , xlinkFailGracefully : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type DrmConfiguration = { advanced : { [ key: string ]: shaka.extern.AdvancedDrmConfiguration } | null , clearKeys : { [ key: string ]: string } , delayLicenseRequestUntilPlayed : boolean , initDataTransform ? : (a : Uint8Array , b : string , c : shaka.extern.DrmInfo | null ) => Uint8Array , keySystemsMapping : { [ key: string ]: string } , logLicenseExchange : boolean , preferredKeySystems : string [] , retryParameters : shaka.extern.RetryParameters , servers : { [ key: string ]: string } , updateExpirationTime : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type DrmSupportType = { persistentState : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type EmsgInfo = { endTime : number , eventDuration : number , id : number , messageData : Uint8Array | null , presentationTimeDelta : number , schemeIdUri : string , startTime : number , timescale : number , value : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type HlsManifestConfiguration = { defaultAudioCodec : string , defaultVideoCodec : string , ignoreImageStreamFailures : boolean , ignoreManifestProgramDateTime : boolean , ignoreTextStreamFailures : boolean , mediaPlaylistFullMimeType : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type ID3Metadata = { [ key: string ]: any } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type LanguageRole = { label : string | null , language : string , role : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type ManifestConfiguration = { availabilityWindowOverride : number , dash : shaka.extern.DashManifestConfiguration , defaultPresentationDelay : number , disableAudio : boolean , disableText : boolean , disableThumbnails : boolean , disableVideo : boolean , hls : shaka.extern.HlsManifestConfiguration , retryParameters : shaka.extern.RetryParameters , segmentRelativeVttTiming : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type MediaQualityInfo = { audioSamplingRate : number | null , bandwidth : number , channelsCount : number | null , codecs : string , contentType : string , frameRate : number | null , height : number | null , mimeType : string | null , pixelAspectRatio : string | null , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type OfflineConfiguration = { downloadSizeCallback : (a : number ) => Promise < boolean > , numberOfParallelDownloads : number , progressCallback : (a : shaka.extern.StoredContent , b : number ) => any , trackSelectionCallback : (a : shaka.extern.TrackList ) => Promise < shaka.extern.TrackList > , usePersistentLicense : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type PlayerConfiguration = { abr : shaka.extern.AbrConfiguration , abrFactory : shaka.extern.AbrManager.Factory , cmcd : shaka.extern.CmcdConfiguration , drm : shaka.extern.DrmConfiguration , manifest : shaka.extern.ManifestConfiguration , offline : shaka.extern.OfflineConfiguration , playRangeEnd : number , playRangeStart : number , preferForcedSubs : boolean , preferredAudioChannelCount : number , preferredAudioCodecs : string [] , preferredAudioLanguage : string , preferredDecodingAttributes : string [] , preferredTextLanguage : string , preferredTextRole : string , preferredVariantRole : string , preferredVideoCodecs : string [] , restrictions : shaka.extern.Restrictions , streaming : shaka.extern.StreamingConfiguration , textDisplayFactory : shaka.extern.TextDisplayer.Factory } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type Restrictions = { maxBandwidth : number , maxFrameRate : number , maxHeight : number , maxPixels : number , maxWidth : number , minBandwidth : number , minFrameRate : number , minHeight : number , minPixels : number , minWidth : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type StateChange = { duration : number , state : string , timestamp : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type Stats = { bufferingTime : number , completionPercent : number , corruptedFrames : number , decodedFrames : number , drmTimeSeconds : number , droppedFrames : number , estimatedBandwidth : number , gapsJumped : number , height : number , licenseTime : number , liveLatency : number , loadLatency : number , manifestTimeSeconds : number , maxSegmentDuration : number , pauseTime : number , playTime : number , stallsDetected : number , stateHistory : shaka.extern.StateChange [] , streamBandwidth : number , switchHistory : shaka.extern.TrackChoice [] , width : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type StreamingConfiguration = { alwaysStreamText : boolean , autoLowLatencyMode : boolean , bufferBehind : number , bufferingGoal : number , dispatchAllEmsgBoxes : boolean , durationBackoff : number , failureCallback : (a : shaka.util.Error ) => any , forceHTTPS : boolean , forceTransmuxTS : boolean , gapDetectionThreshold : number , ignoreTextStreamFailures : boolean , inaccurateManifestTolerance : number , lowLatencyMode : boolean , maxDisabledTime : number , observeQualityChanges : boolean , preferNativeHls : boolean , rebufferingGoal : number , retryParameters : shaka.extern.RetryParameters , safeSeekOffset : number , stallEnabled : boolean , stallSkip : number , stallThreshold : number , startAtSegmentBoundary : boolean , updateIntervalSeconds : number , useNativeHlsOnSafari : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type SupportType = { drm : { [ key: string ]: shaka.extern.DrmSupportType | null } , manifest : { [ key: string ]: boolean } , media : { [ key: string ]: boolean } } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type Thumbnail = { duration : number , height : number , imageHeight : number , imageWidth : number , positionX : number , positionY : number , startTime : number , uris : string [] , width : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type TimelineRegionInfo = { endTime : number , eventElement : Element | null , id : string , schemeIdUri : string , startTime : number , value : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type Track = { active : boolean , audioBandwidth : number | null , audioCodec : string | null , audioId : number | null , audioMimeType : string | null , audioRoles : string [] | null , audioSamplingRate : number | null , bandwidth : number , channelsCount : number | null , codecs : string | null , forced : boolean , frameRate : number | null , hdr : string | null , height : number | null , id : number , kind : string | null , label : string | null , language : string , mimeType : string | null , originalAudioId : string | null , originalImageId : string | null , originalTextId : string | null , originalVideoId : string | null , pixelAspectRatio : string | null , primary : boolean , roles : string [] , spatialAudio : boolean , tilesLayout : string | null , type : string , videoBandwidth : number | null , videoCodec : string | null , videoId : number | null , videoMimeType : string | null , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type TrackChoice = { bandwidth : number | null , fromAdaptation : boolean , id : number , timestamp : number , type : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type TrackList = shaka.extern.Track [] ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern {
  interface Cue {
    /**
     * Text background color as a CSS color, e.g. "#FFFFFF" or "white".
     */
    backgroundColor : string ;
    /**
     * The URL of the background image, e.g. "data:[mime type];base64,[data]".
     */
    backgroundImage : string ;
    /**
     * The border around this cue as a CSS border.
     */
    border : string ;
    /**
     * The number of horizontal and vertical cells into which the Root Container
     * Region area is divided.
     */
    cellResolution : { columns : number , rows : number } ;
    /**
     * Text color as a CSS color, e.g. "#FFFFFF" or "white".
     */
    color : string ;
    /**
     * Text direction of the cue.
     */
    direction : shaka.text.Cue.direction ;
    /**
     * Vertical alignments of the cues within their extents.
     * 'BEFORE' means displaying the captions at the top of the text display
     * container box, 'CENTER' means in the middle, 'AFTER' means at the bottom.
     */
    displayAlign : shaka.text.Cue.displayAlign ;
    /**
     * The end time of the cue in seconds, relative to the start of the
     * presentation.
     */
    endTime : number ;
    /**
     * Text font family.
     */
    fontFamily : string ;
    /**
     * Text font size in px or em (e.g. '100px'/'100em').
     */
    fontSize : string ;
    /**
     * Text font style. Normal, italic or oblique.
     */
    fontStyle : shaka.text.Cue.fontStyle ;
    /**
     * Text font weight. Either normal or bold.
     */
    fontWeight : shaka.text.Cue.fontWeight ;
    /**
     * Id of the cue.
     */
    id : string ;
    /**
     * If true, this represents a container element that is "above" the main
     * cues. For example, the <body> and <div> tags that contain the <p> tags
     * in a TTML file. This controls the flow of the final cues; any nested cues
     * within an "isContainer" cue will be laid out as separate lines.
     */
    isContainer : boolean ;
    /**
     * Text letter spacing as a CSS letter-spacing value.
     */
    letterSpacing : string ;
    /**
     * The offset from the display box in either number of lines or
     * percentage depending on the value of lineInterpretation.
     */
    line : number | null ;
    /**
     * Line alignment of the cue box.
     * Start alignment means the cue box’s top side (for horizontal cues), left
     * side (for vertical growing right), or right side (for vertical growing
     * left) is aligned at the line.
     * Center alignment means the cue box is centered at the line.
     * End alignment The cue box’s bottom side (for horizontal cues), right side
     * (for vertical growing right), or left side (for vertical growing left) is
     * aligned at the line.
     */
    lineAlign : shaka.text.Cue.lineAlign ;
    /**
     * Whether or not the cue only acts as a line break between two nested cues.
     * Should only appear in nested cues.
     */
    lineBreak : boolean ;
    /**
     * Separation between line areas inside the cue box in px or em
     * (e.g. '100px'/'100em'). If not specified, this should be no less than
     * the largest font size applied to the text in the cue.
     */
    lineHeight : string ;
    /**
     * The way to interpret line field. (Either as an integer line number or
     * percentage from the display box).
     */
    lineInterpretation : shaka.text.Cue.lineInterpretation ;
    /**
     * Text line padding as a CSS line-padding value.
     */
    linePadding : string ;
    /**
     * Nested cues, which should be laid out horizontally in one block.
     * Top-level cues are blocks, and nested cues are inline elements.
     * Cues can be nested arbitrarily deeply.
     */
    nestedCues : shaka.extern.Cue [] ;
    /**
     * Opacity of the cue element, from 0-1.
     */
    opacity : number ;
    /**
     * The text payload of the cue.  If nestedCues is non-empty, this should be
     * empty.  Top-level block containers should have no payload of their own.
     */
    payload : string ;
    /**
     * The indent (in percent) of the cue box in the direction defined by the
     * writing direction.
     */
    position : number | null ;
    /**
     * Position alignment of the cue.
     */
    positionAlign : shaka.text.Cue.positionAlign ;
    /**
     * The region to render the cue into.  Only supported on top-level cues,
     * because nested cues are inline elements.
     */
    region : shaka.extern.CueRegion | null ;
    /**
     * Size of the cue box (in percents), where 0 means "auto".
     */
    size : number ;
    /**
     * The start time of the cue in seconds, relative to the start of the
     * presentation.
     */
    startTime : number ;
    /**
     * Alignment of the text inside the cue box.
     */
    textAlign : shaka.text.Cue.textAlign ;
    /**
     * Text decoration. A combination of underline, overline
     * and line through. Empty array means no decoration.
     */
    textDecoration : shaka.text.Cue.textDecoration [] ;
    /**
     * Text shadow color as a CSS text-shadow value.
     */
    textShadow : string ;
    /**
     * Text stroke color as a CSS color, e.g. "#FFFFFF" or "white".
     */
    textStrokeColor : string ;
    /**
     * Text stroke width as a CSS stroke-width value.
     */
    textStrokeWidth : string ;
    /**
     * Whether or not line wrapping should be applied to the cue.
     */
    wrapLine : boolean ;
    /**
     * Text writing mode of the cue.
     */
    writingMode : shaka.text.Cue.writingMode ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern {
  interface CueRegion {
    /**
     * The width of the rendering area in heightUnits.
     */
    height : number ;
    /**
     * The units (percentage, pixels or lines) the region height is in.
     */
    heightUnits : shaka.text.CueRegion.units ;
    /**
     * Region identifier.
     */
    id : string ;
    /**
     * The X offset to start the rendering area in percentage (0-100) of this
     * region width.
     */
    regionAnchorX : number ;
    /**
     * The Y offset to start the rendering area in percentage (0-100) of the
     * region height.
     */
    regionAnchorY : number ;
    /**
     * If scroll=UP, it means that cues in the region will be added to the
     * bottom of the region and will push any already displayed cues in the
     * region up.  Otherwise (scroll=NONE) cues will stay fixed at the location
     * they were first painted in.
     */
    scroll : shaka.text.CueRegion.scrollMode ;
    /**
     * The units (percentage or pixels) the region viewportAnchors are in.
     */
    viewportAnchorUnits : shaka.text.CueRegion.units ;
    /**
     * The X offset to start the rendering area in viewportAnchorUnits of the
     * video width.
     */
    viewportAnchorX : number ;
    /**
     * The X offset to start the rendering area in viewportAnchorUnits of the
     * video height.
     */
    viewportAnchorY : number ;
    /**
     * The width of the rendering area in widthUnits.
     */
    width : number ;
    /**
     * The units (percentage or pixels) the region width is in.
     */
    widthUnits : shaka.text.CueRegion.units ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern {
  interface TextDisplayer extends shaka.util.IDestroyable {
    /**
     * Append given text cues to the list of cues to be displayed.
     * @param cues Text cues to be appended.
     */
    append (cues : shaka.text.Cue [] ) : any ;
    destroy ( ) : Promise < any > ;
    /**
     * Returns true if text is currently visible.
     */
    isTextVisible ( ) : boolean ;
    /**
     * Remove all cues that are fully contained by the given time range (relative
     * to the presentation). <code>endTime</code> will be greater to equal to
     * <code>startTime</code>.  <code>remove</code> should only return
     * <code>false</code> if the displayer has been destroyed. If the displayer
     * has not been destroyed <code>remove</code> should return <code>true</code>.
     */
    remove (startTime : number , endTime : number ) : boolean ;
    /**
     * Set text visibility.
     */
    setTextVisibility (on : boolean ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern.TextDisplayer {
  /**
   * A factory for creating a TextDisplayer.
   */
  type Factory = ( ) => shaka.extern.TextDisplayer ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern {
  /**
   * An interface for plugins that parse text tracks.
   */
  interface TextParser {
    /**
     * Parse an initialization segment. Some formats do not have init
     * segments so this won't always be called.
     * @param data The data that makes up the init segment.
     */
    parseInit (data : Uint8Array ) : any ;
    /**
     * Parse a media segment and return the cues that make up the segment.
     * @param data The next section of buffer.
     * @param timeContext The time information that should be used to adjust the times values for each cue.
     */
    parseMedia (data : Uint8Array , timeContext : shaka.extern.TextParser.TimeContext ) : shaka.extern.Cue [] ;
    /**
     * Notifies the stream if the manifest is in sequence mode or not.
     */
    setSequenceMode (sequenceMode : boolean ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern.TextParser {
  /**
   * A collection of time offsets used to adjust text cue times.
   */
  type TimeContext = { periodStart : number , segmentEnd : number , segmentStart : number , vttOffset : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern {
  type TextParserPlugin = ( ) => shaka.extern.TextParser ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/tippy.js
declare namespace ಠ_ಠ.clutz {
  /**
   * This is the subset of this method that we use in our demo code.
   */
  function tippy (element : Element , config : object ) : any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/webkitmediakeys.js
declare namespace ಠ_ಠ.clutz {
  class WebKitMediaKeyError {
    private noStructuralTyping_WebKitMediaKeyError : any;
    code : number ;
    systemCode : number ;
    static MEDIA_KEYERR_CLIENT : number ;
    static MEDIA_KEYERR_DOMAIN : number ;
    static MEDIA_KEYERR_HARDWARECHANGE : number ;
    static MEDIA_KEYERR_OUTPUT : number ;
    static MEDIA_KEYERR_SERVICE : number ;
    static MEDIA_KEYERR_UNKNOWN : number ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/webkitmediakeys.js
declare namespace ಠ_ಠ.clutz {
  interface WebKitMediaKeySession extends EventTarget {
    addEventListener (type : any , listener : any , useCapture : any ) : any ;
    close ( ) : any ;
    dispatchEvent (evt : any ) : any ;
    error : WebKitMediaKeyError | null ;
    removeEventListener (type : any , listener : any , useCapture : any ) : any ;
    sessionId : string ;
    update (message : Uint8Array | null ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/webkitmediakeys.js
declare namespace ಠ_ಠ.clutz {
  class WebKitMediaKeys {
    private noStructuralTyping_WebKitMediaKeys : any;
    constructor (keySystem : string ) ;
    createSession (contentType : string , initData : Uint8Array | null ) : WebKitMediaKeySession ;
    static isTypeSupported (keySystem : string , contentType : string ) : boolean ;
  }
}
