<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [toFile][1]
-   [toBuffer][2]
-   [withMetadata][3]
-   [jpeg][4]
-   [png][5]
-   [webp][6]
-   [tiff][7]
-   [raw][8]
-   [toFormat][9]
-   [tile][10]

## toFile

Write output image data to a file.

If an explicit output format is not selected, it will be inferred from the extension,
with JPEG, PNG, WebP, TIFF, DZI, and libvips' V format supported.
Note that raw pixel data is only supported for buffer output.

A `Promise` is returned when `callback` is not provided.

**Parameters**

-   `fileOut` **[String][11]** the path to write the image data to.
-   `callback` **[Function][12]?** called on completion with two arguments `(err, info)`.
    `info` contains the output image `format`, `size` (bytes), `width`, `height`,
    `channels` and `premultiplied` (indicating if premultiplication was used).
    When using a crop strategy also contains `cropOffsetLeft` and `cropOffsetTop`.

**Examples**

```javascript
sharp(input)
  .toFile('output.png', (err, info) => { ... });
```

```javascript
sharp(input)
  .toFile('output.png')
  .then(info => { ... })
  .catch(err => { ... });
```

-   Throws **[Error][13]** Invalid parameters

Returns **[Promise][14]&lt;[Object][15]>** when no callback is provided

## toBuffer

Write output to a Buffer.
JPEG, PNG, WebP, TIFF and RAW output are supported.
By default, the format will match the input image, except GIF and SVG input which become PNG output.

`callback`, if present, gets three arguments `(err, data, info)` where:

-   `err` is an error, if any.
-   `data` is the output image data.
-   `info` contains the output image `format`, `size` (bytes), `width`, `height`,
    `channels` and `premultiplied` (indicating if premultiplication was used).
    When using a crop strategy also contains `cropOffsetLeft` and `cropOffsetTop`.

A `Promise` is returned when `callback` is not provided.

**Parameters**

-   `options` **[Object][15]?** 
    -   `options.resolveWithObject` **[Boolean][16]?** Resolve the Promise with an Object containing `data` and `info` properties instead of resolving only with `data`.
-   `callback` **[Function][12]?** 

**Examples**

```javascript
sharp(input)
  .toBuffer((err, data, info) => { ... });
```

```javascript
sharp(input)
  .toBuffer()
  .then(data => { ... })
  .catch(err => { ... });
```

```javascript
sharp(input)
  .toBuffer({ resolveWithObject: true })
  .then(({ data, info }) => { ... })
  .catch(err => { ... });
```

Returns **[Promise][14]&lt;[Buffer][17]>** when no callback is provided

## withMetadata

Include all metadata (EXIF, XMP, IPTC) from the input image in the output image.
The default behaviour, when `withMetadata` is not used, is to strip all metadata and convert to the device-independent sRGB colour space.
This will also convert to and add a web-friendly sRGB ICC profile.

**Parameters**

-   `withMetadata` **[Object][15]?** 
    -   `withMetadata.orientation` **[Number][18]?** value between 1 and 8, used to update the EXIF `Orientation` tag.

**Examples**

```javascript
sharp('input.jpg')
  .withMetadata()
  .toFile('output-with-metadata.jpg')
  .then(info => { ... });
```

-   Throws **[Error][13]** Invalid parameters

Returns **Sharp** 

## jpeg

Use these JPEG options for output image.

**Parameters**

-   `options` **[Object][15]?** output options
    -   `options.quality` **[Number][18]** quality, integer 1-100 (optional, default `80`)
    -   `options.progressive` **[Boolean][16]** use progressive (interlace) scan (optional, default `false`)
    -   `options.chromaSubsampling` **[String][11]** set to '4:4:4' to prevent chroma subsampling when quality &lt;= 90 (optional, default `'4:2:0'`)
    -   `options.trellisQuantisation` **[Boolean][16]** apply trellis quantisation, requires mozjpeg (optional, default `false`)
    -   `options.overshootDeringing` **[Boolean][16]** apply overshoot deringing, requires mozjpeg (optional, default `false`)
    -   `options.optimiseScans` **[Boolean][16]** optimise progressive scans, forces progressive, requires mozjpeg (optional, default `false`)
    -   `options.optimizeScans` **[Boolean][16]** alternative spelling of optimiseScans (optional, default `false`)
    -   `options.force` **[Boolean][16]** force JPEG output, otherwise attempt to use input format (optional, default `true`)

**Examples**

```javascript
// Convert any input to very high quality JPEG output
const data = await sharp(input)
  .jpeg({
    quality: 100,
    chromaSubsampling: '4:4:4'
  })
  .toBuffer();
```

-   Throws **[Error][13]** Invalid options

Returns **Sharp** 

## png

Use these PNG options for output image.

PNG output is always full colour at 8 or 16 bits per pixel.
Indexed PNG input at 1, 2 or 4 bits per pixel is converted to 8 bits per pixel.

**Parameters**

-   `options` **[Object][15]?** 
    -   `options.progressive` **[Boolean][16]** use progressive (interlace) scan (optional, default `false`)
    -   `options.compressionLevel` **[Number][18]** zlib compression level, 0-9 (optional, default `9`)
    -   `options.adaptiveFiltering` **[Boolean][16]** use adaptive row filtering (optional, default `false`)
    -   `options.force` **[Boolean][16]** force PNG output, otherwise attempt to use input format (optional, default `true`)

**Examples**

```javascript
// Convert any input to PNG output
const data = await sharp(input)
  .png()
  .toBuffer();
```

-   Throws **[Error][13]** Invalid options

Returns **Sharp** 

## webp

Use these WebP options for output image.

**Parameters**

-   `options` **[Object][15]?** output options
    -   `options.quality` **[Number][18]** quality, integer 1-100 (optional, default `80`)
    -   `options.alphaQuality` **[Number][18]** quality of alpha layer, integer 0-100 (optional, default `100`)
    -   `options.lossless` **[Boolean][16]** use lossless compression mode (optional, default `false`)
    -   `options.nearLossless` **[Boolean][16]** use near_lossless compression mode (optional, default `false`)
    -   `options.force` **[Boolean][16]** force WebP output, otherwise attempt to use input format (optional, default `true`)

**Examples**

```javascript
// Convert any input to lossless WebP output
const data = await sharp(input)
  .webp({ lossless: true })
  .toBuffer();
```

-   Throws **[Error][13]** Invalid options

Returns **Sharp** 

## tiff

Use these TIFF options for output image.

**Parameters**

-   `options` **[Object][15]?** output options
    -   `options.quality` **[Number][18]** quality, integer 1-100 (optional, default `80`)
    -   `options.force` **[Boolean][16]** force TIFF output, otherwise attempt to use input format (optional, default `true`)
    -   `options.compression` **[Boolean][16]** compression options: lzw, deflate, jpeg, ccittfax4 (optional, default `'jpeg'`)
    -   `options.predictor` **[Boolean][16]** compression predictor options: none, horizontal, float (optional, default `'horizontal'`)
    -   `options.xres` **[Number][18]** horizontal resolution in pixels/mm (optional, default `1.0`)
    -   `options.yres` **[Number][18]** vertical resolution in pixels/mm (optional, default `1.0`)
    -   `options.squash` **[Boolean][16]** squash 8-bit images down to 1 bit (optional, default `false`)

**Examples**

```javascript
// Convert SVG input to LZW-compressed, 1 bit per pixel TIFF output
sharp('input.svg')
  .tiff({
    compression: 'lzw',
    squash: true
  })
  .toFile('1-bpp-output.tiff')
  .then(info => { ... });
```

-   Throws **[Error][13]** Invalid options

Returns **Sharp** 

## raw

Force output to be raw, uncompressed uint8 pixel data.

**Examples**

```javascript
// Extract raw RGB pixel data from JPEG input
const { data, info } = await sharp('input.jpg')
  .raw()
  .toBuffer({ resolveWithObject: true });
```

Returns **Sharp** 

## toFormat

Force output to a given format.

**Parameters**

-   `format` **([String][11] \| [Object][15])** as a String or an Object with an 'id' attribute
-   `options` **[Object][15]** output options

**Examples**

```javascript
// Convert any input to PNG output
const data = await sharp(input)
  .toFormat('png')
  .toBuffer();
```

-   Throws **[Error][13]** unsupported format or options

Returns **Sharp** 

## tile

Use tile-based deep zoom (image pyramid) output.
Set the format and options for tile images via the `toFormat`, `jpeg`, `png` or `webp` functions.
Use a `.zip` or `.szi` file extension with `toFile` to write to a compressed archive file format.

Warning: multiple sharp instances concurrently producing tile output can expose a possible race condition in some versions of libgsf.

**Parameters**

-   `tile` **[Object][15]?** 
    -   `tile.size` **[Number][18]** tile size in pixels, a value between 1 and 8192. (optional, default `256`)
    -   `tile.overlap` **[Number][18]** tile overlap in pixels, a value between 0 and 8192. (optional, default `0`)
    -   `tile.angle` **[Number][18]** tile angle of rotation, must be a multiple of 90. (optional, default `0`)
    -   `tile.container` **[String][11]** tile container, with value `fs` (filesystem) or `zip` (compressed file). (optional, default `'fs'`)
    -   `tile.layout` **[String][11]** filesystem layout, possible values are `dz`, `zoomify` or `google`. (optional, default `'dz'`)

**Examples**

```javascript
sharp('input.tiff')
  .png()
  .tile({
    size: 512
  })
  .toFile('output.dz', function(err, info) {
    // output.dzi is the Deep Zoom XML definition
    // output_files contains 512x512 tiles grouped by zoom level
  });
```

-   Throws **[Error][13]** Invalid parameters

Returns **Sharp** 

[1]: #tofile

[2]: #tobuffer

[3]: #withmetadata

[4]: #jpeg

[5]: #png

[6]: #webp

[7]: #tiff

[8]: #raw

[9]: #toformat

[10]: #tile

[11]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[12]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function

[13]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error

[14]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise

[15]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[16]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[17]: https://nodejs.org/api/buffer.html

[18]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number
