<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [resize][1]
-   [crop][2]
-   [embed][3]
-   [max][4]
-   [min][5]
-   [ignoreAspectRatio][6]
-   [withoutEnlargement][7]

## resize

Resize image to `width` x `height`.
By default, the resized image is centre cropped to the exact size specified.

Possible kernels are:

-   `nearest`: Use [nearest neighbour interpolation][8].
-   `cubic`: Use a [Catmull-Rom spline][9].
-   `lanczos2`: Use a [Lanczos kernel][10] with `a=2`.
-   `lanczos3`: Use a Lanczos kernel with `a=3` (the default).

**Parameters**

-   `width` **[Number][11]?** pixels wide the resultant image should be. Use `null` or `undefined` to auto-scale the width to match the height.
-   `height` **[Number][11]?** pixels high the resultant image should be. Use `null` or `undefined` to auto-scale the height to match the width.
-   `options` **[Object][12]?** 
    -   `options.kernel` **[String][13]** the kernel to use for image reduction. (optional, default `'lanczos3'`)
    -   `options.fastShrinkOnLoad` **[Boolean][14]** take greater advantage of the JPEG and WebP shrink-on-load feature, which can lead to a slight moiré pattern on some images. (optional, default `true`)

**Examples**

```javascript
sharp(inputBuffer)
  .resize(200, 300, {
    kernel: sharp.kernel.nearest
  })
  .background('white')
  .embed()
  .toFile('output.tiff')
  .then(function() {
    // output.tiff is a 200 pixels wide and 300 pixels high image
    // containing a nearest-neighbour scaled version, embedded on a white canvas,
    // of the image data in inputBuffer
  });
```

-   Throws **[Error][15]** Invalid parameters

Returns **Sharp** 

## crop

Crop the resized image to the exact size specified, the default behaviour.

Possible attributes of the optional `sharp.gravity` are `north`, `northeast`, `east`, `southeast`, `south`,
`southwest`, `west`, `northwest`, `center` and `centre`.

The experimental strategy-based approach resizes so one dimension is at its target length
then repeatedly ranks edge regions, discarding the edge with the lowest score based on the selected strategy.

-   `entropy`: focus on the region with the highest [Shannon entropy][16].
-   `attention`: focus on the region with the highest luminance frequency, colour saturation and presence of skin tones.

**Parameters**

-   `crop` **[String][13]** A member of `sharp.gravity` to crop to an edge/corner or `sharp.strategy` to crop dynamically. (optional, default `'centre'`)

**Examples**

```javascript
const transformer = sharp()
  .resize(200, 200)
  .crop(sharp.strategy.entropy)
  .on('error', function(err) {
    console.log(err);
  });
// Read image data from readableStream
// Write 200px square auto-cropped image data to writableStream
readableStream.pipe(transformer).pipe(writableStream);
```

-   Throws **[Error][15]** Invalid parameters

Returns **Sharp** 

## embed

Preserving aspect ratio, resize the image to the maximum `width` or `height` specified
then embed on a background of the exact `width` and `height` specified.

If the background contains an alpha value then WebP and PNG format output images will
contain an alpha channel, even when the input image does not.

**Parameters**

-   `embed` **[String][13]** A member of `sharp.gravity` to embed to an edge/corner. (optional, default `'centre'`)

**Examples**

```javascript
sharp('input.gif')
  .resize(200, 300)
  .background({r: 0, g: 0, b: 0, alpha: 0})
  .embed()
  .toFormat(sharp.format.webp)
  .toBuffer(function(err, outputBuffer) {
    if (err) {
      throw err;
    }
    // outputBuffer contains WebP image data of a 200 pixels wide and 300 pixels high
    // containing a scaled version, embedded on a transparent canvas, of input.gif
  });
```

-   Throws **[Error][15]** Invalid parameters

Returns **Sharp** 

## max

Preserving aspect ratio, resize the image to be as large as possible
while ensuring its dimensions are less than or equal to the `width` and `height` specified.

Both `width` and `height` must be provided via `resize` otherwise the behaviour will default to `crop`.

**Examples**

```javascript
sharp(inputBuffer)
  .resize(200, 200)
  .max()
  .toFormat('jpeg')
  .toBuffer()
  .then(function(outputBuffer) {
    // outputBuffer contains JPEG image data no wider than 200 pixels and no higher
    // than 200 pixels regardless of the inputBuffer image dimensions
  });
```

Returns **Sharp** 

## min

Preserving aspect ratio, resize the image to be as small as possible
while ensuring its dimensions are greater than or equal to the `width` and `height` specified.

Both `width` and `height` must be provided via `resize` otherwise the behaviour will default to `crop`.

Returns **Sharp** 

## ignoreAspectRatio

Ignoring the aspect ratio of the input, stretch the image to
the exact `width` and/or `height` provided via `resize`.

Returns **Sharp** 

## withoutEnlargement

Do not enlarge the output image if the input image width _or_ height are already less than the required dimensions.
This is equivalent to GraphicsMagick's `>` geometry option:
"_change the dimensions of the image only if its width or height exceeds the geometry specification_".
Use with `max()` to preserve the image's aspect ratio.

The default behaviour _before_ function call is `false`, meaning the image will be enlarged.

**Parameters**

-   `withoutEnlargement` **[Boolean][14]**  (optional, default `true`)

Returns **Sharp** 

[1]: #resize

[2]: #crop

[3]: #embed

[4]: #max

[5]: #min

[6]: #ignoreaspectratio

[7]: #withoutenlargement

[8]: http://en.wikipedia.org/wiki/Nearest-neighbor_interpolation

[9]: https://en.wikipedia.org/wiki/Centripetal_Catmull%E2%80%93Rom_spline

[10]: https://en.wikipedia.org/wiki/Lanczos_resampling#Lanczos_kernel

[11]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[12]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[13]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[14]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[15]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error

[16]: https://en.wikipedia.org/wiki/Entropy_%28information_theory%29
