<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [cache][1]
-   [concurrency][2]
-   [counters][3]
-   [simd][4]

## cache

Gets or, when options are provided, sets the limits of _libvips'_ operation cache.
Existing entries in the cache will be trimmed after any change in limits.
This method always returns cache statistics,
useful for determining how much working memory is required for a particular task.

**Parameters**

-   `options` **([Object][5] \| [Boolean][6])** Object with the following attributes, or Boolean where true uses default cache settings and false removes all caching (optional, default `true`)
    -   `options.memory` **[Number][7]** is the maximum memory in MB to use for this cache (optional, default `50`)
    -   `options.files` **[Number][7]** is the maximum number of files to hold open (optional, default `20`)
    -   `options.items` **[Number][7]** is the maximum number of operations to cache (optional, default `100`)

**Examples**

```javascript
const stats = sharp.cache();
```

```javascript
sharp.cache( { items: 200 } );
sharp.cache( { files: 0 } );
sharp.cache(false);
```

Returns **[Object][5]** 

## concurrency

Gets or, when a concurrency is provided, sets
the number of threads _libvips'_ should create to process each image.
The default value is the number of CPU cores.
A value of `0` will reset to this default.

The maximum number of images that can be processed in parallel
is limited by libuv's `UV_THREADPOOL_SIZE` environment variable.

This method always returns the current concurrency.

**Parameters**

-   `concurrency` **[Number][7]?** 

**Examples**

```javascript
const threads = sharp.concurrency(); // 4
sharp.concurrency(2); // 2
sharp.concurrency(0); // 4
```

Returns **[Number][7]** concurrency

## counters

Provides access to internal task counters.

-   queue is the number of tasks this module has queued waiting for _libuv_ to provide a worker thread from its pool.
-   process is the number of resize tasks currently being processed.

**Examples**

```javascript
const counters = sharp.counters(); // { queue: 2, process: 4 }
```

Returns **[Object][5]** 

## simd

Get and set use of SIMD vector unit instructions.
Requires libvips to have been compiled with liborc support.

Improves the performance of `resize`, `blur` and `sharpen` operations
by taking advantage of the SIMD vector unit of the CPU, e.g. Intel SSE and ARM NEON.

This feature is currently off by default but future versions may reverse this.
Versions of liborc prior to 0.4.25 are known to segfault under heavy load.

**Parameters**

-   `simd` **[Boolean][6]**  (optional, default `false`)

**Examples**

```javascript
const simd = sharp.simd();
// simd is `true` if SIMD is currently enabled
```

```javascript
const simd = sharp.simd(true);
// attempts to enable the use of SIMD, returning true if available
```

Returns **[Boolean][6]** 

[1]: #cache

[2]: #concurrency

[3]: #counters

[4]: #simd

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number
