/**
 * Checks if `value` is classified as an `Element`.
 * @param value The param to check if it is an Element
 */
export declare function isElement<T>(value: T | Element): value is Element;
/**
 * Checks if `value` is classified as an `HTMLElement`.
 * @param value The param to check if it is an HTMLElement
 */
export declare function isHTMLElement<T>(value: T | HTMLElement): value is HTMLElement;
/**
 * Checks if `value` is classified as a `Function` object.
 * @param value The param to check if it is a function
 */
export declare function isFunction<T>(value: T | Function): value is Function;
/**
 * Checks if `value` is classified as a `String` object.
 * @param value The param to check if it is a string
 */
export declare function isString<T>(value: T | string): value is string;
/**
 * Checks if `value` is undefined.
 * @param value The param to check if it is undefined
 */
export declare function isUndefined<T>(value: T | undefined): value is undefined;
//# sourceMappingURL=type-check.d.ts.map