import { type Tour, type TourOptions } from '../tour.ts';
import { type StepOptionsAttachTo, type Step, type StepOptions } from '../step.ts';
export declare class StepNoOp {
    constructor(_options: StepOptions);
}
export declare class TourNoOp {
    constructor(_tour: Tour, _options: TourOptions);
}
/**
 * Ensure class prefix ends in `-`
 * @param prefix - The prefix to prepend to the class names generated by nano-css
 * @return The prefix ending in `-`
 */
export declare function normalizePrefix(prefix?: string): string;
/**
 * Resolves attachTo options, converting element option value to a qualified HTMLElement.
 * @param step - The step instance
 * @returns {{}|{element, on}}
 * `element` is a qualified HTML Element
 * `on` is a string position value
 */
export declare function parseAttachTo(step: Step): StepOptionsAttachTo;
/**
 * Checks if the step should be centered or not. Does not trigger attachTo.element evaluation, making it a pure
 * alternative for the deprecated step.isCentered() method.
 */
export declare function shouldCenterStep(resolvedAttachToOptions: StepOptionsAttachTo): boolean;
/**
 * Create a unique id for steps, tours, modals, etc
 */
export declare function uuid(): string;
//# sourceMappingURL=general.d.ts.map