<p align="center">
  <img 
    alt="Shepherd.js Logo"
    src="https://i.imgur.com/cowwtSX.png"/>
</p>
  

[![npm version](https://badge.fury.io/js/shepherd.js.svg)](http://badge.fury.io/js/shepherd.js)
![Download count all time](https://img.shields.io/npm/dt/shepherd.js.svg)
![npm](https://img.shields.io/npm/dm/shepherd.js.svg)
[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2Fshipshapecode%2Fshepherd.svg?type=shield)](https://app.fossa.com/projects/git%2Bgithub.com%shepherd-pro%2Fshepherd?ref=badge_shield)
![npm bundle size](https://img.shields.io/bundlephobia/minzip/shepherd.js.svg)
[![Test](https://github.com/shepherd-pro/shepherd/actions/workflows/test.yml/badge.svg)](https://github.com/shepherd-pro/shepherd/actions/workflows/test.yml)
[![Maintainability](https://api.codeclimate.com/v1/badges/b295b0cc0d828ccc1b76/maintainability)](https://codeclimate.com/github/shipshapecode/shepherd/maintainability)
[![Test Coverage](https://api.codeclimate.com/v1/badges/b295b0cc0d828ccc1b76/test_coverage)](https://codeclimate.com/github/shipshapecode/shepherd/test_coverage)
[![StackShare](https://img.shields.io/badge/Follow%20on-StackShare-blue.svg?logo=stackshare&style=flat)](https://stackshare.io/shepherd-js)  


<a href="https://blog.shepherdpro.com/">
  <img 
    src="https://blog.shepherdpro.com/img/demo.png" 
    alt="Guide your users through a tour of your app" 
    style="height: auto; max-width: 800px; width: 100%;"/>
</a>

Browsers support
----------------------------------------------------------

| [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/edge/edge_48x48.png" alt="IE / Edge" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Edge | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/firefox/firefox_48x48.png" alt="Firefox" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Firefox | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/chrome/chrome_48x48.png" alt="Chrome" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Chrome | [<img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/safari/safari_48x48.png" alt="Safari" width="24px" height="24px" />](http://godban.github.io/browsers-support-badges/)</br>Safari |
| --------- | --------- | --------- | --------- |
| Edge| last 2 versions| last 2 versions| last 2 versions


## Documentation

[API documentation](https://docs.shepherdpro.com/)

## Demo

[Demo](https://shepherdjs.dev/demo)

## Contributing

We encourage contributions of all kinds. If you would like to contribute in some way, please review our [guidelines for contributing](CONTRIBUTING.md).

## Releasing

Our release process is mostly automated. For more details, see [RELEASE.md](RELEASE.md).

## License
[MIT License](LICENSE.md)

## Projects Using Shepherd

Here we showcase some of the awesome libraries built using Shepherd.

### JS Framework Wrappers

### [ember-shepherd](https://github.com/shepherd-pro/ember-shepherd)

Ember addon for the site tour library Shepherd

### [angular-shepherd](https://github.com/shepherd-pro/angular-shepherd)

An Angular wrapper for the site tour library Shepherd

### [react-shepherd](https://github.com/shepherd-pro/react-shepherd)

A React wrapper for the site tour library Shepherd

### [vue-shepherd](https://github.com/shepherd-pro/vue-shepherd)

A Vue wrapper for the site tour library Shepherd

### Rails gems

### [abraham](https://github.com/actmd/abraham)

Rails engine that generates and tracks Shepherd tours within an application

### Websites and Apps

### [Shepherd Pro](https://shepherdpro.com/)

[Shepherd Pro](https://shepherdpro.com/) allows you to use the same JS library and add enhanced analytics to your tours while letting you also connect some integrations to deepen the knowledge and effectiveness of those user experiences. 

### [SimplePlanner](https://simpleplanner.io)

[SimplePlanner](https://simpleplanner.io) uses Shepherd to help new users get familiar with its collaborative scheduling approach. 
You do need to sign up via OAuth or email to see the scheduling tour. 
Check out the [Envato Tuts+ Startup Series on its codebase](https://code.tutsplus.com/series/building-your-startup-with-php--cms-742) which describes how Simple Planner was built.

### [LogSeq](https://logseq.com/) 

[LogSeq](https://logseq.com/) uses Shepherd to guide users through initial setup steps.

### [Snapsure](https://snapsure.app)

[Snapsure](https://snapsure.app) uses Shepherd to help photographers learn how to set up alerts for their desired picture-perfect weather conditions.


### [Drupal](https://www.drupal.org/docs/8/core/modules/tour/overview)

The [Drupal](https://www.drupal.org/docs/8/core/modules/tour/overview) CMS uses Shepherd to offer tours of it's core modules, and allows developers to add Tours to their custom and contributed modules.

### [Budibase Shepherd Tour Plugin](https://github.com/JayP718/tour_shepherd_bb_plugin)

[Budibase](https://budibase.com/) is an open source application which allows you develop low code applications rapidly and efficiently.This [Budibase](https://budibase.com/) Shepherd tour plugin allows you to create interative walkthroughs for your application.


### Your Project Here

If you have a cool open-source library built on Shepherd, PR this doc.


## License
[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2Fshipshapecode%2Fshepherd.svg?type=large)](https://app.fossa.com/projects/git%2Bgithub.com%2Fshipshapecode%2Fshepherd?ref=badge_large)
