# Contributing to Shoelace.css

I'm building Shoelace for the greater good. I want everyone to have a chance to participate in its development no matter their skill level, and nobody should feel out of place for asking a question, submitting their code, etc.

That said, I have a few simple rules I'm asking everyone to follow:

- Don't be mean.
- Don't be a troll.
- Don't be a keyboard warrior.

People from all over the world participate here, and everyone is welcome. Please bear in mind that not all people share the same languages, skills, and beliefs as you. Many are here to learn, so please facilitate that.

## Support

**Please do not use the issue tracker for personal support requests.**

Instead, post a question with the `shoelacecss` tag on [Stack Overflow](https://stackoverflow.com/tags/shoelacecss).

## Bug Reports

Bugs should be submitted to the issue tracker. Before creating a new issue, please search open and closed issues to make sure it hasn't already been addressed.

For bug reports, please provide:

- Step-by-step instructions to reproduce the bug.
- A minimal test case to demonstrate the bug (if applicable).
- Affected version of Shoelace (please try to test on the latest version)

A good bug report will show us how to reproduce the problem quickly. A not-so-good bug report is likely to sit around waiting for additional feedback before anything can get fixed.

## Feature Requests

Feature requests may be submitted to the issue tracker as well. Before creating a new issue, please search open and close issues to make sure it hasn't already been requested.

To vote for a specific feature, use GitHub reactions to 👍 or 👎. Remember that you can watch an issue to receive notifications anytime somebody comments.

## Pull Requests

Before embarking on a large, complex, or controversial feature, please open an issue so we can discuss it. Someone may be working on it already, it might not align with the project's roadmap, or we might be able to improve on your idea before you spend a lot of time working on it.

If your PR doesn't get accepted, don't let it get you down. Many don't. It doesn't mean I don't value your idea or contribution, it just means that it doesn't align with my vision for the project. As the maintainer, I'll do my best to explain why every PR doesn't get accepted.

### Code Quality

Shoelace uses an `.editorconfig` file to enforce things like indentation, trailing whitespace, etc. Please make sure your editor supports [EditorConfig]((http://editorconfig.org/)) before submitting a PR.

I'm quite picky about code quality. That doesn't mean I don't like your code, it means I prefer the code to stay consistent. If you follow the same conventions as the rest of the project's code, you'll be good to go.
