---
layout: default.html
title: Badges
description: Add badges to your app with minimal effort.
---

## Badges

Create a badge by applying the `badge` class to an element such as a `<span>`.

```html
<span class="badge">Badge</span>
```

<span class="badge">Badge</span>

By default, badges are sized relative to their parent element.

```html
<h1>Heading 1 <span class="badge">Badge</span></h1>
<h2>Heading 2 <span class="badge">Badge</span></h2>
<h3>Heading 3 <span class="badge">Badge</span></h3>
<p>Paragraph <span class="badge">Badge</span></p>
```

<h1>Heading 1 <span class="badge">Badge</span></h1>
<h2>Heading 2 <span class="badge">Badge</span></h2>
<h3>Heading 3 <span class="badge">Badge</span></h3>
<p>Paragraph <span class="badge">Badge</span></p>

### Variations

Use the `badge-*` modifier to create variations.

```html
<span class="badge">Primary</span>
<span class="badge badge-secondary">Secondary</span>
<span class="badge badge-success">Success</span>
<span class="badge badge-info">Info</span>
<span class="badge badge-warning">Warning</span>
<span class="badge badge-danger">Danger</span>
<span class="badge badge-light">Light</span>
<span class="badge badge-dark">Dark</span>
```

<span class="badge">Primary</span>
<span class="badge badge-secondary">Secondary</span>
<span class="badge badge-success">Success</span>
<span class="badge badge-info">Info</span>
<span class="badge badge-warning">Warning</span>
<span class="badge badge-danger">Danger</span>
<span class="badge badge-light">Light</span>
<span class="badge badge-dark">Dark</span>

### Badge Links

Badges can also be made into links.

```html
<a href="#" class="badge">Primary</a>
<a href="#" class="badge badge-secondary">Secondary</a>
<a href="#" class="badge badge-success">Success</a>
<a href="#" class="badge badge-info">Info</a>
<a href="#" class="badge badge-warning">Warning</a>
<a href="#" class="badge badge-danger">Danger</a>
<a href="#" class="badge badge-light">Light</a>
<a href="#" class="badge badge-dark">Dark</a>
```

<a href="#" class="badge">Primary</a>
<a href="#" class="badge badge-secondary">Secondary</a>
<a href="#" class="badge badge-success">Success</a>
<a href="#" class="badge badge-info">Info</a>
<a href="#" class="badge badge-warning">Warning</a>
<a href="#" class="badge badge-danger">Danger</a>
<a href="#" class="badge badge-light">Light</a>
<a href="#" class="badge badge-dark">Dark</a>
