---
layout: default.html
title: Browser Support
description: Shoelace works in just about every browser.
---

## Browser Support

You can use Shoelace _today_ in just about every browser. If you’re using the [CDN version](installing.html#cdn) for prototyping, you’re good. If you’re [building from source](installing.html#building-from-source), you’re good.

<div class="browsers">
  ![Chrome](../source/img/chrome.svg)
  ![Edge](../source/img/edge.svg)
  ![Firefox](../source/img/firefox.svg)
  ![Opera](../source/img/opera.svg)
  ![Safari](../source/img/safari.png)
</div>

_What you can’t do_ is use the source files without processing them with [cssnext](http://cssnext.io/).

Shoelace makes extensive use of future CSS features in its source. Most browsers don’t support this syntax today, but they will soon. As CSS evolves and support improves, you’ll eventually be able to use Shoelace without any processing at all. In that sense, Shoelace is “future-ready.”

[CSS has a really bright future](http://cssnext.io/features/), and you can use most of its upcoming features today with Shoelace + cssnext. You no longer need Less or Sass to do amazing things with CSS.

I believe we should focus on the future. Preprocessors had a place when the evolution of CSS seemed stagnant, but things have changed and it’s time to move forward. Instead of learning a different syntax, let’s just learn the _future syntax_.

Unfortunately, many people aren’t aware of the great things happening with CSS these days. Shoelace aims to raise awareness by bringing us back to the basics and using tomorrow’s CSS today.
