---
layout: default.html
title: Content
description: Default content styles.
---

## Content

Shoelace provides default content styles that are easy to customize. You don’t need to apply any classes to achieve these styles — just use the appropriate tags.

For easy spacing, Shoelace removes top margins and applies a bottom margin to block elements. By default, text sizing and spacing is measured in `rem` units. Shoelace also sets `box-sizing: border-box` globally to make it easier to properly size elements.

### Headings `<h1> – <h6>`

<h1>Heading 1</h1>
<h2>Heading 2</h2>
<h3>Heading 3</h3>
<h4>Heading 4</h4>
<h5>Heading 5</h5>
<h6>Heading 6</h6>

### Paragraphs `<p>`

Lorem ipsum dolor sit amet, consectetur adipisicing elit. Quaerat excepturi repellendus nostrum dolorum dignissimos quis non, minus debitis laborum vero cupiditate sequi neque, magnam dolore nemo possimus, soluta ducimus eaque.

Blanditiis ea qui, veritatis animi recusandae praesentium magnam. Commodi placeat, laboriosam accusamus laudantium quasi eveniet soluta illo ducimus quis doloremque mollitia, officia pariatur deleniti reprehenderit, maxime, dicta libero vero cum.

### Horizontal Rules `<hr>`

---

### Ordered Lists `<ol>`

1. List item 1
2. List item 2
    1. Nested item 1
    2. Nested item 2
    3. Nested item 3
3. List item 3

### Unordered Lists `<ul>`

- List item 1
- List item 2
    - Nested item 1
    - Nested item 2
    - Nested item 3
- List item 3

### Definition Lists `<dl>`

<dl>
  <dt>Term 1</dt>
  <dd>
    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Earum autem perferendis
    exercitationem asperiores fuga incidunt, nam dicta amet. Dolor eligendi nisi praesentium
    placeat officiis esse corporis molestiae. Doloremque accusamus, vel!
  </dd>
  <dt>Term 2</dt>
  <dd>
    Veritatis repellendus porro ipsam beatae temporibus natus id adipisci nobis accusantium
    quidem eum fugit cupiditate deleniti nisi nesciunt dicta officia, enim, atque corporis neque
    error. Unde saepe molestiae hic voluptatibus?
  </dd>
</dl>

### Blockquotes `<blockquote>`

<blockquote>
  Lorem ipsum dolor sit amet, consectetur adipisicing elit. Mollitia ipsam enim reprehenderit placeat ab voluptate totam suscipit voluptas, culpa pariatur eos quas, sequi unde perferendis officiis! Officiis eligendi eaque facilis.
</blockquote>

### Preformatted Text `<pre>`

```
CLS
SCREEN 13
PRINT "SHOELACE IS AWESOME"
```

### Text Formats

<table class="table">
  <thead>
    <tr>
      <th>Element</th>
      <th>Example</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>`<strong>`</td>
      <td><strong>This is strong text</strong></td>
    </tr>
    <tr>
      <td>`<em>`</td>
      <td><em>This is emphasized text</em></td>
    </tr>
    <tr>
      <td>`<u>`</td>
      <td><u>This is underlined text</u></td>
    </tr>
    <tr>
      <td>`<s>`</td>
      <td><s>This is strikethrough text</s></td>
    </tr>
    <tr>
      <td>`<a>`</td>
      <td><a href="#">This is link text</a></td>
    </tr>
    <tr>
      <td>`<small>`</td>
      <td><small>This is small text</small></td>
    </tr>
    <tr>
      <td>`<sup>`</td>
      <td><sup>This is superscript text</sup></td>
    </tr>
    <tr>
      <td>`<sub>`</td>
      <td><sub>This is subscript text</sub></td>
    </tr>
    <tr>
      <td>`<code>`</td>
      <td>`This is code text`</td>
    </tr>
    <tr>
      <td>`<samp>`</td>
      <td><samp>This is sample text</samp></td>
    </tr>
    <tr>
      <td>`<var>`</td>
      <td><var>This is variable text</var></td>
    </tr>
    <tr>
      <td>`<kbd>`</td>
      <td><kbd>This is keyboard text</kbd></td>
    </tr>
    <tr>
      <td>`<abbr>`</td>
      <td><abbr title="Abbreviation">This is abbreviation text</abbr></td>
    </tr>
    <tr>
      <td>`<del>`</td>
      <td><del>This is deleted text</del></td>
    </tr>
    <tr>
      <td>`<ins>`</td>
      <td><ins>This is inserted text</ins></td>
    </tr>
    <tr>
      <td>`<mark>`</td>
      <td><mark>This is marked text</mark></td>
    </tr>
  </tbody>
</table>
