---
layout: default.html
title: Tables
description: Shoelace ships with elegant table styles and a handful of modifiers.
---

## Tables

Tables are styled for you automatically — no special classes required.

```html
<table>
  <thead>
    <tr><th>Item</th><th>Price</th></tr>
  </thead>
  <tbody>
    <tr><td>Shoe Freshener</td><td>$4.79</td></tr>
    <tr><td>Shoe Glue</td><td>$2.50</td></tr>
    <tr><td>Shoe Polish</td><td>$5.25</td></tr>
    <tr><td>Shoelaces</td><td>$3.99</td></tr>
  </tbody>
</table>
```

<table>
  <thead>
    <tr><th>Item</th><th>Price</th></tr>
  </thead>
  <tbody>
    <tr><td>Shoe Freshener</td><td>$4.79</td></tr>
    <tr><td>Shoe Glue</td><td>$2.50</td></tr>
    <tr><td>Shoe Polish</td><td>$5.25</td></tr>
    <tr><td>Shoelaces</td><td>$3.99</td></tr>
  </tbody>
</table>

### Striped Tables

Use the `table-striped` modifier to add stripes to alternating rows.

```html
<table class="table-striped">
  ...
</table>
```

<table class="table-striped">
  <thead>
    <tr><th>Item</th><th>Price</th></tr>
  </thead>
  <tbody>
    <tr><td>Shoe Freshener</td><td>$4.79</td></tr>
    <tr><td>Shoe Glue</td><td>$2.50</td></tr>
    <tr><td>Shoe Polish</td><td>$5.25</td></tr>
    <tr><td>Shoelaces</td><td>$3.99</td></tr>
  </tbody>
</table>

### Bordered Tables

Use the `table-bordered` modifier to add a border to the table.

```html
<table class="table-bordered">
  ...
</table>
```

<table class="table-bordered">
  <thead>
    <tr><th>Item</th><th>Price</th></tr>
  </thead>
  <tbody>
    <tr><td>Shoe Freshener</td><td>$4.79</td></tr>
    <tr><td>Shoe Glue</td><td>$2.50</td></tr>
    <tr><td>Shoe Polish</td><td>$5.25</td></tr>
    <tr><td>Shoelaces</td><td>$3.99</td></tr>
  </tbody>
</table>

### Hoverable Rows

Use the `table-hoverable` modifier to enable the hover state on table rows.

```html
<table class="table-hoverable">
  ...
</table>
```

<table class="table-hoverable">
  <thead>
    <tr><th>Item</th><th>Price</th></tr>
  </thead>
  <tbody>
    <tr><td>Shoe Freshener</td><td>$4.79</td></tr>
    <tr><td>Shoe Glue</td><td>$2.50</td></tr>
    <tr><td>Shoe Polish</td><td>$5.25</td></tr>
    <tr><td>Shoelaces</td><td>$3.99</td></tr>
  </tbody>
</table>
