'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-4989b356.js');

const alertCss = ":host{position:relative;box-sizing:border-box}:host *,:host *:before,:host *:after{box-sizing:inherit}:host{display:contents;margin:0}.alert{position:relative;display:flex;align-items:stretch;background-color:var(--sl-color-white);border:solid 1px var(--sl-color-gray-90);border-top-width:3px;border-radius:var(--sl-border-radius-medium);box-shadow:var(--box-shadow);font-family:var(--sl-font-sans);font-size:var(--sl-font-size-small);font-weight:var(--sl-font-weight-normal);line-height:1.6;color:var(--sl-color-gray-30);opacity:0;transform:scale(0.9);transition:var(--sl-transition-medium) opacity ease, var(--sl-transition-medium) transform ease;margin:inherit}.alert:not(.alert--visible){position:absolute;width:1px;height:1px;clip:rect(0 0 0 0);clip-path:inset(50%);overflow:hidden;pointer-events:none;visibility:hidden}.alert--open{opacity:1;transform:scale(1)}.alert__icon{flex:0 0 auto;display:flex;align-items:center;font-size:var(--sl-font-size-large)}.alert__icon ::slotted(*){margin-left:var(--sl-spacing-large)}.alert--primary{border-top-color:var(--sl-color-primary-50)}.alert--primary .alert__icon{color:var(--sl-color-primary-50)}.alert--success{border-top-color:var(--sl-color-success-50)}.alert--success .alert__icon{color:var(--sl-color-success-50)}.alert--info{border-top-color:var(--sl-color-info-50)}.alert--info .alert__icon{color:var(--sl-color-info-50)}.alert--warning{border-top-color:var(--sl-color-warning-50)}.alert--warning .alert__icon{color:var(--sl-color-warning-50)}.alert--danger{border-top-color:var(--sl-color-danger-50)}.alert--danger .alert__icon{color:var(--sl-color-danger-50)}.alert__message{flex:1 1 auto;padding:var(--sl-spacing-large);overflow:hidden}.alert__close{flex:0 0 auto;display:flex;align-items:center;font-size:var(--sl-font-size-large);padding-right:var(--sl-spacing-medium)}";

const toastStack = Object.assign(document.createElement('div'), { className: 'sl-toast-stack' });
const Alert = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    this.slShow = index.createEvent(this, "sl-show", 7);
    this.slAfterShow = index.createEvent(this, "sl-after-show", 7);
    this.slHide = index.createEvent(this, "sl-hide", 7);
    this.slAfterHide = index.createEvent(this, "sl-after-hide", 7);
    this.isVisible = false;
    /** Indicates whether or not the alert is open. You can use this in lieu of the show/hide methods. */
    this.open = false;
    /** Set to true to make the alert closable. */
    this.closable = false;
    /** The type of alert. */
    this.type = 'primary';
    /**
     * The length of time, in milliseconds, the alert will show before closing itself. If the user interacts with the
     * alert before it closes (e.g. moves the mouse over it), the timer will restart.
     */
    this.duration = Infinity;
  }
  handleOpenChange() {
    this.open ? this.show() : this.hide();
  }
  handleDurationChange() {
    this.restartAutoHide();
  }
  connectedCallback() {
    this.handleCloseClick = this.handleCloseClick.bind(this);
    this.handleMouseMove = this.handleMouseMove.bind(this);
    this.handleTransitionEnd = this.handleTransitionEnd.bind(this);
  }
  componentDidLoad() {
    // Show on init if open
    if (this.open) {
      this.show();
    }
  }
  /** Shows the alert. */
  async show() {
    // Prevent subsequent calls to the method, whether manually or triggered by the `open` watcher
    if (this.isVisible) {
      return;
    }
    const slShow = this.slShow.emit();
    if (slShow.defaultPrevented) {
      this.open = false;
      return;
    }
    this.isVisible = true;
    this.open = true;
    if (this.duration < Infinity) {
      this.autoHideTimeout = setTimeout(() => this.hide(), this.duration);
    }
  }
  /** Hides the alert */
  async hide() {
    // Prevent subsequent calls to the method, whether manually or triggered by the `open` watcher
    if (!this.isVisible) {
      return;
    }
    const slHide = this.slHide.emit();
    if (slHide.defaultPrevented) {
      this.open = true;
      return;
    }
    clearTimeout(this.autoHideTimeout);
    this.open = false;
  }
  /**
   * Displays the alert as a toast notification. This will move the alert out of its position in the DOM and, when
   * dismissed, it will be removed from the DOM completely. By storing a reference to the alert, you can reuse it by
   * calling this method again. The returned promise will resolve after the alert is hidden.
   */
  async toast() {
    return new Promise(resolve => {
      if (!toastStack.parentElement) {
        document.body.append(toastStack);
      }
      toastStack.append(this.host);
      requestAnimationFrame(() => this.show());
      this.host.addEventListener('sl-after-hide', () => {
        this.host.remove();
        resolve();
        // Remove the toast stack from the DOM when there are no more alerts
        if (toastStack.querySelector('sl-alert') === null) {
          toastStack.remove();
        }
      }, { once: true });
    });
  }
  handleCloseClick() {
    this.hide();
  }
  handleMouseMove() {
    this.restartAutoHide();
  }
  handleTransitionEnd(event) {
    const target = event.target;
    // Ensure we only emit one event when the target element is no longer visible
    if (event.propertyName === 'opacity' && target.classList.contains('alert')) {
      this.isVisible = this.open;
      this.open ? this.slAfterShow.emit() : this.slAfterHide.emit();
    }
  }
  restartAutoHide() {
    clearTimeout(this.autoHideTimeout);
    if (this.open && this.duration < Infinity) {
      this.autoHideTimeout = setTimeout(() => this.hide(), this.duration);
    }
  }
  render() {
    return (index.h("div", { ref: el => (this.alert = el), part: "base", class: {
        alert: true,
        'alert--open': this.open,
        'alert--visible': this.isVisible,
        'alert--closable': this.closable,
        'alert--primary': this.type === 'primary',
        'alert--success': this.type === 'success',
        'alert--info': this.type === 'info',
        'alert--warning': this.type === 'warning',
        'alert--danger': this.type === 'danger'
      }, role: "alert", "aria-live": "assertive", "aria-atomic": "true", "aria-hidden": !this.open, onMouseMove: this.handleMouseMove, onTransitionEnd: this.handleTransitionEnd }, index.h("span", { part: "icon", class: "alert__icon" }, index.h("slot", { name: "icon" })), index.h("span", { part: "message", class: "alert__message" }, index.h("slot", null)), this.closable && (index.h("span", { class: "alert__close" }, index.h("sl-icon-button", { part: "close-button", name: "x", onClick: this.handleCloseClick })))));
  }
  get host() { return index.getElement(this); }
  static get watchers() { return {
    "open": ["handleOpenChange"],
    "duration": ["handleDurationChange"]
  }; }
};
Alert.style = alertCss;

exports.sl_alert = Alert;
