'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-4989b356.js');

const includeFiles = new Map();
const requestInclude = async (src, mode = 'cors') => {
  if (includeFiles.has(src)) {
    return includeFiles.get(src);
  }
  else {
    const request = fetch(src, { mode: mode }).then(async (response) => {
      return {
        ok: response.ok,
        status: response.status,
        html: await response.text()
      };
    });
    includeFiles.set(src, request);
    return request;
  }
};

const includeCss = ":host{display:block}";

const Include = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    this.slLoad = index.createEvent(this, "sl-load", 7);
    this.slError = index.createEvent(this, "sl-error", 7);
    this.html = '';
    /** The fetch mode to use. */
    this.mode = 'cors';
  }
  handleSrcChange() {
    this.loadSource();
  }
  componentWillLoad() {
    this.loadSource();
  }
  async loadSource() {
    try {
      const src = this.src;
      const file = await requestInclude(src, this.mode);
      // If the src changed since the request started do nothing, otherwise we risk overwriting a subsequent response
      if (src !== this.src) {
        return;
      }
      if (!file.ok) {
        this.slError.emit({ status: file.status });
        return;
      }
      this.host.innerHTML = file.html;
      this.slLoad.emit();
    }
    catch (_a) {
      this.slError.emit();
    }
  }
  render() {
    return index.h("slot", null);
  }
  get host() { return index.getElement(this); }
  static get watchers() { return {
    "src": ["handleSrcChange"]
  }; }
};
Include.style = includeCss;

exports.sl_include = Include;
