'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-4989b356.js');
const slot = require('./slot-44b375db.js');
const ResizeObserver_es = require('./ResizeObserver.es-646489f6.js');

const selectCss = ":host{position:relative;box-sizing:border-box}:host *,:host *:before,:host *:after{box-sizing:inherit}.form-control .label{display:none}.form-control--has-label .label{display:inline-block;color:var(--sl-input-label-color);margin-bottom:var(--sl-spacing-xxx-small)}.form-control--has-label .label.label--small{font-size:var(--sl-input-label-font-size-small)}.form-control--has-label .label.label--medium{font-size:var(--sl-input-label-font-size-medium)}.form-control--has-label .label.label--large{font-size:var(--sl-input-label-font-size-large)}.form-control--has-label .label.label--valid{color:var(--sl-input-label-color-valid)}.form-control--has-label .label.label--invalid{color:var(--sl-input-label-color-invalid)}.help-text{color:var(--sl-input-help-text-color)}.help-text.help-text--small{font-size:var(--sl-input-help-text-font-size-small)}.help-text.help-text--medium{font-size:var(--sl-input-help-text-font-size-medium)}.help-text.help-text--large{font-size:var(--sl-input-help-text-font-size-large)}.help-text.help-text--valid{color:var(--sl-input-help-text-color-valid)}.help-text.help-text--invalid{color:var(--sl-input-help-text-color-invalid)}.help-text ::slotted(*){margin-top:var(--sl-spacing-xxx-small)}:host{display:block}.select{width:100%}.select__input{flex:1 1 auto;width:100%}.select__input:not([disabled])::part(base){cursor:pointer}.select__input::part(input){caret-color:transparent}.select__input span[slot=prefix]{margin-left:var(--sl-spacing-xx-small)}.select__input span[slot=prefix] sl-tag:not(:last-of-type){margin-right:var(--sl-spacing-xx-small)}.select__icon{display:inline-flex}.select__icon sl-icon{transition:var(--sl-transition-medium) transform ease}.select--open .select__icon sl-icon{transform:rotate(-180deg)}.select:not(.select--empty) .select__input::part(clear-button){visibility:visible}.select--multiple .select__input::part(input){flex:1 1 0}.select--multiple .select__input::part(prefix){scrollbar-width:none;-ms-overflow-style:none;flex-shrink:1;overflow-x:auto;white-space:nowrap}.select--multiple .select__input::part(prefix)::-webkit-scrollbar{width:0;height:0}.select--multiple .select__input::part(clear-button),.select--multiple .select__input::part(suffix){padding-left:var(--sl-spacing-x-small)}.select--multiple.select--has-tags .select__input::part(input){margin:0}";

let id = 0;
const Select = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    this.slChange = index.createEvent(this, "sl-change", 7);
    this.slFocus = index.createEvent(this, "sl-focus", 7);
    this.slBlur = index.createEvent(this, "sl-blur", 7);
    this.inputId = `select-${++id}`;
    this.labelId = `select-label-${id}`;
    this.helpTextId = `select-help-text-${id}`;
    this.hasFocus = false;
    this.hasLabel = false;
    this.isOpen = false;
    this.items = [];
    this.displayLabel = '';
    this.displayTags = [];
    /** Set to true to enable multiselect. */
    this.multiple = false;
    /**
     * The maximum number of tags to show when `multiple` is true. After the maximum, "+n" will be shown to indicate the
     * number of additional items that are selected. Set to -1 to remove the limit.
     */
    this.maxTagsVisible = 3;
    /** Set to true to disable the select control. */
    this.disabled = false;
    /** The select's name. */
    this.name = '';
    /** The select's placeholder text. */
    this.placeholder = '';
    /** The select's size. */
    this.size = 'medium';
    /**
     * Enable this option to prevent the panel from being clipped when the component is placed inside a container with
     * `overflow: auto|scroll`.
     */
    this.hoist = false;
    /** The value of the control. This will be a string or an array depending on `multiple`. */
    this.value = '';
    /** Set to true to draw a pill-style select with rounded edges. */
    this.pill = false;
    /** The select's label. */
    this.label = '';
    /** The select's required attribute. */
    this.required = false;
    /** Set to true to add a clear button when the select is populated. */
    this.clearable = false;
    /** This will be true when the control is in an invalid state. Validity is determined by the `required` prop. */
    this.invalid = false;
  }
  handleLabelChange() {
    this.detectLabel();
  }
  handleMultipleChange() {
    // Cast to array | string based on `this.multiple`
    const value = this.getValueAsArray();
    this.value = this.multiple ? value : value[0] || '';
    this.syncItemsFromValue();
  }
  handleValueChange() {
    this.syncItemsFromValue();
    this.slChange.emit();
  }
  connectedCallback() {
    this.detectLabel = this.detectLabel.bind(this);
    this.handleBlur = this.handleBlur.bind(this);
    this.handleFocus = this.handleFocus.bind(this);
    this.handleClear = this.handleClear.bind(this);
    this.handleCut = this.handleCut.bind(this);
    this.handlePaste = this.handlePaste.bind(this);
    this.handleKeyDown = this.handleKeyDown.bind(this);
    this.handleKeyUp = this.handleKeyUp.bind(this);
    this.handleLabelClick = this.handleLabelClick.bind(this);
    this.handleTagClick = this.handleTagClick.bind(this);
    this.handleTagKeyDown = this.handleTagKeyDown.bind(this);
    this.handleMenuHide = this.handleMenuHide.bind(this);
    this.handleMenuShow = this.handleMenuShow.bind(this);
    this.handleMenuSelect = this.handleMenuSelect.bind(this);
    this.handleSlotChange = this.handleSlotChange.bind(this);
  }
  componentWillLoad() {
    this.detectLabel();
  }
  componentDidLoad() {
    this.resizeObserver = new ResizeObserver_es.index(() => this.resizeMenu());
    this.reportDuplicateItemValues();
    // We need to do an initial sync after the component has rendered, so this will suppress the re-render warning
    requestAnimationFrame(() => this.syncItemsFromValue());
  }
  /** Checks for validity and shows the browser's validation message if the control is invalid. */
  async reportValidity() {
    return this.input.reportValidity();
  }
  /** Sets a custom validation message. If `message` is not empty, the field will be considered invalid. */
  async setCustomValidity(message) {
    this.input.setCustomValidity(message);
  }
  detectLabel() {
    this.hasLabel = this.label.length > 0 || slot.hasSlot(this.host, 'label');
  }
  getItemLabel(item) {
    const slot$1 = item.shadowRoot.querySelector('slot:not([name])');
    return slot.getTextContent(slot$1);
  }
  getItems() {
    return [...this.host.querySelectorAll('sl-menu-item')];
  }
  getValueAsArray() {
    return Array.isArray(this.value) ? this.value : [this.value];
  }
  handleBlur(event) {
    event.stopPropagation();
    this.hasFocus = false;
    this.slBlur.emit();
  }
  handleFocus(event) {
    event.stopPropagation();
    this.hasFocus = true;
    this.slFocus.emit();
    this.input.setSelectionRange(0, 0);
  }
  handleClear() {
    this.value = this.multiple ? [] : '';
    this.syncItemsFromValue();
    this.dropdown.hide();
  }
  handleKeyDown() {
    // We can't make the <sl-input> readonly since that will block the browser's validation messages, so this prevents
    // key presses from modifying the input's value by briefly making it readonly. We don't use `preventDefault()` since
    // that would block tabbing, shortcuts, etc.
    const nativeInput = this.input.shadowRoot.querySelector('[part="input"]');
    nativeInput.readOnly = true;
  }
  handleKeyUp() {
    const nativeInput = this.input.shadowRoot.querySelector('[part="input"]');
    nativeInput.readOnly = false;
  }
  handleCut(event) {
    event.preventDefault();
  }
  handlePaste(event) {
    event.preventDefault();
  }
  handleLabelClick() {
    this.input.setFocus();
  }
  handleMenuSelect(event) {
    const item = event.detail.item;
    if (this.multiple) {
      this.value = this.value.includes(item.value)
        ? this.value.filter(v => v !== item.value)
        : [...this.value, item.value];
    }
    else {
      this.value = item.value;
    }
    this.syncItemsFromValue();
  }
  handleMenuShow(event) {
    if (this.disabled) {
      event.preventDefault();
      return;
    }
    this.resizeMenu();
    this.resizeObserver.observe(this.host);
    this.isOpen = true;
  }
  handleMenuHide() {
    this.resizeObserver.unobserve(this.host);
    this.isOpen = false;
    this.input.setFocus();
  }
  handleSlotChange() {
    this.syncItemsFromValue();
    this.reportDuplicateItemValues();
  }
  handleTagClick(event) {
    // Don't toggle the menu when a tag's clear button is activated
    const path = event.composedPath();
    const clearButton = path.find(el => {
      if (el instanceof HTMLElement) {
        const element = el;
        return element.getAttribute('part') === 'clear-button';
      }
    });
    if (clearButton) {
      event.stopPropagation();
    }
  }
  handleTagKeyDown(event) {
    if (event.key === 'Enter') {
      event.stopPropagation();
    }
  }
  reportDuplicateItemValues() {
    const items = this.getItems();
    // Report duplicate values since they can break selection logic
    const duplicateValues = items.map(item => item.value).filter((e, i, a) => a.indexOf(e) !== i);
    if (duplicateValues.length) {
      throw new Error('Duplicate value found on <sl-menu-item> in <sl-select>: "' + duplicateValues.join('", "') + '"');
    }
  }
  resizeMenu() {
    this.menu.style.width = `${this.input.clientWidth}px`;
  }
  syncItemsFromValue() {
    const items = this.getItems();
    const value = this.getValueAsArray();
    // Sync checked states
    items.map(item => (item.checked = value.includes(item.value)));
    // Sync display label
    if (this.multiple) {
      const checkedItems = [];
      value.map(val => items.map(item => (item.value === val ? checkedItems.push(item) : null)));
      this.displayTags = checkedItems.map(item => {
        return (index.h("sl-tag", { exportparts: "base:tag", type: "info", size: this.size, pill: this.pill, clearable: true, onClick: this.handleTagClick, onKeyDown: this.handleTagKeyDown, "onSl-clear": event => {
            event.stopPropagation();
            item.checked = false;
            this.syncValueFromItems();
          } }, this.getItemLabel(item)));
      });
      if (this.maxTagsVisible > 0 && this.displayTags.length > this.maxTagsVisible) {
        const total = this.displayTags.length;
        this.displayTags = this.displayTags.slice(0, this.maxTagsVisible);
        this.displayTags.push(index.h("sl-tag", { exportparts: "base:tag", type: "info", size: this.size }, "+", total - this.maxTagsVisible));
      }
      // With `multiple`, the input uses the display label as its value. If no selection is made, we set it to an empty
      // string. If items are selected, we use a zero-width space so `required` validation doesn't fail, but nothing is
      // drawn in the label either. This is a bit ugly, but it gets the job done.
      this.displayLabel = this.value.length === 0 ? '' : '\u200B';
    }
    else {
      const checkedItem = items.filter(item => item.value === value[0])[0];
      this.displayLabel = checkedItem ? this.getItemLabel(checkedItem) : '';
      this.displayTags = [];
    }
  }
  syncValueFromItems() {
    const items = this.getItems();
    const checkedItems = items.filter(item => item.checked);
    const checkedValues = checkedItems.map(item => item.value);
    if (this.multiple) {
      this.value = this.value.filter(val => checkedValues.includes(val));
    }
    else {
      this.value = checkedValues.length > 0 ? checkedValues[0] : '';
    }
  }
  render() {
    var _a;
    return (index.h("div", { part: "form-control", class: {
        'form-control': true,
        'form-control--has-label': this.hasLabel,
        'form-control--invalid': this.invalid
      } }, index.h("label", { part: "label", id: this.labelId, class: {
        label: true,
        'label--small': this.size === 'small',
        'label--medium': this.size === 'medium',
        'label--large': this.size === 'large',
        'label--invalid': this.invalid
      }, htmlFor: this.inputId, onClick: this.handleLabelClick }, index.h("slot", { name: "label", onSlotchange: this.detectLabel }, this.label)), index.h("sl-dropdown", { part: "base", ref: el => (this.dropdown = el), hoist: this.hoist, closeOnSelect: !this.multiple, containingElement: this.host, class: {
        select: true,
        'select--open': this.isOpen,
        'select--empty': ((_a = this.value) === null || _a === void 0 ? void 0 : _a.length) === 0,
        'select--focused': this.hasFocus,
        'select--disabled': this.disabled,
        'select--multiple': this.multiple,
        'select--has-tags': this.multiple && this.displayTags.length > 0,
        'select--small': this.size === 'small',
        'select--medium': this.size === 'medium',
        'select--large': this.size === 'large',
        'select--pill': this.pill
      }, "onSl-show": this.handleMenuShow, "onSl-hide": this.handleMenuHide }, index.h("sl-input", { slot: "trigger", exportparts: "input, label, prefix, clear-button, suffix, help-text", ref: el => (this.input = el), id: this.inputId, class: "select__input", name: this.name, value: this.displayLabel, disabled: this.disabled, pill: this.pill, placeholder: this.displayLabel === '' && this.displayTags.length === 0 ? this.placeholder : null, size: this.size, invalid: this.invalid, clearable: this.clearable, required: this.required, "aria-labelledby": this.labelId, "aria-describedby": this.helpTextId, "onSl-focus": this.handleFocus, "onSl-blur": this.handleBlur, "onSl-clear": this.handleClear, onKeyDown: this.handleKeyDown, onKeyUp: this.handleKeyUp, onCut: this.handleCut, onPaste: this.handlePaste }, this.displayTags.length && (index.h("span", { part: "tags", slot: "prefix", class: "select__tags" }, this.displayTags)), index.h("span", { part: "icon", slot: "suffix", class: "select__icon" }, index.h("sl-icon", { name: "chevron-down" }))), index.h("sl-menu", { ref: el => (this.menu = el), part: "menu", class: "select__menu", "onSl-select": this.handleMenuSelect }, index.h("slot", { onSlotchange: this.handleSlotChange }))), index.h("div", { part: "help-text", id: this.helpTextId, class: {
        'help-text': true,
        'help-text--small': this.size === 'small',
        'help-text--medium': this.size === 'medium',
        'help-text--large': this.size === 'large',
        'help-text--invalid': this.invalid
      } }, index.h("slot", { name: "help-text" }))));
  }
  get host() { return index.getElement(this); }
  static get watchers() { return {
    "label": ["handleLabelChange"],
    "multiple": ["handleMultipleChange"],
    "value": ["handleValueChange"]
  }; }
};
Select.style = selectCss;

exports.sl_select = Select;
