import { r as registerInstance, c as createEvent, h, g as getElement } from './index-f69bad09.js';

const includeFiles = new Map();
const requestInclude = async (src, mode = 'cors') => {
  if (includeFiles.has(src)) {
    return includeFiles.get(src);
  }
  else {
    const request = fetch(src, { mode: mode }).then(async (response) => {
      return {
        ok: response.ok,
        status: response.status,
        html: await response.text()
      };
    });
    includeFiles.set(src, request);
    return request;
  }
};

const includeCss = ":host{display:block}";

const Include = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
    this.slLoad = createEvent(this, "sl-load", 7);
    this.slError = createEvent(this, "sl-error", 7);
    this.html = '';
    /** The fetch mode to use. */
    this.mode = 'cors';
  }
  handleSrcChange() {
    this.loadSource();
  }
  componentWillLoad() {
    this.loadSource();
  }
  async loadSource() {
    try {
      const src = this.src;
      const file = await requestInclude(src, this.mode);
      // If the src changed since the request started do nothing, otherwise we risk overwriting a subsequent response
      if (src !== this.src) {
        return;
      }
      if (!file.ok) {
        this.slError.emit({ status: file.status });
        return;
      }
      this.host.innerHTML = file.html;
      this.slLoad.emit();
    }
    catch (_a) {
      this.slError.emit();
    }
  }
  render() {
    return h("slot", null);
  }
  get host() { return getElement(this); }
  static get watchers() { return {
    "src": ["handleSrcChange"]
  }; }
};
Include.style = includeCss;

export { Include as sl_include };
