/* eslint-disable */
/* tslint:disable */
/**
 * This is an autogenerated file created by the Stencil compiler.
 * It contains typing information for all components that exist in this project.
 */
import { HTMLStencilElement, JSXBase } from "./stencil-public-runtime";
import { IconLibraryMutator, IconLibraryResolver } from "./components/icon-library/icon-library-registry";
export namespace Components {
    interface SlAlert {
        /**
          * Set to true to make the alert closable.
         */
        "closable": boolean;
        /**
          * The length of time, in milliseconds, the alert will show before closing itself. If the user interacts with the alert before it closes (e.g. moves the mouse over it), the timer will restart.
         */
        "duration": number;
        /**
          * Hides the alert
         */
        "hide": () => Promise<void>;
        /**
          * Indicates whether or not the alert is open. You can use this in lieu of the show/hide methods.
         */
        "open": boolean;
        /**
          * Shows the alert.
         */
        "show": () => Promise<void>;
        /**
          * Displays the alert as a toast notification. This will move the alert out of its position in the DOM and, when dismissed, it will be removed from the DOM completely. By storing a reference to the alert, you can reuse it by calling this method again. The returned promise will resolve after the alert is hidden.
         */
        "toast": () => Promise<unknown>;
        /**
          * The type of alert.
         */
        "type": 'primary' | 'success' | 'info' | 'warning' | 'danger';
    }
    interface SlAnimation {
        /**
          * Clears all KeyframeEffects caused by this animation and aborts its playback.
         */
        "cancel": () => Promise<void>;
        /**
          * The number of milliseconds to delay the start of the animation.
         */
        "delay": number;
        /**
          * Determines the direction of playback as well as the behavior when reaching the end of an iteration.
         */
        "direction": PlaybackDirection;
        /**
          * The number of milliseconds each iteration of the animation takes to complete.
         */
        "duration": number;
        /**
          * The rate of the animation's change over time.
         */
        "easing": string;
        /**
          * The number of milliseconds to delay after the active period of an animation sequence.
         */
        "endDelay": number;
        /**
          * Sets how the animation applies styles to its target before and after its execution.
         */
        "fill": FillMode;
        /**
          * Sets the playback time to the end of the animation corresponding to the current playback direction.
         */
        "finish": () => Promise<void>;
        /**
          * Gets a list of all supported animation names.
         */
        "getAnimationNames": () => Promise<string[]>;
        /**
          * Gets the current time of the animation in milliseconds.
         */
        "getCurrentTime": () => Promise<number>;
        /**
          * Gets a list of all supported easing function names.
         */
        "getEasingNames": () => Promise<string[]>;
        /**
          * The offset at which to start the animation, usually between 0 (start) and 1 (end).
         */
        "iterationStart": number;
        /**
          * The number of iterations to run before the animation completes. Defaults to `Infinity`, which loops.
         */
        "iterations": number;
        /**
          * The keyframes to use for the animation. If this is set, `name` will be ignored.
         */
        "keyframes": Keyframe[];
        /**
          * The name of the animation to use.
         */
        "name": string;
        /**
          * Pauses the animation. The animation will resume when this prop is removed.
         */
        "pause": boolean;
        /**
          * Sets the animation's playback rate. The default is `1`, which plays the animation at a normal speed. Setting this to `2`, for example, will double the animation's speed. A negative value can be used to reverse the animation. This value can be changed without causing the animation to restart.
         */
        "playbackRate": number;
        /**
          * Sets the current time of the animation in milliseconds.
         */
        "setCurrentTime": (time: number) => Promise<void>;
    }
    interface SlAvatar {
        /**
          * Alternative text for the image.
         */
        "alt": string;
        /**
          * The image source to use for the avatar.
         */
        "image": string;
        /**
          * Initials to use as a fallback when no image is available (1-2 characters max recommended).
         */
        "initials": string;
        /**
          * The shape of the avatar.
         */
        "shape": 'circle' | 'square' | 'rounded';
    }
    interface SlBadge {
        /**
          * Set to true to draw a pill-style badge with rounded edges.
         */
        "pill": boolean;
        /**
          * Set to true to make the badge pulsate to draw attention.
         */
        "pulse": boolean;
        /**
          * The badge's type.
         */
        "type": 'primary' | 'success' | 'info' | 'warning' | 'danger' | 'text';
    }
    interface SlButton {
        /**
          * Set to true to draw the button with a caret for use with dropdowns, popovers, etc.
         */
        "caret": boolean;
        /**
          * Set to true to draw a circle button.
         */
        "circle": boolean;
        /**
          * Set to true to disable the button.
         */
        "disabled": boolean;
        /**
          * Tells the browser to download the linked file as this filename. Only used when `href` is set.
         */
        "download": string;
        /**
          * When set, the underlying button will be rendered as an `<a>` with this `href` instead of a `<button>`.
         */
        "href": string;
        /**
          * Set to true to draw the button in a loading state.
         */
        "loading": boolean;
        /**
          * An optional name for the button. Ignored when `href` is set.
         */
        "name": string;
        /**
          * Set to true to draw a pill-style button with rounded edges.
         */
        "pill": boolean;
        /**
          * Removes focus from the button.
         */
        "removeFocus": () => Promise<void>;
        /**
          * Sets focus on the button.
         */
        "setFocus": () => Promise<void>;
        /**
          * The button's size.
         */
        "size": 'small' | 'medium' | 'large';
        /**
          * Indicates if activating the button should submit the form. Ignored when `href` is set.
         */
        "submit": boolean;
        /**
          * Tells the browser where to open the link. Only used when `href` is set.
         */
        "target": '_blank' | '_parent' | '_self' | '_top';
        /**
          * The button's type.
         */
        "type": 'default' | 'primary' | 'success' | 'info' | 'warning' | 'danger' | 'text';
        /**
          * An optional value for the button. Ignored when `href` is set.
         */
        "value": string;
    }
    interface SlButtonGroup {
        /**
          * A label to use for the button group's `aria-label` attribute.
         */
        "label": string;
    }
    interface SlCard {
    }
    interface SlCheckbox {
        /**
          * Set to true to draw the checkbox in a checked state.
         */
        "checked": boolean;
        /**
          * Set to true to disable the checkbox.
         */
        "disabled": boolean;
        /**
          * Set to true to draw the checkbox in an indeterminate state.
         */
        "indeterminate": boolean;
        /**
          * This will be true when the control is in an invalid state. Validity is determined by the `required` prop.
         */
        "invalid": boolean;
        /**
          * The checkbox's name attribute.
         */
        "name": string;
        /**
          * Removes focus from the checkbox.
         */
        "removeFocus": () => Promise<void>;
        /**
          * Checks for validity and shows the browser's validation message if the control is invalid.
         */
        "reportValidity": () => Promise<boolean>;
        /**
          * Set to true to make the checkbox a required field.
         */
        "required": boolean;
        /**
          * Sets a custom validation message. If `message` is not empty, the field will be considered invalid.
         */
        "setCustomValidity": (message: string) => Promise<void>;
        /**
          * Sets focus on the checkbox.
         */
        "setFocus": () => Promise<void>;
        /**
          * The checkbox's value attribute.
         */
        "value": string;
    }
    interface SlColorPicker {
        /**
          * Set to true to disable the color picker.
         */
        "disabled": boolean;
        /**
          * The format to use for the display value. If opacity is enabled, these will translate to HEXA, RGBA, and HSLA respectively. The color picker will always accept user input in any format (including CSS color names) and convert it to the desired format.
         */
        "format": 'hex' | 'rgb' | 'hsl';
        /**
          * Enable this option to prevent the panel from being clipped when the component is placed inside a container with `overflow: auto|scroll`.
         */
        "hoist": boolean;
        /**
          * Set to true to render the color picker inline rather than inside a dropdown.
         */
        "inline": boolean;
        /**
          * This will be true when the control is in an invalid state. Validity is determined by the `setCustomValidity()` method using the browser's constraint validation API.
         */
        "invalid": boolean;
        /**
          * The input's name attribute.
         */
        "name": string;
        /**
          * Whether to show the opacity slider.
         */
        "opacity": boolean;
        /**
          * Checks for validity and shows the browser's validation message if the control is invalid.
         */
        "reportValidity": () => Promise<unknown>;
        /**
          * Sets a custom validation message. If `message` is not empty, the field will be considered invalid.
         */
        "setCustomValidity": (message: string) => Promise<void>;
        /**
          * Determines the size of the color picker's trigger. This has no effect on inline color pickers.
         */
        "size": 'small' | 'medium' | 'large';
        /**
          * An array of predefined color swatches to display. Can include any format the color picker can parse, including HEX(A), RGB(A), HSL(A), and CSS color names.
         */
        "swatches": string[];
        /**
          * By default, the value will be set in lowercase. Set this to true to set it in uppercase instead.
         */
        "uppercase": boolean;
        /**
          * The current color.
         */
        "value": string;
    }
    interface SlDetails {
        /**
          * Set to true to prevent the user from toggling the details.
         */
        "disabled": boolean;
        /**
          * Hides the alert
         */
        "hide": () => Promise<void>;
        /**
          * Indicates whether or not the details is open. You can use this in lieu of the show/hide methods.
         */
        "open": boolean;
        /**
          * Shows the alert.
         */
        "show": () => Promise<void>;
        /**
          * The summary to show in the details header. If you need to display HTML, use the `summary` slot instead.
         */
        "summary": string;
    }
    interface SlDialog {
        /**
          * Hides the dialog
         */
        "hide": () => Promise<void>;
        /**
          * The dialog's label as displayed in the header. You should always include a relevant label even when using `no-header`, as it is required for proper accessibility.
         */
        "label": string;
        /**
          * Set to true to disable the header. This will also remove the default close button, so please ensure you provide an easy, accessible way for users to dismiss the dialog.
         */
        "noHeader": boolean;
        /**
          * Indicates whether or not the dialog is open. You can use this in lieu of the show/hide methods.
         */
        "open": boolean;
        /**
          * Shows the dialog
         */
        "show": () => Promise<void>;
    }
    interface SlDrawer {
        /**
          * By default, the drawer slides out of its containing block (usually the viewport). To make the drawer slide out of its parent element, set this prop and add `position: relative` to the parent.
         */
        "contained": boolean;
        /**
          * Hides the drawer
         */
        "hide": () => Promise<void>;
        /**
          * The drawer's label as displayed in the header. You should always include a relevant label even when using `no-header`, as it is required for proper accessibility.
         */
        "label": string;
        /**
          * Removes the header. This will also remove the default close button, so please ensure you provide an easy, accessible way for users to dismiss the drawer.
         */
        "noHeader": boolean;
        /**
          * Indicates whether or not the drawer is open. You can use this in lieu of the show/hide methods.
         */
        "open": boolean;
        /**
          * The direction from which the drawer will open.
         */
        "placement": 'top' | 'right' | 'bottom' | 'left';
        /**
          * Shows the drawer
         */
        "show": () => Promise<void>;
    }
    interface SlDropdown {
        /**
          * Determines whether the dropdown should hide when a menu item is selected.
         */
        "closeOnSelect": boolean;
        /**
          * The dropdown will close when the user interacts outside of this element (e.g. clicking).
         */
        "containingElement": HTMLElement;
        /**
          * The distance in pixels from which to offset the panel away from its trigger.
         */
        "distance": number;
        /**
          * Hides the dropdown panel
         */
        "hide": () => Promise<void>;
        /**
          * Enable this option to prevent the panel from being clipped when the component is placed inside a container with `overflow: auto|scroll`.
         */
        "hoist": boolean;
        /**
          * Indicates whether or not the dropdown is open. You can use this in lieu of the show/hide methods.
         */
        "open": boolean;
        /**
          * The preferred placement of the dropdown panel. Note that the actual placement may vary as needed to keep the panel inside of the viewport.
         */
        "placement": | 'top'
    | 'top-start'
    | 'top-end'
    | 'bottom'
    | 'bottom-start'
    | 'bottom-end'
    | 'right'
    | 'right-start'
    | 'right-end'
    | 'left'
    | 'left-start'
    | 'left-end';
        /**
          * Shows the dropdown panel
         */
        "show": () => Promise<void>;
        /**
          * The distance in pixels from which to offset the panel along its trigger.
         */
        "skidding": number;
    }
    interface SlForm {
        /**
          * Gets all form control elements (native and custom).
         */
        "getFormControls": () => Promise<HTMLElement[]>;
        /**
          * Serializes all form controls elements and returns a `FormData` object.
         */
        "getFormData": () => Promise<FormData>;
        /**
          * Prevent the form from validating inputs before submitting.
         */
        "novalidate": boolean;
        /**
          * Submits the form. If all controls are valid, the `sl-submit` event will be emitted and the promise will resolve with `true`. If any form control is invalid, the promise will resolve with `false` and no event will be emitted.
         */
        "submit": () => Promise<boolean>;
    }
    interface SlFormatBytes {
        /**
          * The locale to use when formatting the number.
         */
        "locale": string;
        /**
          * The unit to display.
         */
        "unit": 'bytes' | 'bits';
        /**
          * The number to format in bytes.
         */
        "value": number;
    }
    interface SlIcon {
        /**
          * An alternative description to use for accessibility. If omitted, the name or src will be used to generate it.
         */
        "label": string;
        /**
          * The name of a registered custom icon library.
         */
        "library": string;
        /**
          * The name of the icon to draw.
         */
        "name": string;
        "redraw": () => Promise<void>;
        /**
          * An external URL of an SVG file.
         */
        "src": string;
    }
    interface SlIconButton {
        /**
          * Set to true to disable the button.
         */
        "disabled": boolean;
        /**
          * An alternative description to use for accessibility. If omitted, the name or src will be used to generate it.
         */
        "label": string;
        /**
          * The name of a registered custom icon library.
         */
        "library": string;
        /**
          * The name of the icon to draw.
         */
        "name": string;
        /**
          * An external URL of an SVG file.
         */
        "src": string;
    }
    interface SlIconLibrary {
        /**
          * A function that mutates the SVG element before it renders.
         */
        "mutator": IconLibraryMutator;
        /**
          * The name of the icon library.
         */
        "name": string;
        /**
          * A function that translates an icon name to a URL where the corresponding SVG file exists The URL can be local or a CORS-enabled endpoint.
         */
        "resolver": IconLibraryResolver;
    }
    interface SlImageComparer {
        /**
          * The position of the divider as a percentage.
         */
        "position": number;
    }
    interface SlInclude {
        /**
          * The fetch mode to use.
         */
        "mode": 'cors' | 'no-cors' | 'same-origin';
        /**
          * The location of the HTML file to include.
         */
        "src": string;
    }
    interface SlInput {
        /**
          * The input's autocaptialize attribute.
         */
        "autocapitalize": string;
        /**
          * The input's autocomplete attribute.
         */
        "autocomplete": string;
        /**
          * The input's autocorrect attribute.
         */
        "autocorrect": string;
        /**
          * The input's autofocus attribute.
         */
        "autofocus": boolean;
        /**
          * Set to true to add a clear button when the input is populated.
         */
        "clearable": boolean;
        /**
          * Set to true to disable the input.
         */
        "disabled": boolean;
        /**
          * The input's inputmode attribute.
         */
        "inputmode": 'none' | 'text' | 'decimal' | 'numeric' | 'tel' | 'search' | 'email' | 'url';
        /**
          * This will be true when the control is in an invalid state. Validity is determined by props such as `type`, `required`, `minlength`, `maxlength`, and `pattern` using the browser's constraint validation API.
         */
        "invalid": boolean;
        /**
          * The input's label.
         */
        "label": string;
        /**
          * The input's maximum value.
         */
        "max": number;
        /**
          * The maximum length of input that will be considered valid.
         */
        "maxlength": number;
        /**
          * The input's minimum value.
         */
        "min": number;
        /**
          * The minimum length of input that will be considered valid.
         */
        "minlength": number;
        /**
          * The input's name attribute.
         */
        "name": string;
        /**
          * A pattern to validate input against.
         */
        "pattern": string;
        /**
          * Set to true to draw a pill-style input with rounded edges.
         */
        "pill": boolean;
        /**
          * The input's placeholder text.
         */
        "placeholder": string;
        /**
          * Set to true to make the input readonly.
         */
        "readonly": boolean;
        /**
          * Removes focus from the input.
         */
        "removeFocus": () => Promise<void>;
        /**
          * Checks for validity and shows the browser's validation message if the control is invalid.
         */
        "reportValidity": () => Promise<boolean>;
        /**
          * Set to true to make the input a required field.
         */
        "required": boolean;
        /**
          * Selects all the text in the input.
         */
        "select": () => Promise<void>;
        /**
          * Sets a custom validation message. If `message` is not empty, the field will be considered invalid.
         */
        "setCustomValidity": (message: string) => Promise<void>;
        /**
          * Sets focus on the input.
         */
        "setFocus": () => Promise<void>;
        /**
          * Replaces a range of text with a new string.
         */
        "setRangeText": (replacement: string, start: number, end: number, selectMode?: 'select' | 'start' | 'end' | 'preserve') => Promise<void>;
        /**
          * Sets the start and end positions of the text selection (0-based).
         */
        "setSelectionRange": (selectionStart: number, selectionEnd: number, selectionDirection?: 'forward' | 'backward' | 'none') => Promise<void>;
        /**
          * The input's size.
         */
        "size": 'small' | 'medium' | 'large';
        /**
          * Enables spell checking on the input.
         */
        "spellcheck": boolean;
        /**
          * The input's step attribute.
         */
        "step": number;
        /**
          * Set to true to add a password toggle button for password inputs.
         */
        "togglePassword": boolean;
        /**
          * The input's type.
         */
        "type": 'email' | 'number' | 'password' | 'search' | 'tel' | 'text' | 'url';
        /**
          * The input's value attribute.
         */
        "value": string;
    }
    interface SlMenu {
        /**
          * Removes focus from the menu.
         */
        "removeFocus": () => Promise<void>;
        /**
          * Sets focus on the menu.
         */
        "setFocus": () => Promise<void>;
        /**
          * Initiates type-to-select logic, which automatically selects an option based on what the user is currently typing. The key passed will be appended to the internal query and the selection will be updated. After a brief period, the internal query is cleared automatically. This method is intended to be used with the keydown event. Useful for enabling type-to-select when the menu doesn't have focus.
         */
        "typeToSelect": (key: string) => Promise<void>;
    }
    interface SlMenuDivider {
    }
    interface SlMenuItem {
        /**
          * Draws the menu in an active (i.e. or hover/focus), state to indicate the current menu selection. This is used in lieu of standard :hover and :focus states to prevent concurrent interactions from different devices, such as focusing with the keyboard and hovering with the mouse.
         */
        "active": boolean;
        /**
          * Set to true to draw the item in a checked state.
         */
        "checked": boolean;
        /**
          * Set to true to draw the menu item in a disabled state.
         */
        "disabled": boolean;
        /**
          * A unique value to store in the menu item.
         */
        "value": string;
    }
    interface SlMenuLabel {
    }
    interface SlProgressBar {
        /**
          * The progress bar's percentage, 0 to 100.
         */
        "percentage": number;
    }
    interface SlProgressRing {
        /**
          * The current progress percentage, 0 - 100.
         */
        "percentage": number;
        /**
          * The size of the progress ring in pixels.
         */
        "size": number;
        /**
          * The stroke width of the progress ring in pixels.
         */
        "strokeWidth": number;
    }
    interface SlRadio {
        /**
          * Set to true to draw the radio in a checked state.
         */
        "checked": boolean;
        /**
          * Set to true to disable the radio.
         */
        "disabled": boolean;
        /**
          * This will be true when the control is in an invalid state. Validity in range inputs is determined by the message provided by the `setCustomValidity` method.
         */
        "invalid": boolean;
        /**
          * The radio's name attribute.
         */
        "name": string;
        /**
          * Removes focus from the radio.
         */
        "removeFocus": () => Promise<void>;
        /**
          * Checks for validity and shows the browser's validation message if the control is invalid.
         */
        "reportValidity": () => Promise<boolean>;
        /**
          * Sets a custom validation message. If `message` is not empty, the field will be considered invalid.
         */
        "setCustomValidity": (message: string) => Promise<void>;
        /**
          * Sets focus on the radio.
         */
        "setFocus": () => Promise<void>;
        /**
          * The radio's value attribute.
         */
        "value": string;
    }
    interface SlRange {
        /**
          * Set to true to disable the input.
         */
        "disabled": boolean;
        /**
          * This will be true when the control is in an invalid state. Validity in range inputs is determined by the message provided by the `setCustomValidity` method.
         */
        "invalid": boolean;
        /**
          * The input's max attribute.
         */
        "max": number;
        /**
          * The input's min attribute.
         */
        "min": number;
        /**
          * The input's name attribute.
         */
        "name": string;
        /**
          * Removes focus from the input.
         */
        "removeFocus": () => Promise<void>;
        /**
          * Sets a custom validation message. If `message` is not empty, the field will be considered invalid.
         */
        "setCustomValidity": (message: string) => Promise<void>;
        /**
          * Sets focus on the input.
         */
        "setFocus": () => Promise<void>;
        /**
          * The input's step attribute.
         */
        "step": number;
        /**
          * The preferred placedment of the tooltip.
         */
        "tooltip": 'top' | 'bottom' | 'none';
        /**
          * A function used to format the tooltip's value.
         */
        "tooltipFormatter": (value: number) => string;
        /**
          * The input's value attribute.
         */
        "value": number;
    }
    interface SlRating {
        /**
          * Disables the rating.
         */
        "disabled": boolean;
        /**
          * A function that returns the symbols to display. Accepts an option `value` parameter you can use to map a specific symbol to a value.
         */
        "getSymbol": (value?: number) => string;
        /**
          * The highest rating to show.
         */
        "max": number;
        /**
          * The minimum increment value allowed by the control.
         */
        "precision": number;
        /**
          * Makes the rating readonly.
         */
        "readonly": boolean;
        /**
          * Removes focus from the rating.
         */
        "removeFocus": () => Promise<void>;
        /**
          * Sets focus on the rating.
         */
        "setFocus": () => Promise<void>;
        /**
          * The current rating.
         */
        "value": number;
    }
    interface SlResponsiveEmbed {
        /**
          * The aspect ratio of the embedded media in the format of `width:height`, e.g. `16:9`, `4:3`, or `1:1`. Ratios not in this format will be ignored.
         */
        "aspectRatio": string;
    }
    interface SlSelect {
        /**
          * Set to true to add a clear button when the select is populated.
         */
        "clearable": boolean;
        /**
          * Set to true to disable the select control.
         */
        "disabled": boolean;
        /**
          * Enable this option to prevent the panel from being clipped when the component is placed inside a container with `overflow: auto|scroll`.
         */
        "hoist": boolean;
        /**
          * This will be true when the control is in an invalid state. Validity is determined by the `required` prop.
         */
        "invalid": boolean;
        /**
          * The select's label.
         */
        "label": string;
        /**
          * The maximum number of tags to show when `multiple` is true. After the maximum, "+n" will be shown to indicate the number of additional items that are selected. Set to -1 to remove the limit.
         */
        "maxTagsVisible": number;
        /**
          * Set to true to enable multiselect.
         */
        "multiple": boolean;
        /**
          * The select's name.
         */
        "name": string;
        /**
          * Set to true to draw a pill-style select with rounded edges.
         */
        "pill": boolean;
        /**
          * The select's placeholder text.
         */
        "placeholder": string;
        /**
          * Checks for validity and shows the browser's validation message if the control is invalid.
         */
        "reportValidity": () => Promise<boolean>;
        /**
          * The select's required attribute.
         */
        "required": boolean;
        /**
          * Sets a custom validation message. If `message` is not empty, the field will be considered invalid.
         */
        "setCustomValidity": (message: string) => Promise<void>;
        /**
          * The select's size.
         */
        "size": 'small' | 'medium' | 'large';
        /**
          * The value of the control. This will be a string or an array depending on `multiple`.
         */
        "value": string | Array<string>;
    }
    interface SlSkeleton {
        /**
          * Determines which effect the skeleton will use.
         */
        "effect": 'pulse' | 'sheen' | 'none';
    }
    interface SlSpinner {
    }
    interface SlSwitch {
        /**
          * Set to true to draw the switch in a checked state.
         */
        "checked": boolean;
        /**
          * Set to true to disable the switch.
         */
        "disabled": boolean;
        /**
          * This will be true when the control is in an invalid state. Validity is determined by the `required` prop.
         */
        "invalid": boolean;
        /**
          * The switch's name attribute.
         */
        "name": string;
        /**
          * Removes focus from the switch.
         */
        "removeFocus": () => Promise<void>;
        /**
          * Checks for validity and shows the browser's validation message if the control is invalid.
         */
        "reportValidity": () => Promise<boolean>;
        /**
          * Set to true to make the switch a required field.
         */
        "required": boolean;
        /**
          * Sets a custom validation message. If `message` is not empty, the field will be considered invalid.
         */
        "setCustomValidity": (message: string) => Promise<void>;
        /**
          * Sets focus on the switch.
         */
        "setFocus": () => Promise<void>;
        /**
          * The switch's value attribute.
         */
        "value": string;
    }
    interface SlTab {
        /**
          * Set to true to draw the tab in an active state.
         */
        "active": boolean;
        /**
          * Set to true to draw the tab in a disabled state.
         */
        "disabled": boolean;
        /**
          * The name of the tab panel the tab will control. The panel must be located in the same tab group.
         */
        "panel": string;
        /**
          * Removes focus from the tab.
         */
        "removeFocus": () => Promise<void>;
        /**
          * Sets focus to the tab.
         */
        "setFocus": () => Promise<void>;
    }
    interface SlTabGroup {
        /**
          * The placement of the tabs.
         */
        "placement": 'top' | 'bottom' | 'left' | 'right';
        /**
          * Shows the specified tab panel.
         */
        "show": (panel: string) => Promise<void>;
    }
    interface SlTabPanel {
        /**
          * When true, the tab panel will be shown.
         */
        "active": boolean;
        /**
          * The tab panel's name.
         */
        "name": string;
    }
    interface SlTag {
        /**
          * Set to true to make the tag clearable.
         */
        "clearable": boolean;
        /**
          * Set to true to draw a pill-style tag with rounded edges.
         */
        "pill": boolean;
        /**
          * The tag's size.
         */
        "size": 'small' | 'medium' | 'large';
        /**
          * The tag's type.
         */
        "type": 'primary' | 'success' | 'info' | 'warning' | 'danger' | 'text';
    }
    interface SlTextarea {
        /**
          * The textarea's autocaptialize attribute.
         */
        "autocapitalize": string;
        /**
          * The textarea's autocomplete attribute.
         */
        "autocomplete": string;
        /**
          * The textarea's autocorrect attribute.
         */
        "autocorrect": string;
        /**
          * The textarea's autofocus attribute.
         */
        "autofocus": boolean;
        /**
          * Set to true to disable the textarea.
         */
        "disabled": boolean;
        /**
          * The textarea's inputmode attribute.
         */
        "inputmode": 'none' | 'text' | 'decimal' | 'numeric' | 'tel' | 'search' | 'email' | 'url';
        /**
          * This will be true when the control is in an invalid state. Validity is determined by props such as `required`, `minlength`, and `maxlength` using the browser's constraint validation API.
         */
        "invalid": boolean;
        /**
          * The textarea's label.
         */
        "label": string;
        /**
          * The maximum length of input that will be considered valid.
         */
        "maxlength": number;
        /**
          * The minimum length of input that will be considered valid.
         */
        "minlength": number;
        /**
          * The textarea's name attribute.
         */
        "name": string;
        /**
          * The textarea's placeholder text.
         */
        "placeholder": string;
        /**
          * Set to true for a readonly textarea.
         */
        "readonly": boolean;
        /**
          * Removes focus fromt the textarea.
         */
        "removeFocus": () => Promise<void>;
        /**
          * Checks for validity and shows the browser's validation message if the control is invalid.
         */
        "reportValidity": () => Promise<boolean>;
        /**
          * The textarea's required attribute.
         */
        "required": boolean;
        /**
          * Controls how the textarea can be resized.
         */
        "resize": 'none' | 'vertical' | 'auto';
        /**
          * The number of rows to display by default.
         */
        "rows": number;
        /**
          * Selects all the text in the input.
         */
        "select": () => Promise<void>;
        /**
          * Sets a custom validation message. If `message` is not empty, the field will be considered invalid.
         */
        "setCustomValidity": (message: string) => Promise<void>;
        /**
          * Sets focus on the textarea.
         */
        "setFocus": () => Promise<void>;
        /**
          * Replaces a range of text with a new string.
         */
        "setRangeText": (replacement: string, start: number, end: number, selectMode?: 'select' | 'start' | 'end' | 'preserve') => Promise<void>;
        /**
          * Sets the start and end positions of the text selection (0-based).
         */
        "setSelectionRange": (selectionStart: number, selectionEnd: number, selectionDirection?: 'forward' | 'backward' | 'none') => Promise<void>;
        /**
          * The textarea's size.
         */
        "size": 'small' | 'medium' | 'large';
        /**
          * The textarea's spellcheck attribute.
         */
        "spellcheck": boolean;
        /**
          * The textarea's value attribute.
         */
        "value": string;
    }
    interface SlTooltip {
        /**
          * The tooltip's content.
         */
        "content": string;
        /**
          * Set to true to disable the tooltip so it won't show when triggered.
         */
        "disabled": boolean;
        /**
          * The distance in pixels from which to offset the tooltip away from its target.
         */
        "distance": number;
        /**
          * Shows the tooltip.
         */
        "hide": () => Promise<void>;
        /**
          * Indicates whether or not the tooltip is open. You can use this in lieu of the show/hide methods.
         */
        "open": boolean;
        /**
          * The preferred placement of the tooltip. Note that the actual placement may vary as needed to keep the tooltip inside of the viewport.
         */
        "placement": | 'top'
    | 'top-start'
    | 'top-end'
    | 'right'
    | 'right-start'
    | 'right-end'
    | 'bottom'
    | 'bottom-start'
    | 'bottom-end'
    | 'left'
    | 'left-start'
    | 'left-end';
        /**
          * Shows the tooltip.
         */
        "show": () => Promise<void>;
        /**
          * The distance in pixels from which to offset the tooltip along its target.
         */
        "skidding": number;
        /**
          * Controls how the tooltip is activated. Possible options include `click`, `hover`, `focus`, and `manual`. Multiple options can be passed by separating them with a space. When manual is used, the tooltip must be activated programmatically.
         */
        "trigger": string;
    }
}
declare global {
    interface HTMLSlAlertElement extends Components.SlAlert, HTMLStencilElement {
    }
    var HTMLSlAlertElement: {
        prototype: HTMLSlAlertElement;
        new (): HTMLSlAlertElement;
    };
    interface HTMLSlAnimationElement extends Components.SlAnimation, HTMLStencilElement {
    }
    var HTMLSlAnimationElement: {
        prototype: HTMLSlAnimationElement;
        new (): HTMLSlAnimationElement;
    };
    interface HTMLSlAvatarElement extends Components.SlAvatar, HTMLStencilElement {
    }
    var HTMLSlAvatarElement: {
        prototype: HTMLSlAvatarElement;
        new (): HTMLSlAvatarElement;
    };
    interface HTMLSlBadgeElement extends Components.SlBadge, HTMLStencilElement {
    }
    var HTMLSlBadgeElement: {
        prototype: HTMLSlBadgeElement;
        new (): HTMLSlBadgeElement;
    };
    interface HTMLSlButtonElement extends Components.SlButton, HTMLStencilElement {
    }
    var HTMLSlButtonElement: {
        prototype: HTMLSlButtonElement;
        new (): HTMLSlButtonElement;
    };
    interface HTMLSlButtonGroupElement extends Components.SlButtonGroup, HTMLStencilElement {
    }
    var HTMLSlButtonGroupElement: {
        prototype: HTMLSlButtonGroupElement;
        new (): HTMLSlButtonGroupElement;
    };
    interface HTMLSlCardElement extends Components.SlCard, HTMLStencilElement {
    }
    var HTMLSlCardElement: {
        prototype: HTMLSlCardElement;
        new (): HTMLSlCardElement;
    };
    interface HTMLSlCheckboxElement extends Components.SlCheckbox, HTMLStencilElement {
    }
    var HTMLSlCheckboxElement: {
        prototype: HTMLSlCheckboxElement;
        new (): HTMLSlCheckboxElement;
    };
    interface HTMLSlColorPickerElement extends Components.SlColorPicker, HTMLStencilElement {
    }
    var HTMLSlColorPickerElement: {
        prototype: HTMLSlColorPickerElement;
        new (): HTMLSlColorPickerElement;
    };
    interface HTMLSlDetailsElement extends Components.SlDetails, HTMLStencilElement {
    }
    var HTMLSlDetailsElement: {
        prototype: HTMLSlDetailsElement;
        new (): HTMLSlDetailsElement;
    };
    interface HTMLSlDialogElement extends Components.SlDialog, HTMLStencilElement {
    }
    var HTMLSlDialogElement: {
        prototype: HTMLSlDialogElement;
        new (): HTMLSlDialogElement;
    };
    interface HTMLSlDrawerElement extends Components.SlDrawer, HTMLStencilElement {
    }
    var HTMLSlDrawerElement: {
        prototype: HTMLSlDrawerElement;
        new (): HTMLSlDrawerElement;
    };
    interface HTMLSlDropdownElement extends Components.SlDropdown, HTMLStencilElement {
    }
    var HTMLSlDropdownElement: {
        prototype: HTMLSlDropdownElement;
        new (): HTMLSlDropdownElement;
    };
    interface HTMLSlFormElement extends Components.SlForm, HTMLStencilElement {
    }
    var HTMLSlFormElement: {
        prototype: HTMLSlFormElement;
        new (): HTMLSlFormElement;
    };
    interface HTMLSlFormatBytesElement extends Components.SlFormatBytes, HTMLStencilElement {
    }
    var HTMLSlFormatBytesElement: {
        prototype: HTMLSlFormatBytesElement;
        new (): HTMLSlFormatBytesElement;
    };
    interface HTMLSlIconElement extends Components.SlIcon, HTMLStencilElement {
    }
    var HTMLSlIconElement: {
        prototype: HTMLSlIconElement;
        new (): HTMLSlIconElement;
    };
    interface HTMLSlIconButtonElement extends Components.SlIconButton, HTMLStencilElement {
    }
    var HTMLSlIconButtonElement: {
        prototype: HTMLSlIconButtonElement;
        new (): HTMLSlIconButtonElement;
    };
    interface HTMLSlIconLibraryElement extends Components.SlIconLibrary, HTMLStencilElement {
    }
    var HTMLSlIconLibraryElement: {
        prototype: HTMLSlIconLibraryElement;
        new (): HTMLSlIconLibraryElement;
    };
    interface HTMLSlImageComparerElement extends Components.SlImageComparer, HTMLStencilElement {
    }
    var HTMLSlImageComparerElement: {
        prototype: HTMLSlImageComparerElement;
        new (): HTMLSlImageComparerElement;
    };
    interface HTMLSlIncludeElement extends Components.SlInclude, HTMLStencilElement {
    }
    var HTMLSlIncludeElement: {
        prototype: HTMLSlIncludeElement;
        new (): HTMLSlIncludeElement;
    };
    interface HTMLSlInputElement extends Components.SlInput, HTMLStencilElement {
    }
    var HTMLSlInputElement: {
        prototype: HTMLSlInputElement;
        new (): HTMLSlInputElement;
    };
    interface HTMLSlMenuElement extends Components.SlMenu, HTMLStencilElement {
    }
    var HTMLSlMenuElement: {
        prototype: HTMLSlMenuElement;
        new (): HTMLSlMenuElement;
    };
    interface HTMLSlMenuDividerElement extends Components.SlMenuDivider, HTMLStencilElement {
    }
    var HTMLSlMenuDividerElement: {
        prototype: HTMLSlMenuDividerElement;
        new (): HTMLSlMenuDividerElement;
    };
    interface HTMLSlMenuItemElement extends Components.SlMenuItem, HTMLStencilElement {
    }
    var HTMLSlMenuItemElement: {
        prototype: HTMLSlMenuItemElement;
        new (): HTMLSlMenuItemElement;
    };
    interface HTMLSlMenuLabelElement extends Components.SlMenuLabel, HTMLStencilElement {
    }
    var HTMLSlMenuLabelElement: {
        prototype: HTMLSlMenuLabelElement;
        new (): HTMLSlMenuLabelElement;
    };
    interface HTMLSlProgressBarElement extends Components.SlProgressBar, HTMLStencilElement {
    }
    var HTMLSlProgressBarElement: {
        prototype: HTMLSlProgressBarElement;
        new (): HTMLSlProgressBarElement;
    };
    interface HTMLSlProgressRingElement extends Components.SlProgressRing, HTMLStencilElement {
    }
    var HTMLSlProgressRingElement: {
        prototype: HTMLSlProgressRingElement;
        new (): HTMLSlProgressRingElement;
    };
    interface HTMLSlRadioElement extends Components.SlRadio, HTMLStencilElement {
    }
    var HTMLSlRadioElement: {
        prototype: HTMLSlRadioElement;
        new (): HTMLSlRadioElement;
    };
    interface HTMLSlRangeElement extends Components.SlRange, HTMLStencilElement {
    }
    var HTMLSlRangeElement: {
        prototype: HTMLSlRangeElement;
        new (): HTMLSlRangeElement;
    };
    interface HTMLSlRatingElement extends Components.SlRating, HTMLStencilElement {
    }
    var HTMLSlRatingElement: {
        prototype: HTMLSlRatingElement;
        new (): HTMLSlRatingElement;
    };
    interface HTMLSlResponsiveEmbedElement extends Components.SlResponsiveEmbed, HTMLStencilElement {
    }
    var HTMLSlResponsiveEmbedElement: {
        prototype: HTMLSlResponsiveEmbedElement;
        new (): HTMLSlResponsiveEmbedElement;
    };
    interface HTMLSlSelectElement extends Components.SlSelect, HTMLStencilElement {
    }
    var HTMLSlSelectElement: {
        prototype: HTMLSlSelectElement;
        new (): HTMLSlSelectElement;
    };
    interface HTMLSlSkeletonElement extends Components.SlSkeleton, HTMLStencilElement {
    }
    var HTMLSlSkeletonElement: {
        prototype: HTMLSlSkeletonElement;
        new (): HTMLSlSkeletonElement;
    };
    interface HTMLSlSpinnerElement extends Components.SlSpinner, HTMLStencilElement {
    }
    var HTMLSlSpinnerElement: {
        prototype: HTMLSlSpinnerElement;
        new (): HTMLSlSpinnerElement;
    };
    interface HTMLSlSwitchElement extends Components.SlSwitch, HTMLStencilElement {
    }
    var HTMLSlSwitchElement: {
        prototype: HTMLSlSwitchElement;
        new (): HTMLSlSwitchElement;
    };
    interface HTMLSlTabElement extends Components.SlTab, HTMLStencilElement {
    }
    var HTMLSlTabElement: {
        prototype: HTMLSlTabElement;
        new (): HTMLSlTabElement;
    };
    interface HTMLSlTabGroupElement extends Components.SlTabGroup, HTMLStencilElement {
    }
    var HTMLSlTabGroupElement: {
        prototype: HTMLSlTabGroupElement;
        new (): HTMLSlTabGroupElement;
    };
    interface HTMLSlTabPanelElement extends Components.SlTabPanel, HTMLStencilElement {
    }
    var HTMLSlTabPanelElement: {
        prototype: HTMLSlTabPanelElement;
        new (): HTMLSlTabPanelElement;
    };
    interface HTMLSlTagElement extends Components.SlTag, HTMLStencilElement {
    }
    var HTMLSlTagElement: {
        prototype: HTMLSlTagElement;
        new (): HTMLSlTagElement;
    };
    interface HTMLSlTextareaElement extends Components.SlTextarea, HTMLStencilElement {
    }
    var HTMLSlTextareaElement: {
        prototype: HTMLSlTextareaElement;
        new (): HTMLSlTextareaElement;
    };
    interface HTMLSlTooltipElement extends Components.SlTooltip, HTMLStencilElement {
    }
    var HTMLSlTooltipElement: {
        prototype: HTMLSlTooltipElement;
        new (): HTMLSlTooltipElement;
    };
    interface HTMLElementTagNameMap {
        "sl-alert": HTMLSlAlertElement;
        "sl-animation": HTMLSlAnimationElement;
        "sl-avatar": HTMLSlAvatarElement;
        "sl-badge": HTMLSlBadgeElement;
        "sl-button": HTMLSlButtonElement;
        "sl-button-group": HTMLSlButtonGroupElement;
        "sl-card": HTMLSlCardElement;
        "sl-checkbox": HTMLSlCheckboxElement;
        "sl-color-picker": HTMLSlColorPickerElement;
        "sl-details": HTMLSlDetailsElement;
        "sl-dialog": HTMLSlDialogElement;
        "sl-drawer": HTMLSlDrawerElement;
        "sl-dropdown": HTMLSlDropdownElement;
        "sl-form": HTMLSlFormElement;
        "sl-format-bytes": HTMLSlFormatBytesElement;
        "sl-icon": HTMLSlIconElement;
        "sl-icon-button": HTMLSlIconButtonElement;
        "sl-icon-library": HTMLSlIconLibraryElement;
        "sl-image-comparer": HTMLSlImageComparerElement;
        "sl-include": HTMLSlIncludeElement;
        "sl-input": HTMLSlInputElement;
        "sl-menu": HTMLSlMenuElement;
        "sl-menu-divider": HTMLSlMenuDividerElement;
        "sl-menu-item": HTMLSlMenuItemElement;
        "sl-menu-label": HTMLSlMenuLabelElement;
        "sl-progress-bar": HTMLSlProgressBarElement;
        "sl-progress-ring": HTMLSlProgressRingElement;
        "sl-radio": HTMLSlRadioElement;
        "sl-range": HTMLSlRangeElement;
        "sl-rating": HTMLSlRatingElement;
        "sl-responsive-embed": HTMLSlResponsiveEmbedElement;
        "sl-select": HTMLSlSelectElement;
        "sl-skeleton": HTMLSlSkeletonElement;
        "sl-spinner": HTMLSlSpinnerElement;
        "sl-switch": HTMLSlSwitchElement;
        "sl-tab": HTMLSlTabElement;
        "sl-tab-group": HTMLSlTabGroupElement;
        "sl-tab-panel": HTMLSlTabPanelElement;
        "sl-tag": HTMLSlTagElement;
        "sl-textarea": HTMLSlTextareaElement;
        "sl-tooltip": HTMLSlTooltipElement;
    }
}
declare namespace LocalJSX {
    interface SlAlert {
        /**
          * Set to true to make the alert closable.
         */
        "closable"?: boolean;
        /**
          * The length of time, in milliseconds, the alert will show before closing itself. If the user interacts with the alert before it closes (e.g. moves the mouse over it), the timer will restart.
         */
        "duration"?: number;
        /**
          * Emitted after the alert closes and all transitions are complete.
         */
        "onSl-after-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted after the alert opens and all transitions are complete.
         */
        "onSl-after-show"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the alert closes. Calling `event.preventDefault()` will prevent it from being closed.
         */
        "onSl-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the alert opens. Calling `event.preventDefault()` will prevent it from being opened.
         */
        "onSl-show"?: (event: CustomEvent<any>) => void;
        /**
          * Indicates whether or not the alert is open. You can use this in lieu of the show/hide methods.
         */
        "open"?: boolean;
        /**
          * The type of alert.
         */
        "type"?: 'primary' | 'success' | 'info' | 'warning' | 'danger';
    }
    interface SlAnimation {
        /**
          * The number of milliseconds to delay the start of the animation.
         */
        "delay"?: number;
        /**
          * Determines the direction of playback as well as the behavior when reaching the end of an iteration.
         */
        "direction"?: PlaybackDirection;
        /**
          * The number of milliseconds each iteration of the animation takes to complete.
         */
        "duration"?: number;
        /**
          * The rate of the animation's change over time.
         */
        "easing"?: string;
        /**
          * The number of milliseconds to delay after the active period of an animation sequence.
         */
        "endDelay"?: number;
        /**
          * Sets how the animation applies styles to its target before and after its execution.
         */
        "fill"?: FillMode;
        /**
          * The offset at which to start the animation, usually between 0 (start) and 1 (end).
         */
        "iterationStart"?: number;
        /**
          * The number of iterations to run before the animation completes. Defaults to `Infinity`, which loops.
         */
        "iterations"?: number;
        /**
          * The keyframes to use for the animation. If this is set, `name` will be ignored.
         */
        "keyframes"?: Keyframe[];
        /**
          * The name of the animation to use.
         */
        "name"?: string;
        /**
          * Emitted when the animation is canceled.
         */
        "onSl-cancel"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the animation finishes.
         */
        "onSl-finish"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the animation starts or restarts.
         */
        "onSl-start"?: (event: CustomEvent<any>) => void;
        /**
          * Pauses the animation. The animation will resume when this prop is removed.
         */
        "pause"?: boolean;
        /**
          * Sets the animation's playback rate. The default is `1`, which plays the animation at a normal speed. Setting this to `2`, for example, will double the animation's speed. A negative value can be used to reverse the animation. This value can be changed without causing the animation to restart.
         */
        "playbackRate"?: number;
    }
    interface SlAvatar {
        /**
          * Alternative text for the image.
         */
        "alt"?: string;
        /**
          * The image source to use for the avatar.
         */
        "image"?: string;
        /**
          * Initials to use as a fallback when no image is available (1-2 characters max recommended).
         */
        "initials"?: string;
        /**
          * The shape of the avatar.
         */
        "shape"?: 'circle' | 'square' | 'rounded';
    }
    interface SlBadge {
        /**
          * Set to true to draw a pill-style badge with rounded edges.
         */
        "pill"?: boolean;
        /**
          * Set to true to make the badge pulsate to draw attention.
         */
        "pulse"?: boolean;
        /**
          * The badge's type.
         */
        "type"?: 'primary' | 'success' | 'info' | 'warning' | 'danger' | 'text';
    }
    interface SlButton {
        /**
          * Set to true to draw the button with a caret for use with dropdowns, popovers, etc.
         */
        "caret"?: boolean;
        /**
          * Set to true to draw a circle button.
         */
        "circle"?: boolean;
        /**
          * Set to true to disable the button.
         */
        "disabled"?: boolean;
        /**
          * Tells the browser to download the linked file as this filename. Only used when `href` is set.
         */
        "download"?: string;
        /**
          * When set, the underlying button will be rendered as an `<a>` with this `href` instead of a `<button>`.
         */
        "href"?: string;
        /**
          * Set to true to draw the button in a loading state.
         */
        "loading"?: boolean;
        /**
          * An optional name for the button. Ignored when `href` is set.
         */
        "name"?: string;
        /**
          * Emitted when the button loses focus.
         */
        "onSl-blur"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the button gains focus.
         */
        "onSl-focus"?: (event: CustomEvent<any>) => void;
        /**
          * Set to true to draw a pill-style button with rounded edges.
         */
        "pill"?: boolean;
        /**
          * The button's size.
         */
        "size"?: 'small' | 'medium' | 'large';
        /**
          * Indicates if activating the button should submit the form. Ignored when `href` is set.
         */
        "submit"?: boolean;
        /**
          * Tells the browser where to open the link. Only used when `href` is set.
         */
        "target"?: '_blank' | '_parent' | '_self' | '_top';
        /**
          * The button's type.
         */
        "type"?: 'default' | 'primary' | 'success' | 'info' | 'warning' | 'danger' | 'text';
        /**
          * An optional value for the button. Ignored when `href` is set.
         */
        "value"?: string;
    }
    interface SlButtonGroup {
        /**
          * A label to use for the button group's `aria-label` attribute.
         */
        "label"?: string;
    }
    interface SlCard {
    }
    interface SlCheckbox {
        /**
          * Set to true to draw the checkbox in a checked state.
         */
        "checked"?: boolean;
        /**
          * Set to true to disable the checkbox.
         */
        "disabled"?: boolean;
        /**
          * Set to true to draw the checkbox in an indeterminate state.
         */
        "indeterminate"?: boolean;
        /**
          * This will be true when the control is in an invalid state. Validity is determined by the `required` prop.
         */
        "invalid"?: boolean;
        /**
          * The checkbox's name attribute.
         */
        "name"?: string;
        /**
          * Emitted when the control loses focus.
         */
        "onSl-blur"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control's checked state changes.
         */
        "onSl-change"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control gains focus.
         */
        "onSl-focus"?: (event: CustomEvent<any>) => void;
        /**
          * Set to true to make the checkbox a required field.
         */
        "required"?: boolean;
        /**
          * The checkbox's value attribute.
         */
        "value"?: string;
    }
    interface SlColorPicker {
        /**
          * Set to true to disable the color picker.
         */
        "disabled"?: boolean;
        /**
          * The format to use for the display value. If opacity is enabled, these will translate to HEXA, RGBA, and HSLA respectively. The color picker will always accept user input in any format (including CSS color names) and convert it to the desired format.
         */
        "format"?: 'hex' | 'rgb' | 'hsl';
        /**
          * Enable this option to prevent the panel from being clipped when the component is placed inside a container with `overflow: auto|scroll`.
         */
        "hoist"?: boolean;
        /**
          * Set to true to render the color picker inline rather than inside a dropdown.
         */
        "inline"?: boolean;
        /**
          * This will be true when the control is in an invalid state. Validity is determined by the `setCustomValidity()` method using the browser's constraint validation API.
         */
        "invalid"?: boolean;
        /**
          * The input's name attribute.
         */
        "name"?: string;
        /**
          * Emitted after the color picker closes and all transitions are complete.
         */
        "onSl-after-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted after the color picker opens and all transitions are complete.
         */
        "onSl-after-show"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the color picker's value changes.
         */
        "onSl-change"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the color picker closes. Calling `event.preventDefault()` will prevent it from being closed.
         */
        "onSl-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the color picker opens. Calling `event.preventDefault()` will prevent it from being opened.
         */
        "onSl-show"?: (event: CustomEvent<any>) => void;
        /**
          * Whether to show the opacity slider.
         */
        "opacity"?: boolean;
        /**
          * Determines the size of the color picker's trigger. This has no effect on inline color pickers.
         */
        "size"?: 'small' | 'medium' | 'large';
        /**
          * An array of predefined color swatches to display. Can include any format the color picker can parse, including HEX(A), RGB(A), HSL(A), and CSS color names.
         */
        "swatches"?: string[];
        /**
          * By default, the value will be set in lowercase. Set this to true to set it in uppercase instead.
         */
        "uppercase"?: boolean;
        /**
          * The current color.
         */
        "value"?: string;
    }
    interface SlDetails {
        /**
          * Set to true to prevent the user from toggling the details.
         */
        "disabled"?: boolean;
        /**
          * Emitted after the details closes and all transitions are complete.
         */
        "onSl-after-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted after the details opens and all transitions are complete.
         */
        "onSl-after-show"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the details closes. Calling `event.preventDefault()` will prevent it from being closed.
         */
        "onSl-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the details opens. Calling `event.preventDefault()` will prevent it from being opened.
         */
        "onSl-show"?: (event: CustomEvent<any>) => void;
        /**
          * Indicates whether or not the details is open. You can use this in lieu of the show/hide methods.
         */
        "open"?: boolean;
        /**
          * The summary to show in the details header. If you need to display HTML, use the `summary` slot instead.
         */
        "summary"?: string;
    }
    interface SlDialog {
        /**
          * The dialog's label as displayed in the header. You should always include a relevant label even when using `no-header`, as it is required for proper accessibility.
         */
        "label"?: string;
        /**
          * Set to true to disable the header. This will also remove the default close button, so please ensure you provide an easy, accessible way for users to dismiss the dialog.
         */
        "noHeader"?: boolean;
        /**
          * Emitted after the dialog closes and all transitions are complete.
         */
        "onSl-after-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted after the dialog opens and all transitions are complete.
         */
        "onSl-after-show"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the dialog closes. Calling `event.preventDefault()` will prevent it from being closed.
         */
        "onSl-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the overlay is clicked. Calling `event.preventDefault()` will prevent the dialog from closing.
         */
        "onSl-overlay-dismiss"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the dialog opens. Calling `event.preventDefault()` will prevent it from being opened.
         */
        "onSl-show"?: (event: CustomEvent<any>) => void;
        /**
          * Indicates whether or not the dialog is open. You can use this in lieu of the show/hide methods.
         */
        "open"?: boolean;
    }
    interface SlDrawer {
        /**
          * By default, the drawer slides out of its containing block (usually the viewport). To make the drawer slide out of its parent element, set this prop and add `position: relative` to the parent.
         */
        "contained"?: boolean;
        /**
          * The drawer's label as displayed in the header. You should always include a relevant label even when using `no-header`, as it is required for proper accessibility.
         */
        "label"?: string;
        /**
          * Removes the header. This will also remove the default close button, so please ensure you provide an easy, accessible way for users to dismiss the drawer.
         */
        "noHeader"?: boolean;
        /**
          * Emitted after the drawer closes and all transitions are complete.
         */
        "onSl-after-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted after the drawer opens and all transitions are complete.
         */
        "onSl-after-show"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the drawer closes. Calling `event.preventDefault()` will prevent it from being closed.
         */
        "onSl-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the overlay is clicked. Calling `event.preventDefault()` will prevent the drawer from closing.
         */
        "onSl-overlay-dismiss"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the drawer opens. Calling `event.preventDefault()` will prevent it from being opened.
         */
        "onSl-show"?: (event: CustomEvent<any>) => void;
        /**
          * Indicates whether or not the drawer is open. You can use this in lieu of the show/hide methods.
         */
        "open"?: boolean;
        /**
          * The direction from which the drawer will open.
         */
        "placement"?: 'top' | 'right' | 'bottom' | 'left';
    }
    interface SlDropdown {
        /**
          * Determines whether the dropdown should hide when a menu item is selected.
         */
        "closeOnSelect"?: boolean;
        /**
          * The dropdown will close when the user interacts outside of this element (e.g. clicking).
         */
        "containingElement"?: HTMLElement;
        /**
          * The distance in pixels from which to offset the panel away from its trigger.
         */
        "distance"?: number;
        /**
          * Enable this option to prevent the panel from being clipped when the component is placed inside a container with `overflow: auto|scroll`.
         */
        "hoist"?: boolean;
        /**
          * Emitted after the dropdown closes and all transitions are complete.
         */
        "onSl-after-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted after the dropdown opens and all transitions are complete.
         */
        "onSl-after-show"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the dropdown closes. Calling `event.preventDefault()` will prevent it from being closed.
         */
        "onSl-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the dropdown opens. Calling `event.preventDefault()` will prevent it from being opened.
         */
        "onSl-show"?: (event: CustomEvent<any>) => void;
        /**
          * Indicates whether or not the dropdown is open. You can use this in lieu of the show/hide methods.
         */
        "open"?: boolean;
        /**
          * The preferred placement of the dropdown panel. Note that the actual placement may vary as needed to keep the panel inside of the viewport.
         */
        "placement"?: | 'top'
    | 'top-start'
    | 'top-end'
    | 'bottom'
    | 'bottom-start'
    | 'bottom-end'
    | 'right'
    | 'right-start'
    | 'right-end'
    | 'left'
    | 'left-start'
    | 'left-end';
        /**
          * The distance in pixels from which to offset the panel along its trigger.
         */
        "skidding"?: number;
    }
    interface SlForm {
        /**
          * Prevent the form from validating inputs before submitting.
         */
        "novalidate"?: boolean;
        /**
          * Emitted when the form is submitted. This event will not be emitted if any form control inside of it is in an invalid state, unless the form has the `novalidate` attribute. Note that there is never a need to prevent this event, since it doen't send a GET or POST request like native forms. To "prevent" submission, use a conditional around the XHR request you use to submit the form's data with.
         */
        "onSl-submit"?: (event: CustomEvent<{ formData: FormData; formControls: HTMLElement[] }>) => void;
    }
    interface SlFormatBytes {
        /**
          * The locale to use when formatting the number.
         */
        "locale"?: string;
        /**
          * The unit to display.
         */
        "unit"?: 'bytes' | 'bits';
        /**
          * The number to format in bytes.
         */
        "value"?: number;
    }
    interface SlIcon {
        /**
          * An alternative description to use for accessibility. If omitted, the name or src will be used to generate it.
         */
        "label"?: string;
        /**
          * The name of a registered custom icon library.
         */
        "library"?: string;
        /**
          * The name of the icon to draw.
         */
        "name"?: string;
        /**
          * Emitted when the icon failed to load.
         */
        "onSl-error"?: (event: CustomEvent<{ status?: number }>) => void;
        /**
          * Emitted when the icon has loaded.
         */
        "onSl-load"?: (event: CustomEvent<any>) => void;
        /**
          * An external URL of an SVG file.
         */
        "src"?: string;
    }
    interface SlIconButton {
        /**
          * Set to true to disable the button.
         */
        "disabled"?: boolean;
        /**
          * An alternative description to use for accessibility. If omitted, the name or src will be used to generate it.
         */
        "label"?: string;
        /**
          * The name of a registered custom icon library.
         */
        "library"?: string;
        /**
          * The name of the icon to draw.
         */
        "name"?: string;
        /**
          * An external URL of an SVG file.
         */
        "src"?: string;
    }
    interface SlIconLibrary {
        /**
          * A function that mutates the SVG element before it renders.
         */
        "mutator"?: IconLibraryMutator;
        /**
          * The name of the icon library.
         */
        "name"?: string;
        /**
          * A function that translates an icon name to a URL where the corresponding SVG file exists The URL can be local or a CORS-enabled endpoint.
         */
        "resolver"?: IconLibraryResolver;
    }
    interface SlImageComparer {
        /**
          * Emitted when the slider position changes.
         */
        "onSl-change"?: (event: CustomEvent<any>) => void;
        /**
          * The position of the divider as a percentage.
         */
        "position"?: number;
    }
    interface SlInclude {
        /**
          * The fetch mode to use.
         */
        "mode"?: 'cors' | 'no-cors' | 'same-origin';
        /**
          * Emitted when the included file fails to load due to an error.
         */
        "onSl-error"?: (event: CustomEvent<{ status?: number }>) => void;
        /**
          * Emitted when the included file is loaded.
         */
        "onSl-load"?: (event: CustomEvent<any>) => void;
        /**
          * The location of the HTML file to include.
         */
        "src"?: string;
    }
    interface SlInput {
        /**
          * The input's autocaptialize attribute.
         */
        "autocapitalize"?: string;
        /**
          * The input's autocomplete attribute.
         */
        "autocomplete"?: string;
        /**
          * The input's autocorrect attribute.
         */
        "autocorrect"?: string;
        /**
          * The input's autofocus attribute.
         */
        "autofocus"?: boolean;
        /**
          * Set to true to add a clear button when the input is populated.
         */
        "clearable"?: boolean;
        /**
          * Set to true to disable the input.
         */
        "disabled"?: boolean;
        /**
          * The input's inputmode attribute.
         */
        "inputmode"?: 'none' | 'text' | 'decimal' | 'numeric' | 'tel' | 'search' | 'email' | 'url';
        /**
          * This will be true when the control is in an invalid state. Validity is determined by props such as `type`, `required`, `minlength`, `maxlength`, and `pattern` using the browser's constraint validation API.
         */
        "invalid"?: boolean;
        /**
          * The input's label.
         */
        "label"?: string;
        /**
          * The input's maximum value.
         */
        "max"?: number;
        /**
          * The maximum length of input that will be considered valid.
         */
        "maxlength"?: number;
        /**
          * The input's minimum value.
         */
        "min"?: number;
        /**
          * The minimum length of input that will be considered valid.
         */
        "minlength"?: number;
        /**
          * The input's name attribute.
         */
        "name"?: string;
        /**
          * Emitted when the control loses focus.
         */
        "onSl-blur"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control's value changes.
         */
        "onSl-change"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the clear button is activated.
         */
        "onSl-clear"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control gains focus.
         */
        "onSl-focus"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control receives input.
         */
        "onSl-input"?: (event: CustomEvent<any>) => void;
        /**
          * A pattern to validate input against.
         */
        "pattern"?: string;
        /**
          * Set to true to draw a pill-style input with rounded edges.
         */
        "pill"?: boolean;
        /**
          * The input's placeholder text.
         */
        "placeholder"?: string;
        /**
          * Set to true to make the input readonly.
         */
        "readonly"?: boolean;
        /**
          * Set to true to make the input a required field.
         */
        "required"?: boolean;
        /**
          * The input's size.
         */
        "size"?: 'small' | 'medium' | 'large';
        /**
          * Enables spell checking on the input.
         */
        "spellcheck"?: boolean;
        /**
          * The input's step attribute.
         */
        "step"?: number;
        /**
          * Set to true to add a password toggle button for password inputs.
         */
        "togglePassword"?: boolean;
        /**
          * The input's type.
         */
        "type"?: 'email' | 'number' | 'password' | 'search' | 'tel' | 'text' | 'url';
        /**
          * The input's value attribute.
         */
        "value"?: string;
    }
    interface SlMenu {
        /**
          * Emitted when the menu loses focus.
         */
        "onSl-blur"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the menu gains focus.
         */
        "onSl-focus"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when a menu item is selected.
         */
        "onSl-select"?: (event: CustomEvent<{ item: HTMLSlMenuItemElement }>) => void;
    }
    interface SlMenuDivider {
    }
    interface SlMenuItem {
        /**
          * Draws the menu in an active (i.e. or hover/focus), state to indicate the current menu selection. This is used in lieu of standard :hover and :focus states to prevent concurrent interactions from different devices, such as focusing with the keyboard and hovering with the mouse.
         */
        "active"?: boolean;
        /**
          * Set to true to draw the item in a checked state.
         */
        "checked"?: boolean;
        /**
          * Set to true to draw the menu item in a disabled state.
         */
        "disabled"?: boolean;
        /**
          * Emitted when the menu item becomes active.
         */
        "onSl-activate"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the menu item becomes inactive.
         */
        "onSl-deactivate"?: (event: CustomEvent<any>) => void;
        /**
          * A unique value to store in the menu item.
         */
        "value"?: string;
    }
    interface SlMenuLabel {
    }
    interface SlProgressBar {
        /**
          * The progress bar's percentage, 0 to 100.
         */
        "percentage"?: number;
    }
    interface SlProgressRing {
        /**
          * The current progress percentage, 0 - 100.
         */
        "percentage"?: number;
        /**
          * The size of the progress ring in pixels.
         */
        "size"?: number;
        /**
          * The stroke width of the progress ring in pixels.
         */
        "strokeWidth"?: number;
    }
    interface SlRadio {
        /**
          * Set to true to draw the radio in a checked state.
         */
        "checked"?: boolean;
        /**
          * Set to true to disable the radio.
         */
        "disabled"?: boolean;
        /**
          * This will be true when the control is in an invalid state. Validity in range inputs is determined by the message provided by the `setCustomValidity` method.
         */
        "invalid"?: boolean;
        /**
          * The radio's name attribute.
         */
        "name"?: string;
        /**
          * Emitted when the control loses focus.
         */
        "onSl-blur"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control's checked state changes.
         */
        "onSl-change"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control gains focus.
         */
        "onSl-focus"?: (event: CustomEvent<any>) => void;
        /**
          * The radio's value attribute.
         */
        "value"?: string;
    }
    interface SlRange {
        /**
          * Set to true to disable the input.
         */
        "disabled"?: boolean;
        /**
          * This will be true when the control is in an invalid state. Validity in range inputs is determined by the message provided by the `setCustomValidity` method.
         */
        "invalid"?: boolean;
        /**
          * The input's max attribute.
         */
        "max"?: number;
        /**
          * The input's min attribute.
         */
        "min"?: number;
        /**
          * The input's name attribute.
         */
        "name"?: string;
        /**
          * Emitted when the control loses focus.
         */
        "onSl-blur"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control's value changes.
         */
        "onSl-change"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control gains focus.
         */
        "onSl-focus"?: (event: CustomEvent<any>) => void;
        /**
          * The input's step attribute.
         */
        "step"?: number;
        /**
          * The preferred placedment of the tooltip.
         */
        "tooltip"?: 'top' | 'bottom' | 'none';
        /**
          * A function used to format the tooltip's value.
         */
        "tooltipFormatter"?: (value: number) => string;
        /**
          * The input's value attribute.
         */
        "value"?: number;
    }
    interface SlRating {
        /**
          * Disables the rating.
         */
        "disabled"?: boolean;
        /**
          * A function that returns the symbols to display. Accepts an option `value` parameter you can use to map a specific symbol to a value.
         */
        "getSymbol"?: (value?: number) => string;
        /**
          * The highest rating to show.
         */
        "max"?: number;
        /**
          * Emitted when the rating's value changes.
         */
        "onSl-change"?: (event: CustomEvent<any>) => void;
        /**
          * The minimum increment value allowed by the control.
         */
        "precision"?: number;
        /**
          * Makes the rating readonly.
         */
        "readonly"?: boolean;
        /**
          * The current rating.
         */
        "value"?: number;
    }
    interface SlResponsiveEmbed {
        /**
          * The aspect ratio of the embedded media in the format of `width:height`, e.g. `16:9`, `4:3`, or `1:1`. Ratios not in this format will be ignored.
         */
        "aspectRatio"?: string;
    }
    interface SlSelect {
        /**
          * Set to true to add a clear button when the select is populated.
         */
        "clearable"?: boolean;
        /**
          * Set to true to disable the select control.
         */
        "disabled"?: boolean;
        /**
          * Enable this option to prevent the panel from being clipped when the component is placed inside a container with `overflow: auto|scroll`.
         */
        "hoist"?: boolean;
        /**
          * This will be true when the control is in an invalid state. Validity is determined by the `required` prop.
         */
        "invalid"?: boolean;
        /**
          * The select's label.
         */
        "label"?: string;
        /**
          * The maximum number of tags to show when `multiple` is true. After the maximum, "+n" will be shown to indicate the number of additional items that are selected. Set to -1 to remove the limit.
         */
        "maxTagsVisible"?: number;
        /**
          * Set to true to enable multiselect.
         */
        "multiple"?: boolean;
        /**
          * The select's name.
         */
        "name"?: string;
        /**
          * Emitted when the control loses focus
         */
        "onSl-blur"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control's value changes.
         */
        "onSl-change"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control gains focus
         */
        "onSl-focus"?: (event: CustomEvent<any>) => void;
        /**
          * Set to true to draw a pill-style select with rounded edges.
         */
        "pill"?: boolean;
        /**
          * The select's placeholder text.
         */
        "placeholder"?: string;
        /**
          * The select's required attribute.
         */
        "required"?: boolean;
        /**
          * The select's size.
         */
        "size"?: 'small' | 'medium' | 'large';
        /**
          * The value of the control. This will be a string or an array depending on `multiple`.
         */
        "value"?: string | Array<string>;
    }
    interface SlSkeleton {
        /**
          * Determines which effect the skeleton will use.
         */
        "effect"?: 'pulse' | 'sheen' | 'none';
    }
    interface SlSpinner {
    }
    interface SlSwitch {
        /**
          * Set to true to draw the switch in a checked state.
         */
        "checked"?: boolean;
        /**
          * Set to true to disable the switch.
         */
        "disabled"?: boolean;
        /**
          * This will be true when the control is in an invalid state. Validity is determined by the `required` prop.
         */
        "invalid"?: boolean;
        /**
          * The switch's name attribute.
         */
        "name"?: string;
        /**
          * Emitted when the control loses focus.
         */
        "onSl-blur"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control's checked state changes.
         */
        "onSl-change"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control gains focus.
         */
        "onSl-focus"?: (event: CustomEvent<any>) => void;
        /**
          * Set to true to make the switch a required field.
         */
        "required"?: boolean;
        /**
          * The switch's value attribute.
         */
        "value"?: string;
    }
    interface SlTab {
        /**
          * Set to true to draw the tab in an active state.
         */
        "active"?: boolean;
        /**
          * Set to true to draw the tab in a disabled state.
         */
        "disabled"?: boolean;
        /**
          * The name of the tab panel the tab will control. The panel must be located in the same tab group.
         */
        "panel"?: string;
    }
    interface SlTabGroup {
        /**
          * Emitted when a tab is hidden.
         */
        "onSl-tab-hide"?: (event: CustomEvent<{ name: string }>) => void;
        /**
          * Emitted when a tab is shown.
         */
        "onSl-tab-show"?: (event: CustomEvent<{ name: string }>) => void;
        /**
          * The placement of the tabs.
         */
        "placement"?: 'top' | 'bottom' | 'left' | 'right';
    }
    interface SlTabPanel {
        /**
          * When true, the tab panel will be shown.
         */
        "active"?: boolean;
        /**
          * The tab panel's name.
         */
        "name"?: string;
    }
    interface SlTag {
        /**
          * Set to true to make the tag clearable.
         */
        "clearable"?: boolean;
        /**
          * Emitted when the clear button is activated.
         */
        "onSl-clear"?: (event: CustomEvent<any>) => void;
        /**
          * Set to true to draw a pill-style tag with rounded edges.
         */
        "pill"?: boolean;
        /**
          * The tag's size.
         */
        "size"?: 'small' | 'medium' | 'large';
        /**
          * The tag's type.
         */
        "type"?: 'primary' | 'success' | 'info' | 'warning' | 'danger' | 'text';
    }
    interface SlTextarea {
        /**
          * The textarea's autocaptialize attribute.
         */
        "autocapitalize"?: string;
        /**
          * The textarea's autocomplete attribute.
         */
        "autocomplete"?: string;
        /**
          * The textarea's autocorrect attribute.
         */
        "autocorrect"?: string;
        /**
          * The textarea's autofocus attribute.
         */
        "autofocus"?: boolean;
        /**
          * Set to true to disable the textarea.
         */
        "disabled"?: boolean;
        /**
          * The textarea's inputmode attribute.
         */
        "inputmode"?: 'none' | 'text' | 'decimal' | 'numeric' | 'tel' | 'search' | 'email' | 'url';
        /**
          * This will be true when the control is in an invalid state. Validity is determined by props such as `required`, `minlength`, and `maxlength` using the browser's constraint validation API.
         */
        "invalid"?: boolean;
        /**
          * The textarea's label.
         */
        "label"?: string;
        /**
          * The maximum length of input that will be considered valid.
         */
        "maxlength"?: number;
        /**
          * The minimum length of input that will be considered valid.
         */
        "minlength"?: number;
        /**
          * The textarea's name attribute.
         */
        "name"?: string;
        /**
          * Emitted when the control loses focus.
         */
        "onSl-blur"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control's value changes.
         */
        "onSl-change"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control gains focus.
         */
        "onSl-focus"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the control receives input.
         */
        "onSl-input"?: (event: CustomEvent<any>) => void;
        /**
          * The textarea's placeholder text.
         */
        "placeholder"?: string;
        /**
          * Set to true for a readonly textarea.
         */
        "readonly"?: boolean;
        /**
          * The textarea's required attribute.
         */
        "required"?: boolean;
        /**
          * Controls how the textarea can be resized.
         */
        "resize"?: 'none' | 'vertical' | 'auto';
        /**
          * The number of rows to display by default.
         */
        "rows"?: number;
        /**
          * The textarea's size.
         */
        "size"?: 'small' | 'medium' | 'large';
        /**
          * The textarea's spellcheck attribute.
         */
        "spellcheck"?: boolean;
        /**
          * The textarea's value attribute.
         */
        "value"?: string;
    }
    interface SlTooltip {
        /**
          * The tooltip's content.
         */
        "content"?: string;
        /**
          * Set to true to disable the tooltip so it won't show when triggered.
         */
        "disabled"?: boolean;
        /**
          * The distance in pixels from which to offset the tooltip away from its target.
         */
        "distance"?: number;
        /**
          * Emitted after the tooltip has hidden and all transitions are complete.
         */
        "onSl-after-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted after the tooltip has shown and all transitions are complete.
         */
        "onSl-aftershow"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the tooltip begins to hide. Calling `event.preventDefault()` will prevent it from being hidden.
         */
        "onSl-hide"?: (event: CustomEvent<any>) => void;
        /**
          * Emitted when the tooltip begins to show. Calling `event.preventDefault()` will prevent it from being shown.
         */
        "onSl-show"?: (event: CustomEvent<any>) => void;
        /**
          * Indicates whether or not the tooltip is open. You can use this in lieu of the show/hide methods.
         */
        "open"?: boolean;
        /**
          * The preferred placement of the tooltip. Note that the actual placement may vary as needed to keep the tooltip inside of the viewport.
         */
        "placement"?: | 'top'
    | 'top-start'
    | 'top-end'
    | 'right'
    | 'right-start'
    | 'right-end'
    | 'bottom'
    | 'bottom-start'
    | 'bottom-end'
    | 'left'
    | 'left-start'
    | 'left-end';
        /**
          * The distance in pixels from which to offset the tooltip along its target.
         */
        "skidding"?: number;
        /**
          * Controls how the tooltip is activated. Possible options include `click`, `hover`, `focus`, and `manual`. Multiple options can be passed by separating them with a space. When manual is used, the tooltip must be activated programmatically.
         */
        "trigger"?: string;
    }
    interface IntrinsicElements {
        "sl-alert": SlAlert;
        "sl-animation": SlAnimation;
        "sl-avatar": SlAvatar;
        "sl-badge": SlBadge;
        "sl-button": SlButton;
        "sl-button-group": SlButtonGroup;
        "sl-card": SlCard;
        "sl-checkbox": SlCheckbox;
        "sl-color-picker": SlColorPicker;
        "sl-details": SlDetails;
        "sl-dialog": SlDialog;
        "sl-drawer": SlDrawer;
        "sl-dropdown": SlDropdown;
        "sl-form": SlForm;
        "sl-format-bytes": SlFormatBytes;
        "sl-icon": SlIcon;
        "sl-icon-button": SlIconButton;
        "sl-icon-library": SlIconLibrary;
        "sl-image-comparer": SlImageComparer;
        "sl-include": SlInclude;
        "sl-input": SlInput;
        "sl-menu": SlMenu;
        "sl-menu-divider": SlMenuDivider;
        "sl-menu-item": SlMenuItem;
        "sl-menu-label": SlMenuLabel;
        "sl-progress-bar": SlProgressBar;
        "sl-progress-ring": SlProgressRing;
        "sl-radio": SlRadio;
        "sl-range": SlRange;
        "sl-rating": SlRating;
        "sl-responsive-embed": SlResponsiveEmbed;
        "sl-select": SlSelect;
        "sl-skeleton": SlSkeleton;
        "sl-spinner": SlSpinner;
        "sl-switch": SlSwitch;
        "sl-tab": SlTab;
        "sl-tab-group": SlTabGroup;
        "sl-tab-panel": SlTabPanel;
        "sl-tag": SlTag;
        "sl-textarea": SlTextarea;
        "sl-tooltip": SlTooltip;
    }
}
export { LocalJSX as JSX };
declare module "@stencil/core" {
    export namespace JSX {
        interface IntrinsicElements {
            "sl-alert": LocalJSX.SlAlert & JSXBase.HTMLAttributes<HTMLSlAlertElement>;
            "sl-animation": LocalJSX.SlAnimation & JSXBase.HTMLAttributes<HTMLSlAnimationElement>;
            "sl-avatar": LocalJSX.SlAvatar & JSXBase.HTMLAttributes<HTMLSlAvatarElement>;
            "sl-badge": LocalJSX.SlBadge & JSXBase.HTMLAttributes<HTMLSlBadgeElement>;
            "sl-button": LocalJSX.SlButton & JSXBase.HTMLAttributes<HTMLSlButtonElement>;
            "sl-button-group": LocalJSX.SlButtonGroup & JSXBase.HTMLAttributes<HTMLSlButtonGroupElement>;
            "sl-card": LocalJSX.SlCard & JSXBase.HTMLAttributes<HTMLSlCardElement>;
            "sl-checkbox": LocalJSX.SlCheckbox & JSXBase.HTMLAttributes<HTMLSlCheckboxElement>;
            "sl-color-picker": LocalJSX.SlColorPicker & JSXBase.HTMLAttributes<HTMLSlColorPickerElement>;
            "sl-details": LocalJSX.SlDetails & JSXBase.HTMLAttributes<HTMLSlDetailsElement>;
            "sl-dialog": LocalJSX.SlDialog & JSXBase.HTMLAttributes<HTMLSlDialogElement>;
            "sl-drawer": LocalJSX.SlDrawer & JSXBase.HTMLAttributes<HTMLSlDrawerElement>;
            "sl-dropdown": LocalJSX.SlDropdown & JSXBase.HTMLAttributes<HTMLSlDropdownElement>;
            "sl-form": LocalJSX.SlForm & JSXBase.HTMLAttributes<HTMLSlFormElement>;
            "sl-format-bytes": LocalJSX.SlFormatBytes & JSXBase.HTMLAttributes<HTMLSlFormatBytesElement>;
            "sl-icon": LocalJSX.SlIcon & JSXBase.HTMLAttributes<HTMLSlIconElement>;
            "sl-icon-button": LocalJSX.SlIconButton & JSXBase.HTMLAttributes<HTMLSlIconButtonElement>;
            "sl-icon-library": LocalJSX.SlIconLibrary & JSXBase.HTMLAttributes<HTMLSlIconLibraryElement>;
            "sl-image-comparer": LocalJSX.SlImageComparer & JSXBase.HTMLAttributes<HTMLSlImageComparerElement>;
            "sl-include": LocalJSX.SlInclude & JSXBase.HTMLAttributes<HTMLSlIncludeElement>;
            "sl-input": LocalJSX.SlInput & JSXBase.HTMLAttributes<HTMLSlInputElement>;
            "sl-menu": LocalJSX.SlMenu & JSXBase.HTMLAttributes<HTMLSlMenuElement>;
            "sl-menu-divider": LocalJSX.SlMenuDivider & JSXBase.HTMLAttributes<HTMLSlMenuDividerElement>;
            "sl-menu-item": LocalJSX.SlMenuItem & JSXBase.HTMLAttributes<HTMLSlMenuItemElement>;
            "sl-menu-label": LocalJSX.SlMenuLabel & JSXBase.HTMLAttributes<HTMLSlMenuLabelElement>;
            "sl-progress-bar": LocalJSX.SlProgressBar & JSXBase.HTMLAttributes<HTMLSlProgressBarElement>;
            "sl-progress-ring": LocalJSX.SlProgressRing & JSXBase.HTMLAttributes<HTMLSlProgressRingElement>;
            "sl-radio": LocalJSX.SlRadio & JSXBase.HTMLAttributes<HTMLSlRadioElement>;
            "sl-range": LocalJSX.SlRange & JSXBase.HTMLAttributes<HTMLSlRangeElement>;
            "sl-rating": LocalJSX.SlRating & JSXBase.HTMLAttributes<HTMLSlRatingElement>;
            "sl-responsive-embed": LocalJSX.SlResponsiveEmbed & JSXBase.HTMLAttributes<HTMLSlResponsiveEmbedElement>;
            "sl-select": LocalJSX.SlSelect & JSXBase.HTMLAttributes<HTMLSlSelectElement>;
            "sl-skeleton": LocalJSX.SlSkeleton & JSXBase.HTMLAttributes<HTMLSlSkeletonElement>;
            "sl-spinner": LocalJSX.SlSpinner & JSXBase.HTMLAttributes<HTMLSlSpinnerElement>;
            "sl-switch": LocalJSX.SlSwitch & JSXBase.HTMLAttributes<HTMLSlSwitchElement>;
            "sl-tab": LocalJSX.SlTab & JSXBase.HTMLAttributes<HTMLSlTabElement>;
            "sl-tab-group": LocalJSX.SlTabGroup & JSXBase.HTMLAttributes<HTMLSlTabGroupElement>;
            "sl-tab-panel": LocalJSX.SlTabPanel & JSXBase.HTMLAttributes<HTMLSlTabPanelElement>;
            "sl-tag": LocalJSX.SlTag & JSXBase.HTMLAttributes<HTMLSlTagElement>;
            "sl-textarea": LocalJSX.SlTextarea & JSXBase.HTMLAttributes<HTMLSlTextareaElement>;
            "sl-tooltip": LocalJSX.SlTooltip & JSXBase.HTMLAttributes<HTMLSlTooltipElement>;
        }
    }
}
