'use strict';

const index = require('./index-40efc276.js');

const FormControl = (props, children) => {
  const hasLabel = props.label ? true : props.hasLabelSlot;
  const hasHelpText = props.helpText ? true : props.hasHelpTextSlot;
  return (index.h("div", { part: "form-control", class: {
      'form-control': true,
      'form-control--small': props.size === 'small',
      'form-control--medium': props.size === 'medium',
      'form-control--large': props.size === 'large',
      'form-control--has-label': hasLabel,
      'form-control--has-help-text': hasHelpText
    } },
    index.h("label", { part: "label", id: props.labelId, class: "form-control__label", htmlFor: props.inputId, "aria-hidden": hasLabel ? 'false' : 'true', onClick: props.onLabelClick },
      index.h("slot", { name: "label" }, props.label)),
    index.h("div", { class: "form-control__input" }, children),
    index.h("div", { part: "help-text", id: props.helpTextId, class: "form-control__help-text", "aria-hidden": hasHelpText ? 'false' : 'true' },
      index.h("slot", { name: "help-text" }, props.helpText))));
};

exports.FormControl = FormControl;
