'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-40efc276.js');
const focusVisible = require('./focus-visible-887fe7c9.js');

const iconButtonCss = ":host{position:relative;box-sizing:border-box}:host *,:host *:before,:host *:after{box-sizing:inherit}:host{display:inline-block}.icon-button{flex:0 0 auto;display:flex;align-items:center;background:none;border:none;border-radius:var(--sl-border-radius-medium);font-size:inherit;color:var(--sl-color-gray-500);padding:var(--sl-spacing-x-small);cursor:pointer;transition:var(--sl-transition-medium) color;-webkit-appearance:none}.icon-button:hover:not(.icon-button--disabled),.icon-button:focus:not(.icon-button--disabled){color:var(--sl-color-primary-500)}.icon-button:active:not(.icon-button--disabled){color:var(--sl-color-primary-600)}.icon-button:focus{outline:none}.icon-button--disabled{opacity:0.5;cursor:not-allowed}.focus-visible.icon-button:focus{box-shadow:0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-primary)}";

const IconButton = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    /** Set to true to disable the button. */
    this.disabled = false;
  }
  componentDidLoad() {
    focusVisible.focusVisible.observe(this.button);
  }
  disconnectedCallback() {
    focusVisible.focusVisible.unobserve(this.button);
  }
  render() {
    return (index.h("button", { ref: el => (this.button = el), part: "base", class: {
        'icon-button': true,
        'icon-button--disabled': this.disabled
      }, type: "button", "aria-label": this.label }, index.h("sl-icon", { library: this.library, name: this.name, src: this.src, "aria-hidden": "true" })));
  }
};
IconButton.style = iconButtonCss;

exports.sl_icon_button = IconButton;
